/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;

public class DSpaceH2Dialect
extends H2Dialect {
    private static Map<String, Pattern> regexCache = new HashMap<String, Pattern>();

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        functionContributions.getFunctionRegistry().registerPattern("matches", "matches(?1, ?2)", basicTypeRegistry.resolve(StandardBasicTypes.BOOLEAN));
    }

    public static boolean matches(String regex, String value) {
        Pattern pattern = regexCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            regexCache.put(regex, pattern);
        }
        return pattern.matcher(value).matches();
    }
}

