/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflow;

import jakarta.inject.Inject;
import java.util.List;
import java.util.regex.Pattern;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.ctask.testing.MarkerTask;
import org.dspace.eperson.EPerson;
import org.dspace.util.DSpaceConfigurationInitializer;
import org.dspace.util.DSpaceKernelInitializer;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@ContextConfiguration(initializers={DSpaceKernelInitializer.class, DSpaceConfigurationInitializer.class}, locations={"classpath:spring/*.xml"})
public class WorkflowCurationIT
extends AbstractIntegrationTestWithDatabase {
    @Inject
    private ItemService itemService;

    @Test
    public void curationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson(this.context).withEmail("submitter@example.com").withPassword(this.password).withLanguage("en").build();
        Community community = CommunityBuilder.createCommunity(this.context).withName("Community").build();
        String CURATION_COLLECTION_HANDLE = "123456789/curation-test-1";
        Collection collection = CollectionBuilder.createCollection(this.context, community, "123456789/curation-test-1").withName("Collection").build();
        this.context.setCurrentUser(submitter);
        XmlWorkflowItem wfi = WorkflowItemBuilder.createWorkflowItem(this.context, collection).withTitle("Test of workflow curation").withIssueDate("2021-05-14").withSubject("Testing").build();
        this.context.restoreAuthSystemState();
        List provenance = this.itemService.getMetadata((DSpaceObject)wfi.getItem(), MarkerTask.SCHEMA, "description", "provenance", MarkerTask.LANGUAGE);
        Pattern markerPattern = Pattern.compile(MarkerTask.class.getCanonicalName());
        boolean found = false;
        for (MetadataValue record : provenance) {
            if (!markerPattern.matcher(record.getValue()).find()) continue;
            found = true;
            break;
        }
        MatcherAssert.assertThat((String)"Item should have been curated", (boolean)found);
    }
}

