/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.MetadataExportFilteredItemsReportScriptConfiguration;
import org.dspace.content.MetadataDSpaceCsvExportServiceImpl;
import org.dspace.content.MetadataField;
import org.dspace.content.factory.ContentReportServiceFactory;
import org.dspace.content.service.MetadataDSpaceCsvExportService;
import org.dspace.contentreport.Filter;
import org.dspace.contentreport.FilteredItems;
import org.dspace.contentreport.FilteredItemsQuery;
import org.dspace.contentreport.QueryOperator;
import org.dspace.contentreport.QueryPredicate;
import org.dspace.contentreport.service.ContentReportService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.kernel.ServiceManager;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.services.ConfigurationService;
import org.dspace.utils.DSpace;

public class MetadataExportFilteredItemsReport
extends DSpaceRunnable<MetadataExportFilteredItemsReportScriptConfiguration<MetadataExportFilteredItemsReport>> {
    private static final String EXPORT_CSV = "exportCSV";
    public static final String DEFAULT_FILENAME = "metadataExportFilteredItems.csv";
    private boolean help = false;
    private String[] collectionUuids;
    private String[] queryPredicates;
    private String[] queryFilters;
    private ConfigurationService configurationService;
    private ContentReportService contentReportService;
    private EPersonService ePersonService;
    private MetadataDSpaceCsvExportService metadataDSpaceCsvExportService;

    @Override
    public MetadataExportFilteredItemsReportScriptConfiguration<MetadataExportFilteredItemsReport> getScriptConfiguration() {
        return (MetadataExportFilteredItemsReportScriptConfiguration)new DSpace().getServiceManager().getServiceByName("metadata-export-filtered-items-report", MetadataExportFilteredItemsReportScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        ServiceManager serviceManager = new DSpace().getServiceManager();
        this.configurationService = (ConfigurationService)serviceManager.getServicesByType(ConfigurationService.class).get(0);
        this.contentReportService = ContentReportServiceFactory.getInstance().getContentReportService();
        this.ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        this.metadataDSpaceCsvExportService = (MetadataDSpaceCsvExportService)serviceManager.getServiceByName(MetadataDSpaceCsvExportServiceImpl.class.getCanonicalName(), MetadataDSpaceCsvExportService.class);
        if (this.commandLine.hasOption('h')) {
            this.help = true;
            return;
        }
        if (this.commandLine.hasOption('c')) {
            this.collectionUuids = this.commandLine.getOptionValues('c');
        }
        if (this.commandLine.hasOption("qp")) {
            this.queryPredicates = this.commandLine.getOptionValues("qp");
        }
        if (this.commandLine.hasOption('f')) {
            this.queryFilters = this.commandLine.getOptionValues('f');
        }
    }

    @Override
    public void internalRun() throws Exception {
        if (this.help) {
            this.loghelpinfo();
            this.printHelp();
            return;
        }
        this.handler.logDebug("starting content report export");
        Context context = new Context();
        context.setCurrentUser((EPerson)this.ePersonService.find(context, this.getEpersonIdentifier()));
        List<String> collUuids = List.of();
        if (this.collectionUuids != null) {
            Set setUuids = MetadataExportFilteredItemsReport.arrayToStream(this.collectionUuids).map(uuids -> uuids.split("[^0-9A-Fa-f\\-]+")).flatMap(Arrays::stream).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            collUuids = new ArrayList(setUuids);
        }
        List<QueryPredicate> predicates = List.of();
        if (this.queryPredicates != null) {
            predicates = MetadataExportFilteredItemsReport.arrayToStream(this.queryPredicates).filter(StringUtils::isNotBlank).map(pred -> this.buildPredicate(context, (String)pred)).collect(Collectors.toList());
        }
        EnumSet<Filter> filters = EnumSet.noneOf(Filter.class);
        if (this.queryFilters != null) {
            Arrays.stream(this.queryFilters).map(Filter::getFilters).flatMap(Collection::stream).filter(f -> f != null).forEach(filters::add);
        }
        this.handler.logDebug("building query");
        FilteredItemsQuery query = FilteredItemsQuery.of(collUuids, predicates, 0L, Integer.MAX_VALUE, filters, List.of());
        this.handler.logDebug("creating iterator");
        FilteredItems items = this.contentReportService.findFilteredItems(context, query);
        this.handler.logDebug("creating dspacecsv");
        DSpaceCSV dSpaceCSV = this.metadataDSpaceCsvExportService.export(context, items.getItems().iterator(), true, this.handler);
        this.handler.logDebug("writing to file " + this.getFileNameOrExportFile());
        this.handler.writeFilestream(context, this.getFileNameOrExportFile(), dSpaceCSV.getInputStream(), EXPORT_CSV);
        context.restoreAuthSystemState();
        context.complete();
    }

    protected void loghelpinfo() {
        this.handler.logInfo("metadata-export-filtered-items-report");
    }

    protected String getFileNameOrExportFile() {
        return this.configurationService.getProperty("contentreport.metadataquery.csv.filename.default", DEFAULT_FILENAME);
    }

    private static Stream<String> arrayToStream(String ... array) {
        return Optional.ofNullable(array).stream().flatMap(Arrays::stream).filter(StringUtils::isNotBlank);
    }

    private QueryPredicate buildPredicate(Context context, String exp) {
        String[] tokens = exp.split("\\:");
        String field = tokens.length > 0 ? tokens[0].trim() : "";
        QueryOperator operator = tokens.length > 1 ? QueryOperator.get(tokens[1].trim()) : null;
        String value = tokens.length > 2 ? StringUtils.trimToEmpty((String)tokens[2]) : "";
        try {
            List<MetadataField> fields = this.contentReportService.getMetadataFields(context, field);
            return QueryPredicate.of(fields, operator, value);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

