/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.harvest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.harvest.HarvestScriptConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.HarvestingException;
import org.dspace.harvest.OAIHarvester;
import org.dspace.harvest.factory.HarvestServiceFactory;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.utils.DSpace;

public class Harvest
extends DSpaceRunnable<HarvestScriptConfiguration> {
    private HarvestedCollectionService harvestedCollectionService;
    protected EPersonService ePersonService;
    private CollectionService collectionService;
    private boolean help;
    private String command = null;
    private String collection = null;
    private String oaiSource = null;
    private String oaiSetID = null;
    private String metadataKey = null;
    private int harvestType = 0;
    protected Context context;

    @Override
    public HarvestScriptConfiguration getScriptConfiguration() {
        return (HarvestScriptConfiguration)new DSpace().getServiceManager().getServiceByName("harvest", HarvestScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        this.harvestedCollectionService = HarvestServiceFactory.getInstance().getHarvestedCollectionService();
        this.ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
        this.collectionService = ContentServiceFactory.getInstance().getCollectionService();
        this.assignCurrentUserInContext();
        this.help = this.commandLine.hasOption('h');
        if (this.commandLine.hasOption('s')) {
            this.command = "config";
        }
        if (this.commandLine.hasOption('p')) {
            this.command = "purge";
        }
        if (this.commandLine.hasOption('r')) {
            this.command = "run";
        }
        if (this.commandLine.hasOption('g')) {
            this.command = "ping";
        }
        if (this.commandLine.hasOption('S')) {
            this.command = "start";
        }
        if (this.commandLine.hasOption('R')) {
            this.command = "reset";
        }
        if (this.commandLine.hasOption('P')) {
            this.command = "purgeAll";
        }
        if (this.commandLine.hasOption('o')) {
            this.command = "reimport";
        }
        if (this.commandLine.hasOption('c')) {
            this.collection = this.commandLine.getOptionValue('c');
        }
        this.harvestType = this.commandLine.hasOption('t') ? Integer.parseInt(this.commandLine.getOptionValue('t')) : 0;
        if (this.commandLine.hasOption('a')) {
            this.oaiSource = this.commandLine.getOptionValue('a');
        }
        if (this.commandLine.hasOption('i')) {
            this.oaiSetID = this.commandLine.getOptionValue('i');
        }
        if (this.commandLine.hasOption('m')) {
            this.metadataKey = this.commandLine.getOptionValue('m');
        }
    }

    protected void assignCurrentUserInContext() throws ParseException {
        UUID currentUserUuid = this.getEpersonIdentifier();
        try {
            this.context = new Context(Context.Mode.BATCH_EDIT);
            EPerson eperson = (EPerson)this.ePersonService.find(this.context, currentUserUuid);
            if (eperson == null) {
                this.handler.logError("EPerson not found: " + currentUserUuid);
                throw new IllegalArgumentException("Unable to find a user with uuid: " + currentUserUuid);
            }
            this.context.setCurrentUser(eperson);
        }
        catch (SQLException e) {
            this.handler.handleException("Something went wrong trying to fetch eperson for uuid: " + currentUserUuid, e);
        }
    }

    @Override
    public void internalRun() throws Exception {
        if (this.help) {
            this.printHelp();
            this.handler.logInfo("PING OAI server: Harvest -g -a oai_source -i oai_set_id");
            this.handler.logInfo("SETUP a collection for harvesting: Harvest -s -c collection -t harvest_type -a oai_source -i oai_set_id -m metadata_format");
            this.handler.logInfo("RUN harvest once: Harvest -r -e eperson -c collection");
            this.handler.logInfo("START harvest scheduler: Harvest -S");
            this.handler.logInfo("RESET all harvest status: Harvest -R");
            this.handler.logInfo("PURGE a collection of items and settings: Harvest -p -e eperson -c collection");
            this.handler.logInfo("PURGE all harvestable collections: Harvest -P -e eperson");
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.command)) {
            this.handler.logError("No parameters specified (run with -h flag for details)");
            throw new UnsupportedOperationException("No command specified");
        }
        if ("run".equals(this.command)) {
            if (this.collection == null || this.context.getCurrentUser() == null) {
                this.handler.logError("A target collection and eperson must be provided (run with -h flag for details)");
                throw new UnsupportedOperationException("A target collection and eperson must be provided");
            }
            this.runHarvest(this.context, this.collection);
        } else if ("start".equals(this.command)) {
            this.startHarvester();
        } else if ("reset".equals(this.command)) {
            this.resetHarvesting(this.context);
        } else if ("purgeAll".equals(this.command)) {
            if (this.context.getCurrentUser() == null) {
                this.handler.logError("An eperson must be provided (run with -h flag for details)");
                throw new UnsupportedOperationException("An eperson must be provided");
            }
            List<HarvestedCollection> harvestedCollections = this.harvestedCollectionService.findAll(this.context);
            for (HarvestedCollection harvestedCollection : harvestedCollections) {
                this.handler.logInfo("Purging the following collections (deleting items and resetting harvest status): " + harvestedCollection.getCollection().getID().toString());
                this.purgeCollection(this.context, harvestedCollection.getCollection().getID().toString());
            }
            this.context.complete();
        } else if ("purge".equals(this.command)) {
            if (this.collection == null || this.context.getCurrentUser() == null) {
                this.handler.logError("A target collection and eperson must be provided (run with -h flag for details)");
                throw new UnsupportedOperationException("A target collection and eperson must be provided");
            }
            this.purgeCollection(this.context, this.collection);
            this.context.complete();
        } else if ("reimport".equals(this.command)) {
            if (this.collection == null || this.context.getCurrentUser() == null) {
                this.handler.logError("A target collection and eperson must be provided (run with -h flag for details)");
                throw new UnsupportedOperationException("A target collection and eperson must be provided");
            }
            this.purgeCollection(this.context, this.collection);
            this.runHarvest(this.context, this.collection);
            this.context.complete();
        } else if ("config".equals(this.command)) {
            if (this.collection == null) {
                this.handler.logError("A target collection must be provided (run with -h flag for details)");
                throw new UnsupportedOperationException("A target collection must be provided");
            }
            if (this.oaiSource == null || this.oaiSetID == null) {
                this.handler.logError("Both the OAI server address and OAI set id must be specified (run with -h flag for details)");
                throw new UnsupportedOperationException("Both the OAI server address and OAI set id must be specified");
            }
            if (this.metadataKey == null) {
                this.handler.logError("A metadata key (commonly the prefix) must be specified for this collection (run with -h flag for details)");
                throw new UnsupportedOperationException("A metadata key (commonly the prefix) must be specified for this collection");
            }
            this.configureCollection(this.context, this.collection, this.harvestType, this.oaiSource, this.oaiSetID, this.metadataKey);
        } else if ("ping".equals(this.command)) {
            if (this.oaiSource == null || this.oaiSetID == null) {
                this.handler.logError("Both the OAI server address and OAI set id must be specified  (run with -h flag for details)");
                throw new UnsupportedOperationException("Both the OAI server address and OAI set id must be specified");
            }
            this.pingResponder(this.oaiSource, this.oaiSetID, this.metadataKey);
        } else {
            this.handler.logError("Your command '" + this.command + "' was not recognized properly (run with -h flag for details)");
            throw new UnsupportedOperationException("Your command '" + this.command + "' was not recognized properly");
        }
    }

    private Collection resolveCollection(Context context, String collectionID) {
        Collection targetCollection = null;
        try {
            if (collectionID != null) {
                if (collectionID.indexOf(47) != -1) {
                    DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, collectionID);
                    targetCollection = dso == null || dso.getType() != 3 ? null : (Collection)dso;
                } else {
                    this.handler.logInfo("Looking up by UUID: " + collectionID + ", in context: " + context);
                    targetCollection = (Collection)this.collectionService.find(context, UUID.fromString(collectionID));
                }
            }
            if (targetCollection == null) {
                this.handler.logError("Cannot resolve " + collectionID + " to collection");
                throw new UnsupportedOperationException("Cannot resolve " + collectionID + " to collection");
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return targetCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureCollection(Context context, String collectionID, int type, String oaiSource, String oaiSetId, String mdConfigId) {
        this.handler.logInfo("Running: configure collection");
        Collection collection = this.resolveCollection(context, collectionID);
        this.handler.logInfo(String.valueOf(collection.getID()));
        try {
            HarvestedCollection hc = this.harvestedCollectionService.find(context, collection);
            if (hc == null) {
                hc = this.harvestedCollectionService.create(context, collection);
            }
            context.turnOffAuthorisationSystem();
            hc.setHarvestParams(type, oaiSource, oaiSetId, mdConfigId);
            hc.setHarvestStatus(0);
            this.harvestedCollectionService.update(context, hc);
            context.restoreAuthSystemState();
            context.complete();
        }
        catch (Exception e) {
            this.handler.logError("Changes could not be committed");
            this.handler.handleException(e);
        }
        finally {
            if (context != null) {
                context.restoreAuthSystemState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeCollection(Context context, String collectionID) {
        this.handler.logInfo("Purging collection of all items and resetting last_harvested and harvest_message: " + collectionID);
        Collection collection = this.resolveCollection(context, collectionID);
        try {
            context.turnOffAuthorisationSystem();
            ItemService itemService = ContentServiceFactory.getInstance().getItemService();
            Iterator<Item> it = itemService.findByCollection(context, collection);
            int i = 0;
            while (it.hasNext()) {
                Item item = it.next();
                this.handler.logInfo("Deleting: " + item.getHandle());
                this.collectionService.removeItem(context, collection, item);
                context.uncacheEntity(item);
                if (++i % 50 != 0) continue;
                context.dispatchEvents();
                i = 0;
            }
            HarvestedCollection hc = this.harvestedCollectionService.find(context, collection);
            if (hc != null) {
                hc.setLastHarvested(null);
                hc.setHarvestMessage("");
                hc.setHarvestStatus(0);
                hc.setHarvestStartTime(null);
                this.harvestedCollectionService.update(context, hc);
            }
            context.restoreAuthSystemState();
            context.dispatchEvents();
        }
        catch (Exception e) {
            this.handler.logError("Changes could not be committed");
            this.handler.handleException(e);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    private void runHarvest(Context context, String collectionID) {
        this.handler.logInfo("Running: a harvest cycle on " + collectionID);
        this.handler.logInfo("Initializing the harvester... ");
        OAIHarvester harvester = null;
        try {
            Collection collection = this.resolveCollection(context, collectionID);
            HarvestedCollection hc = this.harvestedCollectionService.find(context, collection);
            harvester = new OAIHarvester(context, collection, hc);
            this.handler.logInfo("Initialized the harvester successfully");
        }
        catch (HarvestingException hex) {
            this.handler.logError("Initializing the harvester failed.");
            throw new IllegalStateException("Unable to harvest", hex);
        }
        catch (SQLException se) {
            this.handler.logError("Initializing the harvester failed.");
            throw new IllegalStateException("Unable to access database", se);
        }
        try {
            this.handler.logInfo("Harvest started... ");
            harvester.runHarvest();
            context.complete();
        }
        catch (IOException | SQLException | AuthorizeException e) {
            throw new IllegalStateException("Failed to run harvester", e);
        }
        this.handler.logInfo("Harvest complete. ");
    }

    private void resetHarvesting(Context context) {
        this.handler.logInfo("Resetting harvest status flag on all collections... ");
        try {
            List<HarvestedCollection> harvestedCollections = this.harvestedCollectionService.findAll(context);
            for (HarvestedCollection harvestedCollection : harvestedCollections) {
                harvestedCollection.setHarvestStartTime(null);
                harvestedCollection.setHarvestStatus(0);
                this.harvestedCollectionService.update(context, harvestedCollection);
            }
            this.handler.logInfo("Reset harvest status flag successfully");
        }
        catch (Exception ex) {
            this.handler.logError("Resetting harvest status flag failed");
            this.handler.handleException(ex);
        }
    }

    private void startHarvester() {
        try {
            this.handler.logInfo("Starting harvest loop... ");
            HarvestServiceFactory.getInstance().getHarvestSchedulingService().startNewScheduler();
            this.handler.logInfo("running. ");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void pingResponder(String server, String set, String metadataFormat) {
        this.handler.logInfo("Testing basic PMH access:  ");
        List<String> errors = this.harvestedCollectionService.verifyOAIharvester(server, set, null != metadataFormat ? metadataFormat : "dc", false);
        if (errors.isEmpty()) {
            this.handler.logInfo("OK");
        } else {
            for (String error : errors) {
                this.handler.logError(error);
            }
        }
        this.handler.logInfo("Testing ORE support:  ");
        errors = this.harvestedCollectionService.verifyOAIharvester(server, set, null != metadataFormat ? metadataFormat : "dc", true);
        if (errors.isEmpty()) {
            this.handler.logInfo("OK");
        } else {
            for (String error : errors) {
                this.handler.logError(error);
            }
        }
    }
}

