/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemexport;

import jakarta.mail.MessagingException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.itemexport.ItemExportException;
import org.dspace.app.itemexport.service.ItemExportService;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.service.HandleService;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class ItemExportServiceImpl
implements ItemExportService {
    protected final int SUBDIR_LIMIT = 0;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected CommunityService communityService;
    @Autowired(required=true)
    protected EPersonService ePersonService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected HandleService handleService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    private final Logger log = LogManager.getLogger();
    private DSpaceRunnableHandler handler;

    protected ItemExportServiceImpl() {
    }

    @Override
    public void exportItem(Context c, Iterator<Item> i, String destDirName, int seqStart, boolean migrate, boolean excludeBitstreams) throws Exception {
        int mySequenceNumber = seqStart;
        int counter = -1;
        boolean subDirSuffix = false;
        String fullPath = destDirName;
        String subdir = "";
        this.logInfo("Beginning export");
        while (i.hasNext()) {
            this.logInfo("Exporting item to " + mySequenceNumber);
            Item item = i.next();
            this.exportItem(c, item, fullPath, mySequenceNumber, migrate, excludeBitstreams);
            c.uncacheEntity(item);
            ++mySequenceNumber;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void exportItem(Context c, Item myItem, String destDirName, int seqStart, boolean migrate, boolean excludeBitstreams) throws Exception {
        File destDir = new File(destDirName);
        if (!destDir.exists()) throw new Exception("Error, directory " + destDirName + " doesn't exist!");
        File itemDir = new File(destDir + "/" + seqStart);
        this.logInfo("Exporting Item " + myItem.getID() + (String)(myItem.getHandle() != null ? ", handle " + myItem.getHandle() : "") + " to " + itemDir);
        if (itemDir.exists()) {
            throw new Exception("Directory " + destDir + "/" + seqStart + " already exists!");
        }
        if (!itemDir.mkdir()) throw new Exception("Error, can't make dir " + itemDir);
        this.writeMetadata(c, myItem, itemDir, migrate);
        this.writeBitstreams(c, myItem, itemDir, excludeBitstreams);
        this.writeCollections(myItem, itemDir);
        if (migrate) return;
        this.writeHandle(c, myItem, itemDir);
    }

    protected void writeMetadata(Context c, Item i, File destDir, boolean migrate) throws Exception {
        HashSet<String> schemas = new HashSet<String>();
        List<MetadataValue> dcValues = this.itemService.getMetadata(i, "*", "*", "*", "*");
        for (MetadataValue metadataValue : dcValues) {
            schemas.add(metadataValue.getMetadataField().getMetadataSchema().getName());
        }
        for (String schema : schemas) {
            this.writeMetadata(c, schema, i, destDir, migrate);
        }
    }

    protected void writeMetadata(Context c, String schema, Item i, File destDir, boolean migrate) throws Exception {
        byte[] utf8;
        BufferedOutputStream out;
        Object filename = schema.equals(MetadataSchemaEnum.DC.getName()) ? "dublin_core.xml" : "metadata_" + schema + ".xml";
        File outFile = new File(destDir, (String)filename);
        this.logInfo("Attempting to create file " + outFile);
        if (outFile.createNewFile()) {
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            List<MetadataValue> dcorevalues = this.itemService.getMetadata(i, schema, "*", "*", "*");
            utf8 = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n".getBytes("UTF-8");
            out.write(utf8, 0, utf8.length);
            String dcTag = "<dublin_core schema=\"" + schema + "\">\n";
            utf8 = dcTag.getBytes("UTF-8");
            out.write(utf8, 0, utf8.length);
            String dateIssued = null;
            String dateAccessioned = null;
            for (MetadataValue dcv : dcorevalues) {
                Object language;
                MetadataField metadataField = dcv.getMetadataField();
                String qualifier = metadataField.getQualifier();
                if (qualifier == null) {
                    qualifier = "none";
                }
                language = (language = dcv.getLanguage()) != null ? " language=\"" + (String)language + "\"" : "";
                utf8 = ("  <dcvalue element=\"" + metadataField.getElement() + "\" qualifier=\"" + qualifier + "\"" + (String)language + ">" + Utils.addEntities(dcv.getValue()) + "</dcvalue>\n").getBytes("UTF-8");
                if (!(migrate && (!migrate || "date".equals(metadataField.getElement()) && "issued".equals(qualifier) || "date".equals(metadataField.getElement()) && "accessioned".equals(qualifier) || "date".equals(metadataField.getElement()) && "available".equals(qualifier) || "identifier".equals(metadataField.getElement()) && "uri".equals(qualifier) && dcv.getValue() != null && dcv.getValue().startsWith(this.handleService.getCanonicalPrefix() + this.handleService.getPrefix() + "/") || "description".equals(metadataField.getElement()) && "provenance".equals(qualifier) || "format".equals(metadataField.getElement()) && "extent".equals(qualifier) || "format".equals(metadataField.getElement()) && "mimetype".equals(qualifier)))) {
                    out.write(utf8, 0, utf8.length);
                }
                if ("date".equals(metadataField.getElement()) && "issued".equals(qualifier)) {
                    dateIssued = dcv.getValue();
                }
                if (!"date".equals(metadataField.getElement()) || !"accessioned".equals(qualifier)) continue;
                dateAccessioned = dcv.getValue();
            }
            if (migrate && dateIssued != null && dateAccessioned != null && !dateIssued.equals(dateAccessioned)) {
                utf8 = ("  <dcvalue element=\"date\" qualifier=\"issued\">" + Utils.addEntities(dateIssued) + "</dcvalue>\n").getBytes("UTF-8");
                out.write(utf8, 0, utf8.length);
            }
        } else {
            throw new Exception("Cannot create dublin_core.xml in " + destDir);
        }
        utf8 = "</dublin_core>\n".getBytes("UTF-8");
        out.write(utf8, 0, utf8.length);
        out.close();
    }

    protected void writeHandle(Context c, Item i, File destDir) throws Exception {
        if (i.getHandle() == null) {
            return;
        }
        String filename = "handle";
        File outFile = new File(destDir, filename);
        if (!outFile.createNewFile()) {
            throw new Exception("Cannot create file " + filename + " in " + destDir);
        }
        PrintWriter out = new PrintWriter(new FileWriter(outFile, StandardCharsets.UTF_8));
        out.println(i.getHandle());
        out.close();
    }

    protected void writeCollections(Item item, File destDir) throws IOException {
        File outFile = new File(destDir, "collections");
        if (outFile.createNewFile()) {
            try (PrintWriter out = new PrintWriter(new FileWriter(outFile));){
                String ownerHandle = item.getOwningCollection().getHandle();
                out.println(ownerHandle);
                for (Collection collection : item.getCollections()) {
                    String collectionHandle = collection.getHandle();
                    if (collectionHandle.equals(ownerHandle)) continue;
                    out.println(collectionHandle);
                }
            }
        } else {
            throw new IOException("Cannot create 'collections' in " + destDir);
        }
    }

    protected void writeBitstreams(Context c, Item i, File destDir, boolean excludeBitstreams) throws Exception {
        PrintWriter out;
        File outFile = new File(destDir, "contents");
        if (outFile.createNewFile()) {
            out = new PrintWriter(new FileWriter(outFile, StandardCharsets.UTF_8));
            List<Bundle> bundles = i.getBundles();
            for (Bundle bundle : bundles) {
                List<Bitstream> bitstreams = bundle.getBitstreams();
                String bundleName = bundle.getName();
                for (Bitstream bitstream : bitstreams) {
                    Object myName = bitstream.getName();
                    String oldName = myName;
                    Object description = bitstream.getDescription();
                    description = !StringUtils.isEmpty((CharSequence)description) ? "\tdescription:" + (String)description : "";
                    String primary = "";
                    if (bitstream.equals(bundle.getPrimaryBitstream())) {
                        primary = "\tprimary:true ";
                    }
                    int myPrefix = 1;
                    boolean isDone = false;
                    while (!excludeBitstreams && !isDone) {
                        File fout;
                        String dirs;
                        File fdirs;
                        if (((String)myName).contains(File.separator) && !(fdirs = new File(destDir + File.separator + (dirs = ((String)myName).substring(0, ((String)myName).lastIndexOf(File.separator))))).exists() && !fdirs.mkdirs()) {
                            this.logError("Unable to create destination directory");
                        }
                        if ((fout = new File(destDir, (String)myName)).createNewFile()) {
                            InputStream is = this.bitstreamService.retrieve(c, bitstream);
                            FileOutputStream fos = new FileOutputStream(fout);
                            Utils.bufferedCopy(is, fos);
                            is.close();
                            fos.close();
                            isDone = true;
                            continue;
                        }
                        myName = myPrefix + "_" + oldName;
                        ++myPrefix;
                    }
                    if (this.bitstreamService.isRegisteredBitstream(bitstream)) {
                        out.println("-r -s " + bitstream.getStoreNumber() + " -f " + (String)myName + "\tbundle:" + bundleName + primary + (String)description);
                        continue;
                    }
                    out.println((String)myName + "\tbundle:" + bundleName + primary + (String)description);
                }
            }
        } else {
            throw new Exception("Cannot create contents in " + destDir);
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportAsZip(Context context, Iterator<Item> items, String destDirName, String zipFileName, int seqStart, boolean migrate, boolean excludeBitstreams) throws Exception {
        File dnDir;
        String workDir = this.getExportWorkDirectory() + System.getProperty("file.separator") + zipFileName;
        File wkDir = new File(workDir);
        if (!wkDir.exists() && !wkDir.mkdirs()) {
            this.logError("Unable to create working directory");
        }
        if (!(dnDir = new File(destDirName)).exists() && !dnDir.mkdirs()) {
            this.logError("Unable to create destination directory");
        }
        try {
            this.exportItem(context, items, workDir, seqStart, migrate, excludeBitstreams);
            this.zip(workDir, destDirName + System.getProperty("file.separator") + zipFileName);
        }
        finally {
            if (wkDir.exists()) {
                this.deleteDirectory(wkDir);
            }
        }
    }

    @Override
    public void createDownloadableExport(DSpaceObject dso, Context context, boolean migrate) throws Exception {
        EPerson eperson = context.getCurrentUser();
        ArrayList<DSpaceObject> list = new ArrayList<DSpaceObject>(1);
        list.add(dso);
        this.processDownloadableExport(list, context, eperson == null ? null : eperson.getEmail(), migrate);
    }

    @Override
    public void createDownloadableExport(List<DSpaceObject> dsObjects, Context context, boolean migrate) throws Exception {
        EPerson eperson = context.getCurrentUser();
        this.processDownloadableExport(dsObjects, context, eperson == null ? null : eperson.getEmail(), migrate);
    }

    @Override
    public void createDownloadableExport(DSpaceObject dso, Context context, String additionalEmail, boolean migrate) throws Exception {
        ArrayList<DSpaceObject> list = new ArrayList<DSpaceObject>(1);
        list.add(dso);
        this.processDownloadableExport(list, context, additionalEmail, migrate);
    }

    @Override
    public void createDownloadableExport(List<DSpaceObject> dsObjects, Context context, String additionalEmail, boolean migrate) throws Exception {
        this.processDownloadableExport(dsObjects, context, additionalEmail, migrate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDownloadableExport(List<DSpaceObject> dsObjects, Context context, String additionalEmail, boolean toMigrate) throws Exception {
        final EPerson eperson = context.getCurrentUser();
        final boolean migrate = toMigrate;
        this.deleteOldExportArchives();
        double size = 0.0;
        final HashMap itemsMap = new HashMap();
        for (DSpaceObject dso : dsObjects) {
            if (dso.getType() == 4) {
                Community community = (Community)dso;
                List<Collection> collections = this.communityService.getAllCollections(context, community);
                for (Collection collection : collections) {
                    ArrayList<UUID> items = new ArrayList<UUID>();
                    Iterator<Item> iitems = this.itemService.findByCollection(context, collection);
                    try {
                        while (iitems.hasNext()) {
                            Item item = iitems.next();
                            List<Bundle> bundles = item.getBundles();
                            for (Bundle bundle : bundles) {
                                List<Bitstream> bitstreams = bundle.getBitstreams();
                                for (Bitstream bitstream : bitstreams) {
                                    size += (double)bitstream.getSizeBytes();
                                }
                            }
                            items.add(item.getID());
                        }
                    }
                    finally {
                        if (items.size() <= 0) continue;
                        itemsMap.put((CallSite)((Object)("collection_" + collection.getID())), items);
                    }
                }
                continue;
            }
            if (dso.getType() == 3) {
                Collection collection = (Collection)dso;
                ArrayList<UUID> items = new ArrayList<UUID>();
                Iterator<DSpaceObject> iitems = this.itemService.findByCollection(context, collection);
                try {
                    while (iitems.hasNext()) {
                        Item item = (Item)iitems.next();
                        List<Bundle> bundles = item.getBundles();
                        for (Bundle bundle : bundles) {
                            List<Bitstream> bitstreams = bundle.getBitstreams();
                            for (Bitstream bitstream : bitstreams) {
                                size += (double)bitstream.getSizeBytes();
                            }
                        }
                        items.add(item.getID());
                    }
                    continue;
                }
                finally {
                    if (items.size() > 0) {
                        itemsMap.put((CallSite)((Object)("collection_" + collection.getID())), items);
                    }
                    continue;
                }
            }
            if (dso.getType() != 2) continue;
            Item item = (Item)dso;
            List<Bundle> bundles = item.getBundles();
            for (Bundle bundle : bundles) {
                List<Bitstream> bitstreams = bundle.getBitstreams();
                for (Bitstream bitstream : bitstreams) {
                    size += (double)bitstream.getSizeBytes();
                }
            }
            ArrayList<UUID> items = new ArrayList<UUID>();
            items.add(item.getID());
            itemsMap.put((CallSite)((Object)("item_" + item.getID())), items);
        }
        String megaBytes = this.configurationService.getProperty("org.dspace.app.itemexport.max.size");
        if (megaBytes != null) {
            float maxSize = 0.0f;
            try {
                maxSize = Float.parseFloat(megaBytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (maxSize > 0.0f && (double)maxSize < size / 1048576.0) {
                throw new ItemExportException(0, "The overall size of this export is too large.  Please contact your administrator for more information.");
            }
        }
        if (itemsMap.size() > 0) {
            Thread go = new Thread(){

                @Override
                public void run() {
                    Context context = new Context();
                    Iterator<Item> iitems = null;
                    try {
                        context.turnOffAuthorisationSystem();
                        String fileName = ItemExportServiceImpl.this.assembleFileName("item", eperson, LocalDate.now());
                        String workParentDir = ItemExportServiceImpl.this.getExportWorkDirectory() + System.getProperty("file.separator") + fileName;
                        String downloadDir = ItemExportServiceImpl.this.getExportDownloadDirectory(eperson);
                        File dnDir = new File(downloadDir);
                        if (!dnDir.exists() && !dnDir.mkdirs()) {
                            ItemExportServiceImpl.this.logError("Unable to create download directory");
                        }
                        for (String keyName : itemsMap.keySet()) {
                            List uuids = (List)itemsMap.get(keyName);
                            ArrayList<Item> items = new ArrayList<Item>();
                            for (UUID uuid : uuids) {
                                items.add((Item)ItemExportServiceImpl.this.itemService.find(context, uuid));
                            }
                            iitems = items.iterator();
                            String workDir = workParentDir + System.getProperty("file.separator") + keyName;
                            File wkDir = new File(workDir);
                            if (!wkDir.exists() && !wkDir.mkdirs()) {
                                ItemExportServiceImpl.this.logError("Unable to create working directory");
                            }
                            ItemExportServiceImpl.this.exportItem(context, iitems, workDir, 1, migrate, false);
                        }
                        ItemExportServiceImpl.this.zip(workParentDir, downloadDir + System.getProperty("file.separator") + fileName + ".zip");
                        ItemExportServiceImpl.this.emailSuccessMessage(context, eperson, fileName + ".zip");
                        context.restoreAuthSystemState();
                    }
                    catch (Exception e1) {
                        try {
                            ItemExportServiceImpl.this.emailErrorMessage(eperson, e1.getMessage());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new IllegalStateException(e1);
                    }
                    finally {
                        try {
                            context.complete();
                        }
                        catch (SQLException sqle) {
                            context.abort();
                        }
                    }
                }
            };
            go.isDaemon();
            go.start();
        } else {
            Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
            this.emailErrorMessage(eperson, I18nUtil.getMessage("org.dspace.app.itemexport.no-result", supportedLocale));
        }
    }

    @Override
    public String assembleFileName(String type, EPerson eperson, LocalDate date) throws Exception {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy_MMM_dd");
        String downloadDir = this.getExportDownloadDirectory(eperson);
        int count = 1;
        boolean exists = true;
        String fileName = null;
        while (exists) {
            fileName = type + "_export_" + formatter.format(date) + "_" + count + "_" + eperson.getID();
            exists = new File(downloadDir + System.getProperty("file.separator") + fileName + ".zip").exists();
            ++count;
        }
        return fileName;
    }

    @Override
    public String getExportDownloadDirectory(EPerson ePerson) throws Exception {
        String downloadDir = this.configurationService.getProperty("org.dspace.app.itemexport.download.dir");
        if (downloadDir == null) {
            throw new Exception("A dspace.cfg entry for 'org.dspace.app.itemexport.download.dir' does not exist.");
        }
        File result = new File(downloadDir + System.getProperty("file.separator") + ePerson.getID());
        if (!result.exists() && ePerson.getLegacyId() != null) {
            result = new File(downloadDir + System.getProperty("file.separator") + ePerson.getLegacyId());
        }
        return result.getAbsolutePath();
    }

    @Override
    public String getExportWorkDirectory() throws Exception {
        String exportDir = this.configurationService.getProperty("org.dspace.app.itemexport.work.dir");
        if (exportDir == null) {
            throw new Exception("A dspace.cfg entry for 'org.dspace.app.itemexport.work.dir' does not exist.");
        }
        return StringUtils.replace((String)exportDir, (String)(File.separator + File.separator), (String)File.separator);
    }

    @Override
    public InputStream getExportDownloadInputStream(String fileName, EPerson eperson) throws Exception {
        File file = new File(this.getExportDownloadDirectory(eperson) + System.getProperty("file.separator") + fileName);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }

    @Override
    public long getExportFileSize(Context context, String fileName) throws Exception {
        String strID = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.lastIndexOf(46));
        EPerson ePerson = this.getEPersonFromString(context, strID);
        File file = new File(this.getExportDownloadDirectory(ePerson) + System.getProperty("file.separator") + fileName);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("The file " + this.getExportDownloadDirectory(ePerson) + System.getProperty("file.separator") + fileName + " does not exist.");
        }
        return file.length();
    }

    protected EPerson getEPersonFromString(Context context, String strID) throws SQLException {
        EPerson eperson;
        try {
            UUID ePersonId = UUID.fromString(strID);
            eperson = (EPerson)this.ePersonService.find(context, ePersonId);
        }
        catch (Exception e) {
            eperson = (EPerson)this.ePersonService.findByLegacyId(context, Integer.parseInt(strID));
        }
        return eperson;
    }

    @Override
    public long getExportFileLastModified(Context context, String fileName) throws Exception {
        String strID = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.lastIndexOf(46));
        EPerson ePerson = this.getEPersonFromString(context, strID);
        File file = new File(this.getExportDownloadDirectory(ePerson) + System.getProperty("file.separator") + fileName);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("The file " + this.getExportDownloadDirectory(ePerson) + System.getProperty("file.separator") + fileName + " does not exist.");
        }
        return file.lastModified();
    }

    @Override
    public boolean canDownload(Context context, String fileName) {
        EPerson eperson = context.getCurrentUser();
        if (eperson == null) {
            return false;
        }
        String strID = fileName.substring(fileName.lastIndexOf(95) + 1, fileName.lastIndexOf(46));
        try {
            if (strID.equals(eperson.getID().toString())) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public List<String> getExportsAvailable(EPerson eperson) throws Exception {
        File downloadDir = new File(this.getExportDownloadDirectory(eperson));
        if (!downloadDir.exists() || !downloadDir.isDirectory()) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String fileName : downloadDir.list()) {
            if (!fileName.contains("export") || !fileName.endsWith(".zip")) continue;
            fileNames.add(fileName);
        }
        if (fileNames.size() > 0) {
            return fileNames;
        }
        return null;
    }

    @Override
    public void deleteOldExportArchives(EPerson eperson) throws Exception {
        int hours = this.configurationService.getIntProperty("org.dspace.app.itemexport.life.span.hours");
        Instant modifiedTime = Instant.now().minus(hours, ChronoUnit.HOURS);
        File downloadDir = new File(this.getExportDownloadDirectory(eperson));
        if (downloadDir.exists()) {
            File[] files;
            for (File file : files = downloadDir.listFiles()) {
                if (file.lastModified() >= modifiedTime.toEpochMilli() || file.delete()) continue;
                this.logError("Unable to delete export file");
            }
        }
    }

    @Override
    public void deleteOldExportArchives() throws Exception {
        int hours = this.configurationService.getIntProperty("org.dspace.app.itemexport.life.span.hours");
        Instant modifiedTime = Instant.now().minus(hours, ChronoUnit.HOURS);
        File downloadDir = new File(this.configurationService.getProperty("org.dspace.app.itemexport.download.dir"));
        if (downloadDir.exists()) {
            File[] dirs;
            for (File dir : dirs = downloadDir.listFiles()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (file.lastModified() >= modifiedTime.toEpochMilli() || file.delete()) continue;
                    this.logError("Unable to delete old files");
                }
                if (dir.listFiles().length != 0 || dir.delete()) continue;
                this.logError("Unable to delete directory");
            }
        }
    }

    @Override
    public void emailSuccessMessage(Context context, EPerson eperson, String fileName) throws MessagingException {
        try {
            Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "export_success"));
            email.addRecipient(eperson.getEmail());
            email.addArgument(this.configurationService.getProperty("dspace.ui.url") + "/exportdownload/" + fileName);
            email.addArgument(this.configurationService.getProperty("org.dspace.app.itemexport.life.span.hours"));
            email.send();
        }
        catch (Exception e) {
            this.logWarn(LogHelper.getHeader(context, "emailSuccessMessage", "cannot notify user of export"), e);
        }
    }

    @Override
    public void emailErrorMessage(EPerson eperson, String error) throws MessagingException {
        this.logWarn("An error occurred during item export, the user will be notified. " + error);
        try {
            Locale supportedLocale = I18nUtil.getEPersonLocale(eperson);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "export_error"));
            email.addRecipient(eperson.getEmail());
            email.addArgument(error);
            email.addArgument(this.configurationService.getProperty("dspace.ui.url") + "/feedback");
            email.send();
        }
        catch (Exception e) {
            this.logWarn("error during item export error notification", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zip(String strSource, String target) throws Exception {
        String tempFileName = target + "_tmp";
        try (ZipOutputStream cpZipOutputStream = null;){
            File cpFile = new File(strSource);
            if (!cpFile.isFile() && !cpFile.isDirectory()) {
                return;
            }
            File targetFile = new File(tempFileName);
            if (!targetFile.createNewFile()) {
                this.logWarn("Target file already exists: " + targetFile.getName());
            }
            FileOutputStream fos = new FileOutputStream(tempFileName);
            cpZipOutputStream = new ZipOutputStream(fos);
            cpZipOutputStream.setLevel(9);
            this.zipFiles(cpFile, strSource, tempFileName, cpZipOutputStream);
            cpZipOutputStream.finish();
            cpZipOutputStream.close();
            cpZipOutputStream = null;
            System.gc();
            this.deleteDirectory(cpFile);
            if (!targetFile.renameTo(new File(target))) {
                this.logError("Unable to rename file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFiles(File cpFile, String strSource, String strTarget, ZipOutputStream cpZipOutputStream) throws Exception {
        int DATA_BLOCK_SIZE = 2048;
        FileInputStream cpFileInputStream = null;
        if (cpFile.isDirectory()) {
            File[] fList;
            for (File aFList : fList = cpFile.listFiles()) {
                this.zipFiles(aFList, strSource, strTarget, cpZipOutputStream);
            }
        } else {
            try {
                int byteCount;
                if (cpFile.getAbsolutePath().equalsIgnoreCase(strTarget)) {
                    return;
                }
                String strAbsPath = cpFile.getPath();
                int startIndex = strSource.length();
                if (!StringUtils.endsWith((CharSequence)strSource, (CharSequence)File.separator)) {
                    ++startIndex;
                }
                String strZipEntryName = strAbsPath.substring(startIndex, strAbsPath.length());
                cpFileInputStream = new FileInputStream(cpFile);
                ZipEntry cpZipEntry = new ZipEntry(strZipEntryName);
                cpZipOutputStream.putNextEntry(cpZipEntry);
                byte[] b = new byte[2048];
                while ((byteCount = cpFileInputStream.read(b, 0, 2048)) != -1) {
                    cpZipOutputStream.write(b, 0, byteCount);
                }
            }
            finally {
                if (cpFileInputStream != null) {
                    cpFileInputStream.close();
                }
                cpZipOutputStream.closeEntry();
            }
        }
    }

    protected boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                this.logError("Unable to delete file: " + file.getName());
            }
        }
        return path.delete();
    }

    @Override
    public void setHandler(DSpaceRunnableHandler handler) {
        this.handler = handler;
    }

    private void logInfo(String message) {
        this.logInfo(message, null);
    }

    private void logInfo(String message, Exception e) {
        if (this.handler != null) {
            this.handler.logInfo(message);
            return;
        }
        if (e != null) {
            this.log.info(message, (Throwable)e);
        } else {
            this.log.info(message);
        }
    }

    private void logWarn(String message) {
        this.logWarn(message, null);
    }

    private void logWarn(String message, Exception e) {
        if (this.handler != null) {
            this.handler.logWarning(message);
            return;
        }
        if (e != null) {
            this.log.warn(message, (Throwable)e);
        } else {
            this.log.warn(message);
        }
    }

    private void logError(String message) {
        this.logError(message, null);
    }

    private void logError(String message, Exception e) {
        if (this.handler != null) {
            if (e != null) {
                this.handler.logError(message, e);
            } else {
                this.handler.logError(message);
            }
            return;
        }
        if (e != null) {
            this.log.error(message, (Throwable)e);
        } else {
            this.log.error(message);
        }
    }
}

