/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.dspace.app.ldn.action.LDNAction;
import org.dspace.app.ldn.action.LDNActionStatus;
import org.dspace.app.ldn.model.Notification;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class SendLDNMessageAction
implements LDNAction {
    private static final Logger log = LogManager.getLogger(SendLDNMessageAction.class);
    private CloseableHttpClient client;

    public SendLDNMessageAction() {
    }

    public SendLDNMessageAction(CloseableHttpClient client) {
        this.client = client;
    }

    @Override
    public LDNActionStatus execute(Context context, Notification notification, Item item) throws Exception {
        String url = notification.getTarget().getInbox();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/ld+json");
        ObjectMapper mapper = new ObjectMapper();
        httpPost.setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString((Object)notification), "UTF-8"));
        LDNActionStatus result = LDNActionStatus.ABORT;
        if (this.client == null) {
            this.client = DSpaceHttpClientFactory.getInstance().buildWithoutAutomaticRetries(5);
        }
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPost);){
            if (this.isSuccessful(response.getStatusLine().getStatusCode())) {
                result = LDNActionStatus.CONTINUE;
            } else if (this.isRedirect(response.getStatusLine().getStatusCode())) {
                result = this.handleRedirect(response, httpPost);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        this.client.close();
        return result;
    }

    private boolean isSuccessful(int statusCode) {
        return statusCode == 202 || statusCode == 201;
    }

    private boolean isRedirect(int statusCode) {
        return statusCode == 308 || statusCode == 307;
    }

    private LDNActionStatus handleRedirect(CloseableHttpResponse oldResponse, HttpPost request) throws HttpException {
        String url;
        Header[] urls = oldResponse.getHeaders("Location");
        String string = url = urls.length > 0 && urls[0] != null ? urls[0].getValue() : null;
        if (url == null) {
            throw new HttpException("Error following redirect, unable to reach the correct url.");
        }
        LDNActionStatus result = LDNActionStatus.ABORT;
        try {
            request.setURI(new URI(url));
            try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
                if (this.isSuccessful(response.getStatusLine().getStatusCode())) {
                    result = LDNActionStatus.CONTINUE;
                }
            }
        }
        catch (Exception e) {
            log.error("Error following redirect:", (Throwable)e);
        }
        return result;
    }
}

