/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.time.LocalDate;

public class LogLine {
    private LocalDate date = null;
    private String level = null;
    private String user = null;
    private String action = null;
    private String params = null;

    LogLine(LocalDate date, String level, String user, String action, String params) {
        this.date = date;
        this.level = level;
        this.user = user;
        this.action = action;
        this.params = params;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public String getLevel() {
        return this.level;
    }

    public String getUser() {
        return this.user;
    }

    public String getAction() {
        return this.action;
    }

    public String getParams() {
        return this.params;
    }

    public boolean beforeDate(LocalDate compareDate) {
        if (compareDate != null) {
            return this.date.isBefore(compareDate);
        }
        return false;
    }

    public boolean afterDate(LocalDate compareDate) {
        if (compareDate != null) {
            return this.date.isAfter(compareDate);
        }
        return false;
    }

    public boolean isLevel(String level) {
        return this.getLevel().equals(level);
    }

    public boolean isAction(String action) {
        return this.getAction().equals(action);
    }
}

