/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion.script;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.cli.Options;
import org.dspace.app.suggestion.runnable.PublicationLoaderRunnable;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceCommandLineParameter;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.springframework.beans.factory.annotation.Autowired;

public class PublicationLoaderScriptConfiguration<T extends PublicationLoaderRunnable>
extends ScriptConfiguration<T> {
    @Autowired
    private AuthorizeService authorizeService;
    private Class<T> dspaceRunnableClass;

    @Override
    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    @Override
    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }

    @Override
    public boolean isAllowedToExecute(Context context, List<DSpaceCommandLineParameter> commandLineParameters) {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException occurred when checking if the current user is an admin", e);
        }
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            Options options = new Options();
            options.addOption("s", "single-researcher", true, "Single researcher UUID");
            options.getOption("s").setType(String.class);
            options.addOption("l", "loader", true, "Publication loader to be used");
            options.getOption("l").setType(String.class);
            options.getOption("l").setRequired(true);
            options.addOption("f", "solrfilter", true, "The additional SOLR filter to better refine results");
            options.getOption("f").setType(String.class);
            options.addOption("m", "max", true, "The maximum number of researcher profiles to process. If no maximum is provided, then the configured default will be used.");
            options.getOption("m").setType(Integer.class);
            this.options = options;
        }
        return this.options;
    }
}

