/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class IndexVersion {
    private IndexVersion() {
    }

    public static void main(String[] argv) throws IOException {
        String compareToVersion;
        if (argv.length < 1) {
            System.out.println("\nRequired Solr/Lucene index directory is missing.");
            System.out.println("Minimally, pass in the full path of the Solr/Lucene Index directory to analyze");
            System.out.println("Usage: IndexVersion [full-path-to-solr-index] ([version-to-compare])");
            System.out.println("  - [full-path-to-index] is REQUIRED (e.g. [dspace.dir]/solr/statistics/data/index/)");
            System.out.println("  - [version-to-compare] is optional. When specified, this command will return:");
            System.out.println("       -1 if index dir version < version-to-compare");
            System.out.println("        0 if index dir version = version-to-compare");
            System.out.println("        1 if index dir version > version-to-compare");
            System.out.println("\nOptionally, passing just '-v' will return the version of Solr/Lucene in use by DSpace.");
            System.exit(1);
        }
        if (argv[0].equalsIgnoreCase("-v")) {
            System.out.println(IndexVersion.getLatestVersion());
            System.exit(0);
        }
        String indexVersion = IndexVersion.getIndexVersion(argv[0]);
        String string = compareToVersion = argv.length > 1 ? argv[1] : null;
        if (indexVersion == null) {
            System.out.println("\nRequired Solr/Lucene index directory is invalid.");
            System.out.println("The following path does NOT seem to be a valid index directory:");
            System.out.println(argv[0]);
            System.out.println("Please pass in the full path of the Solr/Lucene Index directory to analyze");
            System.out.println("(e.g. [dspace.dir]/solr/statistics/data/index/)\n");
            System.exit(1);
        }
        if (indexVersion.equals("")) {
            indexVersion = IndexVersion.getLatestVersion();
        }
        if (compareToVersion != null && !compareToVersion.isEmpty()) {
            if (compareToVersion.equalsIgnoreCase("LATEST")) {
                compareToVersion = IndexVersion.getLatestVersion();
            }
            System.out.println(IndexVersion.compareSoftwareVersions(indexVersion, compareToVersion));
        } else {
            System.out.println(indexVersion);
        }
        System.exit(0);
    }

    public static String getIndexVersion(String indexDirPath) throws IOException {
        String indexVersion = null;
        File dir = new File(indexDirPath);
        if (dir.exists() && dir.isDirectory()) {
            SegmentInfos sis;
            String[] dirContents = dir.list();
            if (dirContents != null && dirContents.length == 0) {
                return "";
            }
            FSDirectory indexDir = FSDirectory.open((Path)dir.toPath());
            try {
                sis = SegmentInfos.readLatestCommit((Directory)indexDir);
            }
            catch (IOException ie) {
                throw new IOException("Could not read Lucene segments files in " + dir.getAbsolutePath(), ie);
            }
            if (null == sis) {
                throw new IOException("Could not read Lucene segments files in " + dir.getAbsolutePath());
            }
            if (sis.size() == 0) {
                return "";
            }
            Version oldest = null;
            Version oldSegment = null;
            for (SegmentCommitInfo si : sis) {
                Version version = si.info.getVersion();
                if (version == null) {
                    try {
                        oldSegment = Version.parse((String)"3.0");
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe);
                    }
                }
                if (oldest != null && version.onOrAfter(oldest)) continue;
                oldest = version;
            }
            if (oldSegment != null && !oldSegment.onOrAfter(oldest)) {
                oldest = oldSegment;
            }
            if (oldest != null) {
                indexVersion = oldest.toString();
            }
        }
        return indexVersion;
    }

    public static int compareSoftwareVersions(String firstVersion, String secondVersion) throws IOException {
        int secondMinor;
        int GREATER_THAN = 1;
        int EQUAL = 0;
        int LESS_THAN = -1;
        if (firstVersion == null) {
            return LESS_THAN;
        }
        if (secondVersion == null) {
            return GREATER_THAN;
        }
        String[] firstParts = firstVersion.split("\\.");
        String[] secondParts = secondVersion.split("\\.");
        int firstMajor = firstParts.length >= 1 ? Integer.parseInt(firstParts[0]) : 0;
        int firstMinor = firstParts.length >= 2 ? Integer.parseInt(firstParts[1]) : 0;
        int secondMajor = secondParts.length >= 1 ? Integer.parseInt(secondParts[0]) : 0;
        int n = secondMinor = secondParts.length >= 2 ? Integer.parseInt(secondParts[1]) : 0;
        if (firstMajor == secondMajor && firstMinor == secondMinor) {
            return EQUAL;
        }
        if (firstMajor > secondMajor) {
            return GREATER_THAN;
        }
        if (firstMajor < secondMajor) {
            return LESS_THAN;
        }
        if (firstMinor > secondMinor) {
            return GREATER_THAN;
        }
        return LESS_THAN;
    }

    public static String getLatestVersion() {
        return Version.LATEST.toString();
    }
}

