/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.PersonAuthorityValue;
import org.dspace.authority.orcid.Orcidv3SolrAuthorityImpl;
import org.dspace.utils.DSpace;
import org.orcid.jaxb.model.v3.release.record.Keyword;
import org.orcid.jaxb.model.v3.release.record.Name;
import org.orcid.jaxb.model.v3.release.record.Person;
import org.orcid.jaxb.model.v3.release.record.PersonExternalIdentifier;
import org.orcid.jaxb.model.v3.release.record.PersonExternalIdentifiers;
import org.orcid.jaxb.model.v3.release.record.ResearcherUrl;

public class Orcidv3AuthorityValue
extends PersonAuthorityValue {
    private String orcid_id;
    private Map<String, List<String>> otherMetadata = new HashMap<String, List<String>>();
    public static final String ORCID_ID_SYNTAX = "\\d{4}-\\d{4}-\\d{4}-(\\d{3}X|\\d{4})";

    public Orcidv3AuthorityValue() {
    }

    public Orcidv3AuthorityValue(SolrDocument document) {
        super(document);
    }

    public String getOrcid_id() {
        return this.orcid_id;
    }

    public void setOrcid_id(String orcid_id) {
        this.orcid_id = orcid_id;
    }

    public static Orcidv3AuthorityValue create() {
        Orcidv3AuthorityValue orcidAuthorityValue = new Orcidv3AuthorityValue();
        orcidAuthorityValue.setId(UUID.randomUUID().toString());
        orcidAuthorityValue.updateLastModifiedDate();
        orcidAuthorityValue.setCreationDate(Instant.now());
        return orcidAuthorityValue;
    }

    public static Orcidv3AuthorityValue create(Person person) {
        if (person == null) {
            return null;
        }
        Orcidv3AuthorityValue authority = Orcidv3AuthorityValue.create();
        authority.setValues(person);
        return authority;
    }

    protected void setValues(Person person) {
        PersonExternalIdentifiers externalIdentifiers;
        Name name = person.getName();
        if (!StringUtils.equals((String)name.getPath(), (String)this.getOrcid_id())) {
            this.setOrcid_id(name.getPath());
        }
        if (!StringUtils.equals((String)name.getFamilyName().getContent(), (String)this.getLastName())) {
            this.setLastName(name.getFamilyName().getContent());
        }
        if (!StringUtils.equals((String)name.getGivenNames().getContent(), (String)this.getFirstName())) {
            this.setFirstName(name.getGivenNames().getContent());
        }
        if (name.getCreditName() != null && StringUtils.isNotBlank((String)name.getCreditName().getContent()) && !this.getNameVariants().contains(name.getCreditName().getContent())) {
            this.addNameVariant(name.getCreditName().getContent());
        }
        if (person.getKeywords() != null) {
            for (Keyword keyword : person.getKeywords().getKeywords()) {
                if (!this.isNewMetadata("keyword", keyword.getContent())) continue;
                this.addOtherMetadata("keyword", keyword.getContent());
            }
        }
        if ((externalIdentifiers = person.getExternalIdentifiers()) != null) {
            for (PersonExternalIdentifier externalIdentifier : externalIdentifiers.getExternalIdentifiers()) {
                if (!this.isNewMetadata("external_identifier", externalIdentifier.getValue())) continue;
                this.addOtherMetadata("external_identifier", externalIdentifier.getValue());
            }
        }
        if (person.getResearcherUrls() != null) {
            for (ResearcherUrl researcherUrl : person.getResearcherUrls().getResearcherUrls()) {
                if (!this.isNewMetadata("researcher_url", researcherUrl.getUrl().getValue())) continue;
                this.addOtherMetadata("researcher_url", researcherUrl.getUrl().getValue());
            }
        }
        if (person.getBiography() != null && this.isNewMetadata("biography", person.getBiography().getContent())) {
            this.addOtherMetadata("biography", person.getBiography().getContent());
        }
        this.setValue(this.getName());
    }

    @Override
    public AuthorityValue newInstance(String info) {
        AuthorityValue authorityValue = null;
        if (StringUtils.isNotBlank((String)info)) {
            Orcidv3SolrAuthorityImpl orcid = (Orcidv3SolrAuthorityImpl)new DSpace().getServiceManager().getServiceByName("AuthoritySource", Orcidv3SolrAuthorityImpl.class);
            authorityValue = orcid.queryAuthorityID(info);
        } else {
            authorityValue = this.create();
        }
        return authorityValue;
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
    }

    public boolean isNewMetadata(String label, String data) {
        List<String> strings = this.getOtherMetadata().get(label);
        boolean update = strings == null ? StringUtils.isNotBlank((String)data) : !strings.contains(data);
        return update;
    }

    public void addOtherMetadata(String label, String data) {
        List<String> strings = this.otherMetadata.get(label);
        if (strings == null) {
            strings = new ArrayList<String>();
        }
        strings.add(data);
        this.otherMetadata.put(label, strings);
    }

    public Map<String, List<String>> getOtherMetadata() {
        return this.otherMetadata;
    }

    @Override
    public SolrInputDocument getSolrInputDocument() {
        SolrInputDocument doc = super.getSolrInputDocument();
        if (StringUtils.isNotBlank((String)this.getOrcid_id())) {
            doc.addField("orcid_id", (Object)this.getOrcid_id());
        }
        for (String t : this.otherMetadata.keySet()) {
            List<String> data = this.otherMetadata.get(t);
            for (String data_entry : data) {
                doc.addField("label_" + t, (Object)data_entry);
            }
        }
        return doc;
    }

    @Override
    public Map<String, String> choiceSelectMap() {
        Map<String, String> map = super.choiceSelectMap();
        String orcid_id = this.getOrcid_id();
        if (StringUtils.isNotBlank((String)orcid_id)) {
            map.put("orcid", orcid_id);
        }
        return map;
    }

    @Override
    public String getAuthorityType() {
        return "orcid";
    }

    @Override
    public String generateString() {
        String generateString = "will be generated::" + this.getAuthorityType() + "::";
        if (StringUtils.isNotBlank((String)this.getOrcid_id())) {
            generateString = generateString + this.getOrcid_id();
        }
        return generateString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Orcidv3AuthorityValue that = (Orcidv3AuthorityValue)o;
        return !(this.orcid_id != null ? !this.orcid_id.equals(that.orcid_id) : that.orcid_id != null);
    }

    public int hashCode() {
        return this.orcid_id != null ? this.orcid_id.hashCode() : 0;
    }

    @Override
    public boolean hasTheSameInformationAs(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.hasTheSameInformationAs(o)) {
            return false;
        }
        Orcidv3AuthorityValue that = (Orcidv3AuthorityValue)o;
        if (this.orcid_id != null ? !this.orcid_id.equals(that.orcid_id) : that.orcid_id != null) {
            return false;
        }
        for (String key : this.otherMetadata.keySet()) {
            if (this.otherMetadata.get(key) != null) {
                List<String> metadata = this.otherMetadata.get(key);
                List<String> otherMetadata = that.otherMetadata.get(key);
                if (otherMetadata == null) {
                    return false;
                }
                HashSet<String> metadataSet = new HashSet<String>(metadata);
                HashSet<String> otherMetadataSet = new HashSet<String>(otherMetadata);
                if (metadataSet.equals(otherMetadataSet)) continue;
                return false;
            }
            if (that.otherMetadata.get(key) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setValues(SolrDocument document) {
        super.setValues(document);
        this.orcid_id = ObjectUtils.toString((Object)document.getFieldValue("orcid_id"));
        for (String key : document.getFieldNames()) {
            if (!key.startsWith("label_")) continue;
            String keyInternalMap = key.substring(key.indexOf("_") + 1);
            Collection valuesSolr = document.getFieldValues(key);
            for (Object valueInternal : valuesSolr) {
                this.addOtherMetadata(keyInternalMap, (String)valueInternal);
            }
        }
    }
}

