/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.io.Serializable;
import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.checker.ChecksumResultsCollector;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.content.Bitstream;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;

public class ResultsLogger
implements ChecksumResultsCollector {
    private static final Logger LOG = LogManager.getLogger(ResultsLogger.class);

    private ResultsLogger() {
    }

    public ResultsLogger(Instant startDt) {
        LOG.info(this.msg("run-start-time") + ": " + DateTimeFormatter.ISO_INSTANT.format(startDt));
    }

    protected String msg(String key) {
        return I18nUtil.getMessage("org.dspace.checker.ResultsLogger." + key);
    }

    @Override
    public void collect(Context context, MostRecentChecksum info) throws SQLException {
        Bitstream bitstream = info.getBitstream();
        LOG.info("******************************************************");
        LOG.info(this.msg("bitstream-id") + ": " + bitstream.getID());
        LOG.info(this.msg("bitstream-info-found") + ": " + info.isInfoFound());
        LOG.info(this.msg("bitstream-marked-deleted") + ": " + bitstream.isDeleted());
        LOG.info(this.msg("bitstream-found") + ": " + info.isBitstreamFound());
        LOG.info(this.msg("to-be-processed") + ": " + info.isToBeProcessed());
        LOG.info(this.msg("internal-id") + ": " + bitstream.getInternalId());
        LOG.info(this.msg("name") + ": " + bitstream.getName());
        LOG.info(this.msg("store-number") + ": " + bitstream.getStoreNumber());
        LOG.info(this.msg("size") + ": " + bitstream.getSizeBytes());
        LOG.info(this.msg("bitstream-format") + ": " + (Serializable)(bitstream.getFormat(context) != null ? bitstream.getFormat(context).getID() : "-1"));
        LOG.info(this.msg("user-format-description") + ": " + bitstream.getUserFormatDescription());
        LOG.info(this.msg("source") + ": " + bitstream.getSource());
        LOG.info(this.msg("checksum-algorithm") + ": " + info.getChecksumAlgorithm());
        LOG.info(this.msg("previous-checksum") + ": " + info.getExpectedChecksum());
        LOG.info(this.msg("previous-checksum-date") + ": " + (info.getProcessEndDate() != null ? DateTimeFormatter.ISO_INSTANT.format(info.getProcessEndDate()) : "unknown"));
        LOG.info(this.msg("new-checksum") + ": " + info.getCurrentChecksum());
        LOG.info(this.msg("checksum-comparison-result") + ": " + info.getChecksumResult().getResultCode());
        LOG.info("\n\n");
    }
}

