/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionConfigReaderException;
import org.dspace.content.Collection;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.AuthorityVariantsSupport;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.DSpaceControlledVocabulary;
import org.dspace.content.authority.DSpaceControlledVocabularyIndex;
import org.dspace.content.authority.HierarchicalAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Utils;
import org.dspace.core.service.PluginService;
import org.dspace.discovery.configuration.DiscoveryConfigurationService;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.services.ConfigurationService;
import org.dspace.submit.factory.SubmissionServiceFactory;
import org.dspace.submit.service.SubmissionConfigService;
import org.springframework.beans.factory.annotation.Autowired;

public final class ChoiceAuthorityServiceImpl
implements ChoiceAuthorityService {
    private Logger log = LogManager.getLogger(ChoiceAuthorityServiceImpl.class);
    protected Map<String, ChoiceAuthority> controller = new HashMap<String, ChoiceAuthority>();
    protected Map<String, Map<String, ChoiceAuthority>> controllerFormDefinitions = new HashMap<String, Map<String, ChoiceAuthority>>();
    protected Map<String, String> presentation = new HashMap<String, String>();
    protected Map<String, Boolean> closed = new HashMap<String, Boolean>();
    private boolean initialized = false;
    protected Map<String, List<String>> authorities = new HashMap<String, List<String>>();
    protected Map<String, Map<String, List<String>>> authoritiesFormDefinitions = new HashMap<String, Map<String, List<String>>>();
    protected Map<String, DSpaceControlledVocabularyIndex> vocabularyIndexMap = new HashMap<String, DSpaceControlledVocabularyIndex>();
    private SubmissionConfigService submissionConfigService;
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected PluginService pluginService;
    @Autowired
    private DiscoveryConfigurationService searchConfigurationService;
    static final String CHOICES_PLUGIN_PREFIX = "choices.plugin.";
    static final String CHOICES_PRESENTATION_PREFIX = "choices.presentation.";
    static final String CHOICES_CLOSED_PREFIX = "choices.closed.";

    protected ChoiceAuthorityServiceImpl() {
    }

    protected String config2fkey(String field) {
        int dot = field.indexOf(46);
        if (dot < 0) {
            return null;
        }
        String schema = field.substring(0, dot);
        String element = field.substring(dot + 1);
        String qualifier = null;
        dot = element.indexOf(46);
        if (dot >= 0) {
            qualifier = element.substring(dot + 1);
            element = element.substring(0, dot);
        }
        return this.makeFieldKey(schema, element, qualifier);
    }

    @Override
    public Set<String> getChoiceAuthoritiesNames() {
        this.init();
        HashSet<String> authoritiesNames = new HashSet<String>();
        authoritiesNames.addAll(this.authorities.keySet());
        authoritiesNames.addAll(this.authoritiesFormDefinitions.keySet());
        return authoritiesNames;
    }

    private synchronized void init() {
        if (!this.initialized) {
            try {
                this.submissionConfigService = SubmissionServiceFactory.getInstance().getSubmissionConfigService();
            }
            catch (SubmissionConfigReaderException e) {
                throw new IllegalStateException("Error reading the item submission configuration: " + e.getMessage(), e);
            }
            this.loadChoiceAuthorityConfigurations();
            this.initialized = true;
        }
    }

    @Override
    public Choices getMatches(String schema, String element, String qualifier, String query, Collection collection, int start, int limit, String locale) {
        return this.getMatches(this.makeFieldKey(schema, element, qualifier), query, collection, start, limit, locale);
    }

    @Override
    public Choices getMatches(String fieldKey, String query, Collection collection, int start, int limit, String locale) {
        ChoiceAuthority ma = this.getAuthorityByFieldKeyCollection(fieldKey, collection);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\", collection=" + collection.getID().toString() + ".");
        }
        return ma.getMatches(query, start, limit, locale);
    }

    @Override
    public Choices getBestMatch(String fieldKey, String query, Collection collection, String locale) {
        ChoiceAuthority ma = this.getAuthorityByFieldKeyCollection(fieldKey, collection);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\", collection=" + collection.getID().toString() + ".");
        }
        return ma.getBestMatch(query, locale);
    }

    @Override
    public String getLabel(MetadataValue metadataValue, Collection collection, String locale) {
        return this.getLabel(metadataValue.getMetadataField().toString(), collection, metadataValue.getAuthority(), locale);
    }

    @Override
    public String getLabel(String fieldKey, Collection collection, String authKey, String locale) {
        ChoiceAuthority ma = this.getAuthorityByFieldKeyCollection(fieldKey, collection);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\", collection=" + collection.getID().toString() + ".");
        }
        return ma.getLabel(authKey, locale);
    }

    @Override
    public boolean isChoicesConfigured(String fieldKey, Collection collection) {
        return this.getAuthorityByFieldKeyCollection(fieldKey, collection) != null;
    }

    @Override
    public String getPresentation(String fieldKey) {
        return this.getPresentationMap().get(fieldKey);
    }

    @Override
    public boolean isClosed(String fieldKey) {
        return this.getClosedMap().containsKey(fieldKey) && this.getClosedMap().get(fieldKey) != false;
    }

    @Override
    public List<String> getVariants(MetadataValue metadataValue, Collection collection) {
        String fieldKey = metadataValue.getMetadataField().toString();
        ChoiceAuthority ma = this.getAuthorityByFieldKeyCollection(fieldKey, collection);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\", collection=" + collection.getID().toString() + ".");
        }
        if (ma instanceof AuthorityVariantsSupport) {
            AuthorityVariantsSupport avs = (AuthorityVariantsSupport)((Object)ma);
            return avs.getVariants(metadataValue.getAuthority(), metadataValue.getLanguage());
        }
        return null;
    }

    @Override
    public String getChoiceAuthorityName(String schema, String element, String qualifier, Collection collection) {
        block3: {
            SubmissionConfig submissionConfig;
            String submissionName;
            Map<String, ChoiceAuthority> controllerFormDef;
            String fieldKey;
            block2: {
                this.init();
                fieldKey = this.makeFieldKey(schema, element, qualifier);
                if (!this.controller.containsKey(fieldKey)) break block2;
                for (Map.Entry<String, List<String>> authority2md : this.authorities.entrySet()) {
                    if (!authority2md.getValue().contains(fieldKey)) continue;
                    return authority2md.getKey();
                }
                break block3;
            }
            if (collection == null || !this.controllerFormDefinitions.containsKey(fieldKey) || !(controllerFormDef = this.controllerFormDefinitions.get(fieldKey)).containsKey(submissionName = (submissionConfig = this.submissionConfigService.getSubmissionConfigByCollection(collection)).getSubmissionName())) break block3;
            for (Map.Entry<String, Map<String, List<String>>> authority2defs2md : this.authoritiesFormDefinitions.entrySet()) {
                List<String> mdByDefinition = authority2defs2md.getValue().get(submissionName);
                if (mdByDefinition == null || !mdByDefinition.contains(fieldKey)) continue;
                return authority2defs2md.getKey();
            }
        }
        return null;
    }

    protected String makeFieldKey(String schema, String element, String qualifier) {
        return Utils.standardize(schema, element, qualifier, "_");
    }

    @Override
    public void clearCache() throws SubmissionConfigReaderException {
        this.controller.clear();
        this.authorities.clear();
        this.presentation.clear();
        this.closed.clear();
        this.controllerFormDefinitions.clear();
        this.authoritiesFormDefinitions.clear();
        this.submissionConfigService.reload();
        this.initialized = false;
    }

    private void loadChoiceAuthorityConfigurations() {
        List propKeys = this.configurationService.getPropertyKeys(CHOICES_PLUGIN_PREFIX);
        for (String key : propKeys) {
            String fkey = this.config2fkey(key.substring(CHOICES_PLUGIN_PREFIX.length()));
            if (fkey == null) {
                this.log.warn("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier");
                continue;
            }
            String authorityName = this.configurationService.getProperty(key);
            ChoiceAuthority ma = (ChoiceAuthority)this.pluginService.getNamedPlugin(ChoiceAuthority.class, authorityName);
            if (ma == null) {
                this.log.warn("Skipping invalid configuration for " + key + " because named plugin not found: " + authorityName);
                continue;
            }
            this.controller.put(fkey, ma);
            List<String> fkeys = this.authorities.containsKey(authorityName) ? this.authorities.get(authorityName) : new ArrayList<String>();
            fkeys.add(fkey);
            this.authorities.put(authorityName, fkeys);
            this.log.debug("Choice Control: For field=" + fkey + ", Plugin=" + ma);
        }
        this.autoRegisterChoiceAuthorityFromInputReader();
    }

    private void autoRegisterChoiceAuthorityFromInputReader() {
        try {
            List<SubmissionConfig> submissionConfigs = this.submissionConfigService.getAllSubmissionConfigs(Integer.MAX_VALUE, 0);
            DCInputsReader dcInputsReader = new DCInputsReader();
            for (SubmissionConfig subCfg : submissionConfigs) {
                String submissionName = subCfg.getSubmissionName();
                List<DCInputSet> inputsBySubmissionName = dcInputsReader.getInputsBySubmissionName(submissionName);
                for (DCInputSet dcinputSet : inputsBySubmissionName) {
                    DCInput[][] dcinputs;
                    DCInput[][] dCInputArray = dcinputs = dcinputSet.getFields();
                    int n = dCInputArray.length;
                    for (int i = 0; i < n; ++i) {
                        DCInput[] dcrows;
                        for (DCInput dcinput : dcrows = dCInputArray[i]) {
                            String authorityName = null;
                            if (StringUtils.isNotBlank((CharSequence)dcinput.getPairsType()) && !StringUtils.equals((CharSequence)dcinput.getInputType(), (CharSequence)"qualdrop_value")) {
                                authorityName = dcinput.getPairsType();
                            } else if (StringUtils.isNotBlank((CharSequence)dcinput.getVocabulary())) {
                                authorityName = dcinput.getVocabulary();
                            }
                            if (!StringUtils.isNotBlank(authorityName)) continue;
                            String fieldKey = this.makeFieldKey(dcinput.getSchema(), dcinput.getElement(), dcinput.getQualifier());
                            ChoiceAuthority ca = this.controller.get(authorityName);
                            if (ca == null && (ca = (ChoiceAuthority)this.pluginService.getNamedPlugin(ChoiceAuthority.class, authorityName)) == null) {
                                throw new IllegalStateException("Invalid configuration for " + fieldKey + " in submission definition " + submissionName + ", form definition " + dcinputSet.getFormName() + " no named plugin found: " + authorityName);
                            }
                            this.addAuthorityToFormCacheMap(submissionName, fieldKey, ca);
                            this.addFormDetailsToAuthorityCacheMap(submissionName, authorityName, fieldKey);
                        }
                    }
                }
            }
        }
        catch (DCInputsReaderException e) {
            throw new IllegalStateException("Error reading the item submission configuration: " + e.getMessage(), e);
        }
    }

    private void addFormDetailsToAuthorityCacheMap(String submissionName, String authorityName, String fieldKey) {
        Map<Object, Object> submissionDefinitionNames2fieldKeys = this.authoritiesFormDefinitions.containsKey(authorityName) ? this.authoritiesFormDefinitions.get(authorityName) : new HashMap();
        List fields = submissionDefinitionNames2fieldKeys.containsKey(submissionName) ? (List)submissionDefinitionNames2fieldKeys.get(submissionName) : new ArrayList();
        fields.add(fieldKey);
        submissionDefinitionNames2fieldKeys.put(submissionName, fields);
        this.authoritiesFormDefinitions.put(authorityName, submissionDefinitionNames2fieldKeys);
    }

    private void addAuthorityToFormCacheMap(String submissionName, String fieldKey, ChoiceAuthority ca) {
        Map<String, ChoiceAuthority> definition2authority = this.controllerFormDefinitions.containsKey(fieldKey) ? this.controllerFormDefinitions.get(fieldKey) : new HashMap<String, ChoiceAuthority>();
        definition2authority.put(submissionName, ca);
        this.controllerFormDefinitions.put(fieldKey, definition2authority);
    }

    private Map<String, String> getPresentationMap() {
        if (this.presentation.isEmpty()) {
            List propKeys = this.configurationService.getPropertyKeys(CHOICES_PRESENTATION_PREFIX);
            for (String key : propKeys) {
                String fkey = this.config2fkey(key.substring(CHOICES_PRESENTATION_PREFIX.length()));
                if (fkey == null) {
                    this.log.warn("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier");
                    continue;
                }
                this.presentation.put(fkey, this.configurationService.getProperty(key));
            }
        }
        return this.presentation;
    }

    private Map<String, Boolean> getClosedMap() {
        if (this.closed.isEmpty()) {
            List propKeys = this.configurationService.getPropertyKeys(CHOICES_CLOSED_PREFIX);
            for (String key : propKeys) {
                String fkey = this.config2fkey(key.substring(CHOICES_CLOSED_PREFIX.length()));
                if (fkey == null) {
                    this.log.warn("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier");
                    continue;
                }
                this.closed.put(fkey, this.configurationService.getBooleanProperty(key));
            }
        }
        return this.closed;
    }

    @Override
    public ChoiceAuthority getChoiceAuthorityByAuthorityName(String authorityName) {
        ChoiceAuthority ma = (ChoiceAuthority)this.pluginService.getNamedPlugin(ChoiceAuthority.class, authorityName);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for authorityName \"" + authorityName + "\".");
        }
        return ma;
    }

    private ChoiceAuthority getAuthorityByFieldKeyCollection(String fieldKey, Collection collection) {
        this.init();
        ChoiceAuthority ma = this.controller.get(fieldKey);
        if (ma == null && collection != null) {
            try {
                SubmissionConfigService configReaderService = SubmissionServiceFactory.getInstance().getSubmissionConfigService();
                SubmissionConfig submissionName = configReaderService.getSubmissionConfigByCollection(collection);
                ma = this.controllerFormDefinitions.get(fieldKey).get(submissionName.getSubmissionName());
            }
            catch (SubmissionConfigReaderException e) {
                throw new IllegalStateException("Error reading the item submission configuration: " + e.getMessage(), e);
            }
        }
        return ma;
    }

    @Override
    public boolean storeAuthority(String fieldKey, Collection collection) {
        return this.controller.containsKey(fieldKey);
    }

    @Override
    public Choices getChoicesByParent(String authorityName, String parentId, int start, int limit, String locale) {
        HierarchicalAuthority ma = (HierarchicalAuthority)this.getChoiceAuthorityByAuthorityName(authorityName);
        return ma.getChoicesByParent(authorityName, parentId, start, limit, locale);
    }

    @Override
    public Choices getTopChoices(String authorityName, int start, int limit, String locale) {
        HierarchicalAuthority ma = (HierarchicalAuthority)this.getChoiceAuthorityByAuthorityName(authorityName);
        return ma.getTopChoices(authorityName, start, limit, locale);
    }

    @Override
    public Choice getParentChoice(String authorityName, String vocabularyId, String locale) {
        HierarchicalAuthority ma = (HierarchicalAuthority)this.getChoiceAuthorityByAuthorityName(authorityName);
        return ma.getParentChoice(authorityName, vocabularyId, locale);
    }

    @Override
    public DSpaceControlledVocabularyIndex getVocabularyIndex(String nameVocab) {
        if (this.vocabularyIndexMap.containsKey(nameVocab)) {
            return this.vocabularyIndexMap.get(nameVocab);
        }
        this.init();
        ChoiceAuthority source = this.getChoiceAuthorityByAuthorityName(nameVocab);
        if (source != null && source instanceof DSpaceControlledVocabulary) {
            Object[] vocabulariesDisabled = this.configurationService.getArrayProperty("webui.browse.vocabularies.disabled");
            if (vocabulariesDisabled != null && ArrayUtils.contains((Object[])vocabulariesDisabled, (Object)nameVocab)) {
                return null;
            }
            HashSet<String> metadataFields = new HashSet<String>();
            Map<String, List<String>> formsToFields = this.authoritiesFormDefinitions.get(nameVocab);
            if (formsToFields == null) {
                return null;
            }
            for (Map.Entry<String, List<String>> entry : formsToFields.entrySet()) {
                metadataFields.addAll(entry.getValue().stream().map(value -> StringUtils.replace((String)value, (String)"_", (String)".")).collect(Collectors.toList()));
            }
            DiscoverySearchFilterFacet matchingFacet = null;
            for (DiscoverySearchFilterFacet facetConfig : this.searchConfigurationService.getAllUniqueFacetsConfig()) {
                boolean coversAllFieldsFromVocab = true;
                for (String fieldFromVocab : metadataFields) {
                    boolean coversFieldFromVocab = false;
                    for (String facetMdField : facetConfig.getMetadataFields()) {
                        if (!facetMdField.startsWith(fieldFromVocab)) continue;
                        coversFieldFromVocab = true;
                        break;
                    }
                    if (coversFieldFromVocab) continue;
                    coversAllFieldsFromVocab = false;
                    break;
                }
                if (!coversAllFieldsFromVocab) continue;
                matchingFacet = facetConfig;
                break;
            }
            if (matchingFacet == null) {
                return null;
            }
            DSpaceControlledVocabularyIndex dSpaceControlledVocabularyIndex = new DSpaceControlledVocabularyIndex((DSpaceControlledVocabulary)source, metadataFields, matchingFacet);
            this.vocabularyIndexMap.put(nameVocab, dSpaceControlledVocabularyIndex);
            return dSpaceControlledVocabularyIndex;
        }
        return null;
    }
}

