/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.contentreport;

import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.dspace.contentreport.Filter;

public class FilteredCollection
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -231735620268582719L;
    private String label;
    private String handle;
    private String communityLabel;
    private String communityHandle;
    private int totalItems;
    private Map<Filter, Integer> values = new EnumMap<Filter, Integer>(Filter.class);
    private int allFiltersValue;
    private boolean sealed;

    public static FilteredCollection of(String label, String handle, String communityLabel, String communityHandle, int totalItems, int allFiltersValue, Map<Filter, Integer> values, boolean doSeal) {
        FilteredCollection coll = new FilteredCollection();
        coll.label = label;
        coll.handle = handle;
        coll.communityLabel = communityLabel;
        coll.communityHandle = communityHandle;
        coll.totalItems = totalItems;
        coll.allFiltersValue = allFiltersValue;
        Optional.ofNullable(values).ifPresent(vs -> vs.forEach(coll::addValue));
        if (doSeal) {
            coll.seal();
        }
        return coll;
    }

    public Map<Filter, Integer> getValues() {
        if (this.sealed) {
            return new EnumMap<Filter, Integer>(this.values);
        }
        return this.values;
    }

    public void addValue(Filter filter, int delta) {
        this.checkSealed();
        Integer oldValue = this.values.getOrDefault((Object)filter, 0);
        int newValue = oldValue + delta;
        this.values.put(filter, newValue);
    }

    public void setValues(Map<? extends Filter, ? extends Integer> values) {
        this.checkSealed();
        this.values.clear();
        this.values.putAll(values);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.checkSealed();
        this.label = label;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.checkSealed();
        this.handle = handle;
    }

    public String getCommunityLabel() {
        return this.communityLabel;
    }

    public void setCommunityLabel(String communityLabel) {
        this.checkSealed();
        this.communityLabel = communityLabel;
    }

    public String getCommunityHandle() {
        return this.communityHandle;
    }

    public void setCommunityHandle(String communityHandle) {
        this.checkSealed();
        this.communityHandle = communityHandle;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(int totalItems) {
        this.checkSealed();
        this.totalItems = totalItems;
    }

    public int getAllFiltersValue() {
        return this.allFiltersValue;
    }

    public void addAllFiltersValue(int delta) {
        this.checkSealed();
        ++this.allFiltersValue;
    }

    public void setAllFiltersValue(int allFiltersValue) {
        this.checkSealed();
        this.allFiltersValue = allFiltersValue;
    }

    public boolean getSealed() {
        return this.sealed;
    }

    public void seal() {
        this.sealed = true;
    }

    private void checkSealed() {
        if (this.sealed) {
            throw new IllegalStateException("This filtered collection record is sealed and cannot be modified anymore. You can apply changes to a non-sealed clone.");
        }
    }

    public FilteredCollection clone() {
        FilteredCollection clone = new FilteredCollection();
        clone.label = this.label;
        clone.handle = this.handle;
        clone.values.putAll(this.values);
        clone.allFiltersValue = this.allFiltersValue;
        return clone;
    }
}

