/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.UUID;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResultIterator;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.indexobject.IndexableClaimedTask;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.IndexablePoolTask;
import org.dspace.discovery.indexobject.IndexableWorkflowItem;
import org.dspace.discovery.indexobject.IndexableWorkspaceItem;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class DiscoverResultItemIterator
extends DiscoverResultIterator<Item, UUID> {
    public DiscoverResultItemIterator(Context context, DiscoverQuery discoverQuery) {
        super(context, discoverQuery);
    }

    public DiscoverResultItemIterator(Context context, DiscoverQuery discoverQuery, boolean uncacheEntities) {
        super(context, discoverQuery, uncacheEntities);
    }

    public DiscoverResultItemIterator(Context context, IndexableObject<?, ?> scopeObject, DiscoverQuery discoverQuery) {
        super(context, scopeObject, discoverQuery);
    }

    public DiscoverResultItemIterator(Context context, DiscoverQuery discoverQuery, int maxResults) {
        super(context, null, discoverQuery, true, maxResults);
    }

    public DiscoverResultItemIterator(Context context, IndexableObject<?, ?> scopeObject, DiscoverQuery discoverQuery, int maxResults) {
        super(context, scopeObject, discoverQuery, true, maxResults);
    }

    @Override
    public Item next() {
        IndexableObject nextIndexableObject = this.getNextIndexableObject();
        String objectType = nextIndexableObject.getType();
        if (IndexableItem.TYPE.equals(objectType)) {
            return (Item)((IndexableItem)nextIndexableObject).getIndexedObject();
        }
        if (IndexableWorkflowItem.TYPE.equals(objectType)) {
            return ((XmlWorkflowItem)((IndexableWorkflowItem)nextIndexableObject).getIndexedObject()).getItem();
        }
        if (IndexableWorkspaceItem.TYPE.equals(objectType)) {
            return ((WorkspaceItem)((IndexableWorkspaceItem)nextIndexableObject).getIndexedObject()).getItem();
        }
        if (IndexablePoolTask.TYPE.equals(objectType)) {
            return ((IndexablePoolTask)nextIndexableObject).getIndexedObject().getWorkflowItem().getItem();
        }
        if (IndexableClaimedTask.TYPE.equals(objectType)) {
            return ((IndexableClaimedTask)nextIndexableObject).getIndexedObject().getWorkflowItem().getItem();
        }
        throw new IllegalStateException("Invalid object type for discover item iterator: " + objectType);
    }
}

