/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceGeospatialFilterPlugin
implements SolrServiceIndexPlugin {
    @Autowired
    ConfigurationService configurationService;
    @Autowired
    ItemService itemService;

    @Override
    public void additionalIndex(Context context, IndexableObject indexableObject, SolrInputDocument document) {
        if (indexableObject instanceof IndexableItem) {
            Item item = (Item)((IndexableItem)indexableObject).getIndexedObject();
            String geospatialField = this.configurationService.getProperty("discovery.filter.geospatial.field");
            if (geospatialField == null) {
                return;
            }
            String[] fieldParts = geospatialField.split("\\.", 3);
            if (fieldParts.length < 2) {
                return;
            }
            boolean hasGeospatialMetadata = this.itemService.getMetadataFirstValue(item, fieldParts[0], fieldParts[1], fieldParts.length > 2 ? fieldParts[2] : null, "*") != null;
            document.addField("has_geospatial_metadata", (Object)hasGeospatialMetadata);
            document.addField("has_geospatial_metadata_keyword", (Object)hasGeospatialMetadata);
            document.addField("has_geospatial_metadata_filter", (Object)hasGeospatialMetadata);
        }
    }
}

