/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class RegistrationDataExpirationConfiguration {
    private static final String EXPIRATION_PROP = "eperson.registration-data.token.{0}.expiration";
    private static final String DURATION_FORMAT = "PT{0}";
    public static final RegistrationDataExpirationConfiguration INSTANCE = new RegistrationDataExpirationConfiguration();
    private final Map<RegistrationTypeEnum, Duration> expirationMap = Stream.of(RegistrationTypeEnum.values()).map(type -> Optional.ofNullable(this.getDurationOf((RegistrationTypeEnum)((Object)type))).map(duration -> Map.entry(type, duration)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    public static RegistrationDataExpirationConfiguration getInstance() {
        return INSTANCE;
    }

    private RegistrationDataExpirationConfiguration() {
    }

    private Duration getDurationOf(RegistrationTypeEnum type) {
        String format = MessageFormat.format(EXPIRATION_PROP, type.toString().toLowerCase());
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        String typeValue = config.getProperty(format);
        if (StringUtils.isBlank((CharSequence)typeValue)) {
            return null;
        }
        return Duration.parse(MessageFormat.format(DURATION_FORMAT, typeValue));
    }

    public Duration getExpiration(RegistrationTypeEnum type) {
        return this.expirationMap.get((Object)type);
    }

    public Instant computeExpirationDate(RegistrationTypeEnum type) {
        if (type == null) {
            return null;
        }
        Duration duration = this.expirationMap.get((Object)type);
        if (duration == null) {
            return null;
        }
        return Instant.now().plus(duration);
    }
}

