/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson.factory;

import org.dspace.eperson.factory.CaptchaServiceFactory;
import org.dspace.eperson.service.CaptchaService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CaptchaServiceFactoryImpl
extends CaptchaServiceFactory {
    @Autowired
    @Qualifier(value="googleCaptchaService")
    private CaptchaService googleCaptchaService;
    @Autowired
    @Qualifier(value="altchaCaptchaService")
    private CaptchaService altchaCaptchaService;
    @Autowired
    private ConfigurationService configurationService;

    @Override
    public CaptchaService getCaptchaService() {
        String provider = this.configurationService.getProperty("captcha.provider", "google");
        if ("altcha".equalsIgnoreCase(provider)) {
            return this.altchaCaptchaService;
        }
        return this.googleCaptchaService;
    }

    @Override
    public CaptchaService getAltchaCaptchaService() {
        return this.altchaCaptchaService;
    }

    @Override
    public CaptchaService getGoogleCaptchaService() {
        return this.googleCaptchaService;
    }
}

