/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.io.IOException;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.dspace.content.Collection;
import org.dspace.core.Context;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.OAIHarvester;
import org.dspace.harvest.dao.HarvestedCollectionDAO;
import org.dspace.harvest.service.HarvestedCollectionService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.DOMBuilder;
import org.oclc.oai.harvester2.verb.Identify;
import org.oclc.oai.harvester2.verb.ListIdentifiers;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class HarvestedCollectionServiceImpl
implements HarvestedCollectionService {
    private static final Namespace ORE_NS = Namespace.getNamespace((String)"http://www.openarchives.org/ore/terms/");
    private static final Namespace OAI_NS = Namespace.getNamespace((String)"http://www.openarchives.org/OAI/2.0/");
    @Autowired(required=true)
    protected HarvestedCollectionDAO harvestedCollectionDAO;

    protected HarvestedCollectionServiceImpl() {
    }

    @Override
    public HarvestedCollection find(Context context, Collection collection) throws SQLException {
        return this.harvestedCollectionDAO.findByCollection(context, collection);
    }

    @Override
    public HarvestedCollection create(Context context, Collection collection) throws SQLException {
        HarvestedCollection harvestedCollection = this.harvestedCollectionDAO.create(context, new HarvestedCollection());
        harvestedCollection.setCollection(collection);
        harvestedCollection.setHarvestType(0);
        this.update(context, harvestedCollection);
        return harvestedCollection;
    }

    @Override
    public boolean isHarvestable(Context context, Collection collection) throws SQLException {
        HarvestedCollection hc = this.find(context, collection);
        return hc != null && hc.getHarvestType() > 0 && hc.getOaiSource() != null && hc.getOaiSetId() != null && hc.getHarvestStatus() != -1;
    }

    @Override
    public boolean isHarvestable(HarvestedCollection harvestedCollection) throws SQLException {
        return harvestedCollection.getHarvestType() > 0 && harvestedCollection.getOaiSource() != null && harvestedCollection.getOaiSetId() != null && harvestedCollection.getHarvestStatus() != -1;
    }

    @Override
    public boolean isReady(Context context, Collection collection) throws SQLException {
        HarvestedCollection hc = this.find(context, collection);
        return this.isReady(hc);
    }

    @Override
    public boolean isReady(HarvestedCollection harvestedCollection) throws SQLException {
        return this.isHarvestable(harvestedCollection) && (harvestedCollection.getHarvestStatus() == 0 || harvestedCollection.getHarvestStatus() == 3);
    }

    @Override
    public List<HarvestedCollection> findAll(Context context) throws SQLException {
        return this.harvestedCollectionDAO.findAll(context, HarvestedCollection.class);
    }

    @Override
    public List<HarvestedCollection> findReady(Context context) throws SQLException {
        int expirationInterval;
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        int harvestInterval = configurationService.getIntProperty("oai.harvester.harvestFrequency");
        if (harvestInterval == 0) {
            harvestInterval = 720;
        }
        if ((expirationInterval = configurationService.getIntProperty("oai.harvester.threadTimeout")) == 0) {
            expirationInterval = 24;
        }
        Instant startTime = Instant.now().minus(harvestInterval, ChronoUnit.MINUTES);
        Instant expirationTime = startTime.minus(2L * (long)expirationInterval, ChronoUnit.HOURS);
        int[] statuses = new int[]{0, 3};
        return this.harvestedCollectionDAO.findByLastHarvestedAndHarvestTypeAndHarvestStatusesAndHarvestTime(context, startTime, 0, statuses, 1, expirationTime);
    }

    @Override
    public List<HarvestedCollection> findByStatus(Context context, int status) throws SQLException {
        return this.harvestedCollectionDAO.findByStatus(context, status);
    }

    @Override
    public HarvestedCollection findOldestHarvest(Context context) throws SQLException {
        return this.harvestedCollectionDAO.findByStatusAndMinimalTypeOrderByLastHarvestedAsc(context, 0, 0, 1);
    }

    @Override
    public HarvestedCollection findNewestHarvest(Context context) throws SQLException {
        return this.harvestedCollectionDAO.findByStatusAndMinimalTypeOrderByLastHarvestedDesc(context, 0, 0, 1);
    }

    @Override
    public void delete(Context context, HarvestedCollection harvestedCollection) throws SQLException {
        this.harvestedCollectionDAO.delete(context, harvestedCollection);
    }

    @Override
    public void update(Context context, HarvestedCollection harvestedCollection) throws SQLException {
        this.harvestedCollectionDAO.save(context, harvestedCollection);
    }

    @Override
    public boolean exists(Context context) throws SQLException {
        return 0 < this.harvestedCollectionDAO.count(context);
    }

    @Override
    public List<String> verifyOAIharvester(String oaiSource, String oaiSetId, String metaPrefix, boolean testORE) {
        ArrayList<String> errorSet = new ArrayList<String>();
        try {
            new Identify(oaiSource);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            errorSet.add("invalidAddress: OAI server could not be reached.");
            return errorSet;
        }
        Namespace DMD_NS = OAIHarvester.getDMDNamespace(metaPrefix);
        if (null == DMD_NS) {
            errorSet.add("metadataNotSupported:  " + metaPrefix);
            return errorSet;
        }
        String OREOAIPrefix = null;
        String DMDOAIPrefix = null;
        try {
            OREOAIPrefix = OAIHarvester.oaiResolveNamespaceToPrefix(oaiSource, OAIHarvester.getORENamespace().getURI());
            DMDOAIPrefix = OAIHarvester.oaiResolveNamespaceToPrefix(oaiSource, DMD_NS.getURI());
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            errorSet.add("invalidAddress: OAI did not respond to ListMetadataFormats query  (" + ORE_NS.getPrefix() + ":" + OREOAIPrefix + " ; " + DMD_NS.getPrefix() + ":" + DMDOAIPrefix + "):  " + ex.getMessage());
            return errorSet;
        }
        if (testORE && OREOAIPrefix == null) {
            errorSet.add("oreNotSupported: The OAI server does not support ORE dissemination");
        }
        if (DMDOAIPrefix == null) {
            errorSet.add("metadataNotSupported: The OAI server does not support dissemination in this format");
        }
        boolean foundSet = false;
        try {
            if (!"all".equals(oaiSetId)) {
                ListIdentifiers ls = new ListIdentifiers(oaiSource, null, null, oaiSetId, DMDOAIPrefix);
                if (ls.getErrors() != null && ls.getErrors().getLength() > 0) {
                    for (int i = 0; i < ls.getErrors().getLength(); ++i) {
                        String errorCode = ls.getErrors().item(i).getAttributes().getNamedItem("code").getTextContent();
                        errorSet.add("noSuchSet: The OAI server does not have a set with the specified setSpec (" + errorCode + ")");
                    }
                } else {
                    DOMBuilder db = new DOMBuilder();
                    Document reply = db.build(ls.getDocument());
                    Element root = reply.getRootElement();
                    boolean bl = foundSet = 0 < root.getChild("ListIdentifiers", OAI_NS).getChildren().size();
                    if (!foundSet) {
                        errorSet.add("noSuchSet: The OAI server does not have a set with the specified setSpec");
                    }
                }
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | DOMException | SAXException e) {
            errorSet.add("invalidAddress: OAI server could not be reached");
            return errorSet;
        }
        catch (RuntimeException re) {
            throw re;
        }
        return errorSet;
    }
}

