/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.health;

import java.io.File;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.commons.io.FileUtils;
import org.dspace.health.Check;
import org.dspace.health.ReportInfo;
import org.dspace.services.ConfigurationService;
import org.dspace.storage.bitstore.DSBitStoreService;
import org.dspace.utils.DSpace;

public class InfoCheck
extends Check {
    @Override
    public String run(ReportInfo ri) {
        ConfigurationService configurationService = new DSpace().getConfigurationService();
        StringBuilder sb = new StringBuilder();
        sb.append("Generated: ").append(Instant.now().toString()).append("\n");
        sb.append("From - Till: ").append(DateTimeFormatter.ISO_LOCAL_DATE.format(ri.from())).append(" - ").append(DateTimeFormatter.ISO_LOCAL_DATE.format(ri.till())).append("\n");
        sb.append("Url: ").append(configurationService.getProperty("dspace.ui.url")).append("\n");
        sb.append("\n");
        DSBitStoreService localStore = (DSBitStoreService)new DSpace().getServiceManager().getServicesByType(DSBitStoreService.class).get(0);
        for (String[] ss : new String[][]{{localStore.getBaseDir().toString(), "Assetstore size"}, {configurationService.getProperty("log.report.dir"), "Log dir size"}}) {
            if (ss[0] != null) {
                try {
                    File dir = new File(ss[0]);
                    if (dir.exists()) {
                        long dir_size = FileUtils.sizeOfDirectory((File)dir);
                        sb.append(String.format("%-20s: %s\n", ss[1], FileUtils.byteCountToDisplaySize((long)dir_size)));
                        continue;
                    }
                    sb.append(String.format("Directory [%s] does not exist!\n", ss[0]));
                }
                catch (Exception e) {
                    this.error(e, "directory - " + ss[0]);
                }
                continue;
            }
            sb.append(String.format("Could not get information for %s!\n", ss[1]));
        }
        return sb.toString();
    }
}

