/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.pubmedeurope;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.QuerySource;
import org.jaxen.JaxenException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class PubmedEuropeMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<Element>
implements QuerySource {
    private static final Logger log = LogManager.getLogger();
    private String url;
    @Autowired
    private LiveImportClient liveImportClient;

    @Override
    public String getImportSource() {
        return "pubmedeu";
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(id));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query, count, start));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(query));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        return this.retry(new FindMatchingRecordCallable(query));
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for PubMed Europe");
    }

    @Override
    public void init() throws Exception {
    }

    public List<ImportRecord> getByPubmedEuropeID(String pubmedID, Integer start, Integer size) throws IOException, HttpException {
        String query = "(EXT_ID:" + pubmedID + ")";
        return this.search(query, size < 1 ? 1 : size, start);
    }

    public Integer count(String query) throws URISyntaxException, ClientProtocolException, IOException, JaxenException {
        try {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            String response = this.liveImportClient.executeHttpGetRequest(1000, this.buildURI(1, query), params);
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = saxBuilder.build((Reader)new StringReader(response));
            Element root = document.getRootElement();
            Element element = root.getChild("hitCount");
            return Integer.parseInt(element.getValue());
        }
        catch (JDOMException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<ImportRecord> search(String title, String author, int year, int count, int start) throws IOException {
        StringBuffer query = new StringBuffer();
        query.append("(");
        if (StringUtils.isNotBlank((CharSequence)title)) {
            query.append("TITLE:").append(title);
            query.append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)author)) {
            String splitRegex = "(\\s*,\\s+|\\s*;\\s+|\\s*;+|\\s*,+|\\s+)";
            String[] authors = author.split(splitRegex);
            if (query.length() > 0) {
                query.append(" AND ");
            }
            query.append("(");
            int countAuthors = 0;
            for (String auth : authors) {
                query.append("AUTH:\"").append(auth).append("\"");
                if (++countAuthors >= authors.length) continue;
                query.append(" AND ");
            }
            query.append(")");
        }
        if (year != -1) {
            if (query.length() > 0) {
                query.append(" AND ");
            }
            query.append("( PUB_YEAR:").append(year).append(")");
        }
        query.append(")");
        return this.search(query.toString(), count, start);
    }

    public List<ImportRecord> search(String query, Integer size, Integer start) throws IOException {
        ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
        try {
            URIBuilder uriBuilder = new URIBuilder(this.url);
            uriBuilder.addParameter("format", "xml");
            uriBuilder.addParameter("resulttype", "core");
            uriBuilder.addParameter("pageSize", String.valueOf(size));
            uriBuilder.addParameter("query", query);
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            boolean lastPage = false;
            int skipped = 0;
            while (!lastPage || results.size() < size) {
                String response = this.liveImportClient.executeHttpGetRequest(1000, uriBuilder.toString(), params);
                String cursorMark = "";
                if (StringUtils.isNotBlank((CharSequence)response)) {
                    SAXBuilder saxBuilder = new SAXBuilder();
                    saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    Document document = saxBuilder.build((Reader)new StringReader(response));
                    XPathFactory xpfac = XPathFactory.instance();
                    XPathExpression xPath = xpfac.compile("//responseWrapper/resultList/result", Filters.element());
                    List records = xPath.evaluate((Object)document);
                    if (records.size() <= 0) {
                        lastPage = true;
                        break;
                    }
                    for (Element item : records) {
                        if (start > skipped) {
                            ++skipped;
                            continue;
                        }
                        results.add(this.transformSourceRecords(item));
                    }
                    Element root = document.getRootElement();
                    Element nextCursorMark = root.getChild("nextCursorMark");
                    String string = cursorMark = Objects.nonNull(nextCursorMark) ? nextCursorMark.getValue() : "";
                }
                if (StringUtils.isNotBlank((CharSequence)cursorMark)) {
                    uriBuilder.setParameter("cursorMar", cursorMark);
                    continue;
                }
                lastPage = true;
            }
        }
        catch (URISyntaxException | JDOMException e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return results;
    }

    private String buildURI(Integer pageSize, String query) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(this.url);
        uriBuilder.addParameter("format", "xml");
        uriBuilder.addParameter("resulttype", "core");
        uriBuilder.addParameter("pageSize", String.valueOf(pageSize));
        uriBuilder.addParameter("query", query);
        return uriBuilder.toString();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private class SearchByIdCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByIdCallable(Query query) {
            this.query = query;
        }

        private SearchByIdCallable(String id) {
            this.query = new Query();
            this.query.addParameter("id", id);
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            return PubmedEuropeMetadataSourceServiceImpl.this.getByPubmedEuropeID(this.query.getParameterAsClass("id", String.class), 1, 0);
        }
    }

    private class CountByQueryCallable
    implements Callable<Integer> {
        private Query query;

        private CountByQueryCallable(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        private CountByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            try {
                return PubmedEuropeMetadataSourceServiceImpl.this.count(this.query.getParameterAsClass("query", String.class));
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByQueryCallable(String queryString, Integer maxResult, Integer start) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("count", maxResult);
            this.query.addParameter("start", start);
        }

        private SearchByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            String queryString = this.query.getParameterAsClass("query", String.class);
            return PubmedEuropeMetadataSourceServiceImpl.this.search(queryString, count, start);
        }
    }

    public class FindMatchingRecordCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private FindMatchingRecordCallable(Query q) {
            this.query = q;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            String title = this.query.getParameterAsClass("title", String.class);
            String author = this.query.getParameterAsClass("author", String.class);
            Integer year = this.query.getParameterAsClass("year", Integer.class);
            Integer maxResult = this.query.getParameterAsClass("maxResult", Integer.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            return PubmedEuropeMetadataSourceServiceImpl.this.search(title, author, year, maxResult, start);
        }
    }
}

