/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.service.components;

import jakarta.annotation.Resource;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.exception.SourceExceptionHandler;

public abstract class AbstractRemoteMetadataSource {
    protected long lastRequest = 0L;
    protected long interRequestTime;
    protected ReentrantLock lock = new ReentrantLock();
    protected int maxRetry = 20;
    protected int retry;
    protected String operationId;
    protected String warning;
    protected Map<Class, List<SourceExceptionHandler>> exceptionHandlersMap;
    protected Exception error;
    private static Logger log = LogManager.getLogger(AbstractRemoteMetadataSource.class);

    protected AbstractRemoteMetadataSource() {
        this.initExceptionHandlers();
    }

    protected void initExceptionHandlers() {
        this.exceptionHandlersMap = new LinkedHashMap<Class, List<SourceExceptionHandler>>();
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public int getRetry() {
        return this.retry;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    @Resource(name="maxRetry")
    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T retry(Callable<T> callable) throws MetadataSourceException {
        this.retry = 0;
        this.operationId = UUID.randomUUID().toString();
        while (true) {
            try {
                this.lock.lock();
                this.error = null;
                long time = Instant.now().toEpochMilli() - this.lastRequest;
                if (time < this.interRequestTime) {
                    Thread.sleep(this.interRequestTime - time);
                }
                try {
                    this.init();
                }
                catch (Exception e) {
                    this.throwSourceException(this.retry, e, this.operationId);
                }
                log.debug("Operation {} started. Calling {}", (Object)this.operationId, (Object)callable.getClass().getName());
                T response = callable.call();
                log.debug("Operation {} successful", (Object)this.operationId);
                T t = response;
                return t;
            }
            catch (Exception e) {
                this.error = e;
                if (this.retry > this.maxRetry) {
                    this.throwSourceException(this.retry, e, this.operationId);
                }
                this.handleException(this.retry, e, this.operationId);
                ++this.retry;
                log.warn("Error in calling {} in operation {} {} {}, retrying!", (Object)callable.getClass().getName(), (Object)this.operationId, (Object)this.retry, (Object)this.warning, (Object)e);
            }
            finally {
                this.lastRequest = Instant.now().toEpochMilli();
                this.lock.unlock();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                this.throwSourceException(this.retry, e, this.operationId);
                continue;
            }
            break;
        }
    }

    protected void handleException(int retry, Exception exception, String operationId) throws MetadataSourceException {
        List<SourceExceptionHandler> exceptionHandlers = this.getExceptionHandler(exception);
        if (exceptionHandlers != null && !exceptionHandlers.isEmpty()) {
            for (SourceExceptionHandler exceptionHandler : exceptionHandlers) {
                exceptionHandler.handle(this);
            }
        } else {
            this.throwSourceException(retry, exception, operationId);
        }
    }

    protected List<SourceExceptionHandler> getExceptionHandler(Exception exception) {
        for (Class aClass : this.exceptionHandlersMap.keySet()) {
            if (!aClass.isInstance(exception)) continue;
            return this.exceptionHandlersMap.get(aClass);
        }
        return null;
    }

    protected void throwSourceException(int retry, Exception exception, String operationId) throws MetadataSourceException {
        this.throwSourceExceptionHook();
        log.error("Source exception " + exception.getMessage(), (Throwable)exception);
        throw new MetadataSourceException("At retry of operation " + operationId + " " + retry, exception);
    }

    protected void throwSourceExceptionHook() {
    }

    public abstract void init() throws Exception;

    public void setInterRequestTime(long interRequestTime) {
        this.interRequestTime = interRequestTime;
    }
}

