/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.service.BitstreamService;
import org.dspace.matomo.MatomoUsageEventHandler;
import org.dspace.services.ConfigurationService;
import org.dspace.services.model.Event;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class MatomoEventListener
extends AbstractUsageEventListener {
    private static final Logger log = LogManager.getLogger(MatomoEventListener.class);
    private final ConfigurationService configurationService;
    private final BitstreamService bitstreamService;
    private final List<MatomoUsageEventHandler> matomoUsageEventHandlers;

    public MatomoEventListener(@Autowired List<MatomoUsageEventHandler> matomoUsageEventHandlers, @Autowired ConfigurationService configurationService, @Autowired BitstreamService bitstreamService) {
        this.matomoUsageEventHandlers = matomoUsageEventHandlers;
        this.configurationService = configurationService;
        this.bitstreamService = bitstreamService;
    }

    public void receiveEvent(Event event) {
        if (!(event instanceof UsageEvent)) {
            return;
        }
        UsageEvent usageEvent = (UsageEvent)event;
        try {
            if (!this.matomoEnabled() || this.matomoUsageEventHandlers == null || this.matomoUsageEventHandlers.isEmpty()) {
                return;
            }
            if (!this.isContentBitstream(usageEvent)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Usage event received {}", (Object)event.getName());
            }
            this.matomoUsageEventHandlers.forEach(handler -> handler.handleEvent(usageEvent));
        }
        catch (Exception e) {
            log.error("Failed to add the UsageEvent to Matomo Handlers {} ", (Object)usageEvent, (Object)e);
        }
    }

    private boolean matomoEnabled() {
        return this.configurationService.getBooleanProperty("matomo.enabled", false);
    }

    private boolean isContentBitstream(UsageEvent usageEvent) {
        if (!this.isBitstreamView(usageEvent)) {
            return false;
        }
        Set<String> allowedBundles = this.getTrackedBundles();
        if (allowedBundles.contains("none")) {
            return false;
        }
        return this.isInBundle((Bitstream)usageEvent.getObject(), allowedBundles);
    }

    private Set<String> getTrackedBundles() {
        return Set.of(this.configurationService.getArrayProperty("matomo.track.bundles", new String[]{"ORIGINAL"}));
    }

    protected boolean isInBundle(Bitstream bitstream, Set<String> allowedBundles) {
        try {
            return this.bitstreamService.isInBundle(bitstream, allowedBundles);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean isBitstreamView(UsageEvent usageEvent) {
        return usageEvent.getAction() == UsageEvent.Action.VIEW && usageEvent.getObject().getType() == 0;
    }
}

