/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.matomo.client.MatomoBulkRequest;

public class MatomoRequestBuilder {
    private static final Logger log = LogManager.getLogger(MatomoRequestBuilder.class);
    ObjectMapper objectMapper = new ObjectMapper();

    public MatomoRequestBuilder() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    String buildJSON(MatomoBulkRequest request) {
        if (request == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString((Object)request);
        }
        catch (JsonProcessingException e) {
            log.error("Cannot convert the Matomo request properly!", (Throwable)e);
            return null;
        }
    }
}

