/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.matomo.client.MatomoResponse;

public class MatomoResponseReader {
    private static final Logger log = LogManager.getLogger(MatomoResponseReader.class);
    ObjectMapper objectMapper = new ObjectMapper();

    public MatomoResponseReader() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    MatomoResponse fromJSON(String response) {
        if (response == null) {
            return null;
        }
        try {
            return (MatomoResponse)this.objectMapper.readValue(response, MatomoResponse.class);
        }
        catch (JsonProcessingException e) {
            log.error("Cannot convert the Matomo response: {} properly!", (Object)response, (Object)e);
            return null;
        }
    }
}

