/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.factory;

import java.sql.SQLException;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.matomo.factory.MatomoRequestDetailsEnricher;
import org.dspace.matomo.factory.MatomoRequestTrackerIdentifierParamEnricher;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.usage.UsageEvent;

public class MatomoRequestDetailsEnricherFactory {
    private static final Logger log = LogManager.getLogger(MatomoRequestDetailsEnricherFactory.class);

    private MatomoRequestDetailsEnricherFactory() {
    }

    public static MatomoRequestDetailsEnricher userAgentEnricher() {
        return (usageEvent, details) -> details.addParameter("ua", StringUtils.defaultIfBlank((String)usageEvent.getRequest().getHeader("USER-AGENT"), (String)""));
    }

    public static MatomoRequestDetailsEnricher actionNameEnricher() {
        return (usageEvent, details) -> details.addParameter("action_name", StringUtils.defaultIfBlank((String)MatomoRequestDetailsEnricherFactory.actionName(usageEvent), (String)""));
    }

    public static MatomoRequestDetailsEnricher urlEnricher() {
        return (usageEvent, details) -> details.addParameter("url", MatomoRequestDetailsEnricherFactory.url(usageEvent.getObject()));
    }

    public static MatomoRequestDetailsEnricher downloadEnricher() {
        return (usageEvent, details) -> details.addParameter("download", Optional.ofNullable(usageEvent.getObject()).filter(dso -> dso.getType() == 0).map(MatomoRequestDetailsEnricherFactory::url).filter(StringUtils::isNotEmpty).map(url -> url + "/download").orElse(""));
    }

    public static MatomoRequestDetailsEnricher trackerIdentifierEnricher() {
        return new MatomoRequestTrackerIdentifierParamEnricher();
    }

    private static String url(DSpaceObject dso) {
        if (dso == null) {
            return "";
        }
        String baseUrl = MatomoRequestDetailsEnricherFactory.dspaceUrl();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return switch (dso.getType()) {
            case 0 -> baseUrl + "/bitstreams/" + dso.getID();
            case 2 -> baseUrl + "/items/" + dso.getID();
            default -> "";
        };
    }

    private static String dspaceUrl() {
        return DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.ui.url");
    }

    private static String actionName(UsageEvent ue) {
        if (ue == null || ue.getObject() == null) {
            return null;
        }
        try {
            if (ue.getObject().getType() == 0) {
                return ContentServiceFactory.getInstance().getDSpaceObjectService(ue.getObject()).getParentObject(ue.getContext(), ue.getObject()).getName();
            }
            return ue.getObject().getName();
        }
        catch (SQLException e) {
            log.error("Error in Matomo Analytics recording - can't determine ParentObjectName for bitstream {}", (Object)ue.getObject().getID(), (Object)e);
            return null;
        }
    }
}

