/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.qaevent.action;

import java.sql.SQLException;
import java.util.Map;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.qaevent.QualityAssuranceAction;
import org.dspace.qaevent.service.dto.QAMessageDTO;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AMetadataMapAction
implements QualityAssuranceAction {
    public static final String DEFAULT = "default";
    private Map<String, String> types;
    @Autowired
    private ItemService itemService;

    public void setItemService(ItemService itemService) {
        this.itemService = itemService;
    }

    public Map<String, String> getTypes() {
        return this.types;
    }

    public void setTypes(Map<String, String> types) {
        this.types = types;
    }

    public abstract String extractMetadataType(QAMessageDTO var1);

    public abstract String extractMetadataValue(QAMessageDTO var1);

    @Override
    public void applyCorrection(Context context, Item item, Item relatedItem, QAMessageDTO message) {
        try {
            String targetMetadata = this.types.get(this.extractMetadataType(message));
            if (targetMetadata == null) {
                targetMetadata = this.types.get(DEFAULT);
            }
            String[] metadata = this.splitMetadata(targetMetadata);
            this.itemService.addMetadata(context, item, metadata[0], metadata[1], metadata[2], null, this.extractMetadataValue(message));
            this.itemService.update(context, item);
        }
        catch (SQLException | AuthorizeException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] splitMetadata(String metadata) {
        String[] result = new String[3];
        String[] split = metadata.split("\\.");
        result[0] = split[0];
        result[1] = split[1];
        if (split.length == 3) {
            result[2] = split[2];
        }
        return result;
    }
}

