/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.qaevent.security;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Optional;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.QAEvent;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.qaevent.security.QASecurity;
import org.dspace.qaevent.service.QAEventService;
import org.springframework.beans.factory.annotation.Autowired;

public class UserBasedFilterQASecurity
implements QASecurity {
    private String filterTemplate;
    private boolean allowAdmins = true;
    @Autowired
    private QAEventService qaEventService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public Optional<String> generateFilterQuery(Context context, EPerson user) {
        try {
            if (this.allowAdmins && this.authorizeService.isAdmin(context, user)) {
                return Optional.empty();
            }
            return Optional.of(MessageFormat.format(this.filterTemplate, user.getID().toString()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error checking permissions", e);
        }
    }

    @Override
    public boolean canSeeQASource(Context context, EPerson user) {
        return user != null;
    }

    @Override
    public boolean canSeeQAEvent(Context context, EPerson user, QAEvent qaEvent) {
        try {
            return this.allowAdmins && this.authorizeService.isAdmin(context, user) || this.qaEventService.qaEventsInSource(context, user, qaEvent.getEventId(), qaEvent.getSource());
        }
        catch (SQLException e) {
            throw new RuntimeException("Error checking permissions", e);
        }
    }

    public void setFilterTemplate(String filterTemplate) {
        this.filterTemplate = filterTemplate;
    }

    public void setAllowAdmins(boolean allowAdmins) {
        this.allowAdmins = allowAdmins;
    }
}

