/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.qaevent.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.qaevent.QualityAssuranceAction;
import org.dspace.qaevent.service.QAEventActionService;
import org.dspace.qaevent.service.QAEventService;
import org.dspace.qaevent.service.dto.QAMessageDTO;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class QAEventActionServiceImpl
implements QAEventActionService {
    private static final Logger log = LogManager.getLogger(QAEventActionServiceImpl.class);
    private ObjectMapper jsonMapper = new JsonMapper();
    @Autowired
    private QAEventService qaEventService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private ConfigurationService configurationService;
    private Map<String, QualityAssuranceAction> topicsToActions;

    public void setTopicsToActions(Map<String, QualityAssuranceAction> topicsToActions) {
        this.topicsToActions = topicsToActions;
    }

    public Map<String, QualityAssuranceAction> getTopicsToActions() {
        return this.topicsToActions;
    }

    public QAEventActionServiceImpl() {
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public void accept(Context context, QAEvent qaevent) {
        Item item = null;
        Item related = null;
        try {
            item = (Item)this.itemService.find(context, UUID.fromString(qaevent.getTarget()));
            if (qaevent.getRelated() != null) {
                related = (Item)this.itemService.find(context, UUID.fromString(qaevent.getRelated()));
            }
            if (this.topicsToActions.get(qaevent.getTopic()) == null) {
                String msg = "Unable to manage QA Event typed " + qaevent.getTopic() + ". Managed types are: " + this.topicsToActions;
                log.error(msg);
                throw new RuntimeException(msg);
            }
            context.turnOffAuthorisationSystem();
            this.topicsToActions.get(qaevent.getTopic()).applyCorrection(context, item, related, (QAMessageDTO)this.jsonMapper.readValue(qaevent.getMessage(), qaevent.getMessageDtoClass()));
            this.qaEventService.deleteEventByEventId(qaevent.getEventId());
            this.makeAcknowledgement(qaevent.getEventId(), qaevent.getSource(), "accepted");
        }
        catch (JsonProcessingException | SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    @Override
    public void discard(Context context, QAEvent qaevent) {
        this.qaEventService.deleteEventByEventId(qaevent.getEventId());
        this.makeAcknowledgement(qaevent.getEventId(), qaevent.getSource(), "discarded");
    }

    @Override
    public void reject(Context context, QAEvent qaevent) {
        this.qaEventService.deleteEventByEventId(qaevent.getEventId());
        this.makeAcknowledgement(qaevent.getEventId(), qaevent.getSource(), "rejected");
    }

    private void makeAcknowledgement(String eventId, String source, String status) {
        String[] acknowledgeCallbacks = this.configurationService.getArrayProperty("qaevents." + source + ".acknowledge-url");
        if (acknowledgeCallbacks != null) {
            for (String acknowledgeCallback : acknowledgeCallbacks) {
                if (!StringUtils.isNotBlank((CharSequence)acknowledgeCallback)) continue;
                ObjectNode node = this.jsonMapper.createObjectNode();
                node.put("eventId", eventId);
                node.put("status", status);
                StringEntity requestEntity = new StringEntity(node.toString(), ContentType.APPLICATION_JSON);
                try (CloseableHttpClient httpClient = DSpaceHttpClientFactory.getInstance().buildWithoutProxy();){
                    HttpPost postMethod = new HttpPost(acknowledgeCallback);
                    postMethod.setEntity((HttpEntity)requestEntity);
                    httpClient.execute((HttpUriRequest)postMethod);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

