/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export.processor;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.CharEncoding;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.DCDate;
import org.dspace.content.Entity;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.EntityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.export.factory.OpenURLTrackerLoggerServiceFactory;
import org.dspace.statistics.export.service.OpenUrlService;

public abstract class ExportEventProcessor {
    protected static final String ENTITY_TYPE_DEFAULT = "Publication";
    protected static final String ITEM_VIEW = "Investigation";
    protected static final String BITSTREAM_DOWNLOAD = "Request";
    protected static final String UTF_8 = CharEncoding.UTF_8;
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private final EntityService entityService = ContentServiceFactory.getInstance().getEntityService();
    private final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final OpenUrlService openUrlService = OpenURLTrackerLoggerServiceFactory.getInstance().getOpenUrlService();
    private final Context context;
    private final HttpServletRequest request;

    ExportEventProcessor(Context context, HttpServletRequest request) {
        this.context = context;
        this.request = request;
    }

    public abstract void processEvent() throws SQLException, IOException;

    protected void processObject(String urlParameters) throws IOException, SQLException {
        String baseUrl = StringUtils.equals((CharSequence)this.configurationService.getProperty("irus.statistics.tracker.environment"), (CharSequence)"production") ? this.configurationService.getProperty("irus.statistics.tracker.produrl") : this.configurationService.getProperty("irus.statistics.tracker.testurl");
        this.openUrlService.processUrl(this.context, baseUrl + "?" + urlParameters);
    }

    protected String getBaseParameters(Item item) throws UnsupportedEncodingException {
        String clientIP = this.request.getRemoteAddr();
        if (this.configurationService.getBooleanProperty("useProxies", false) && this.request.getHeader("X-Forwarded-For") != null) {
            for (String xfip : this.request.getHeader("X-Forwarded-For").split(",")) {
                if (this.request.getHeader("X-Forwarded-For").contains(clientIP)) continue;
                clientIP = xfip.trim();
            }
        }
        String clientUA = (String)StringUtils.defaultIfBlank((CharSequence)this.request.getHeader("USER-AGENT"), (CharSequence)"");
        String referer = (String)StringUtils.defaultIfBlank((CharSequence)this.request.getHeader("referer"), (CharSequence)"");
        StringBuilder data = new StringBuilder();
        data.append(URLEncoder.encode("url_ver", UTF_8)).append("=").append(URLEncoder.encode(this.configurationService.getProperty("irus.statistics.tracker.urlversion"), UTF_8));
        data.append("&").append(URLEncoder.encode("req_id", UTF_8)).append("=").append(URLEncoder.encode(clientIP, UTF_8));
        data.append("&").append(URLEncoder.encode("req_dat", UTF_8)).append("=").append(URLEncoder.encode(clientUA, UTF_8));
        String hostName = Utils.getHostName(this.configurationService.getProperty("dspace.ui.url"));
        data.append("&").append(URLEncoder.encode("rft.artnum", UTF_8)).append("=").append(URLEncoder.encode("oai:" + hostName + ":" + item.getHandle(), UTF_8));
        data.append("&").append(URLEncoder.encode("rfr_dat", UTF_8)).append("=").append(URLEncoder.encode(referer, UTF_8));
        data.append("&").append(URLEncoder.encode("rfr_id", UTF_8)).append("=").append(URLEncoder.encode(hostName, UTF_8));
        data.append("&").append(URLEncoder.encode("url_tim", UTF_8)).append("=").append(URLEncoder.encode(this.getCurrentDateString(), UTF_8));
        return data.toString();
    }

    protected String getCurrentDateString() {
        return new DCDate(ZonedDateTime.now(ZoneOffset.UTC)).toString();
    }

    protected boolean shouldProcessItem(Item item) throws SQLException {
        if (item == null) {
            return false;
        }
        if (!item.isArchived()) {
            return false;
        }
        if (this.itemService.canEdit(this.context, item)) {
            return false;
        }
        if (!this.shouldProcessItemType(item)) {
            return false;
        }
        return this.shouldProcessEntityType(item);
    }

    protected boolean shouldProcessEntityType(Item item) throws SQLException {
        Entity entity = this.entityService.findByItemId(this.context, item.getID());
        EntityType type = this.entityService.getType(this.context, entity);
        if (type == null) {
            return true;
        }
        String[] entityTypeStrings = this.configurationService.getArrayProperty("irus.statistics.tracker.entity-types");
        ArrayList<String> entityTypes = new ArrayList<String>();
        if (entityTypeStrings.length != 0) {
            entityTypes.addAll(Arrays.asList(entityTypeStrings));
        } else {
            entityTypes.add(ENTITY_TYPE_DEFAULT);
        }
        return entityTypes.contains(type.getLabel());
    }

    protected boolean shouldProcessItemType(Item item) {
        ArrayList<String> trackerTypeMetadataValues;
        String trackerTypeMetadataField = this.configurationService.getProperty("irus.statistics.tracker.type-field");
        String[] metadataValues = this.configurationService.getArrayProperty("irus.statistics.tracker.type-value");
        if (metadataValues.length > 0) {
            trackerTypeMetadataValues = new ArrayList<String>();
            for (String metadataValue : metadataValues) {
                trackerTypeMetadataValues.add(metadataValue.toLowerCase());
            }
        } else {
            trackerTypeMetadataValues = null;
        }
        if (trackerTypeMetadataField != null && trackerTypeMetadataValues != null) {
            String[] metadataFieldSplit = trackerTypeMetadataField.split("\\.");
            List<MetadataValue> types = this.itemService.getMetadata(item, metadataFieldSplit[0], metadataFieldSplit[1], metadataFieldSplit.length == 2 ? null : metadataFieldSplit[2], "*");
            if (!types.isEmpty()) {
                for (MetadataValue type : types) {
                    if (!trackerTypeMetadataValues.contains(type.getValue().toLowerCase())) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return true;
    }
}

