/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.vocabulary;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ControlledVocabulary {
    private String id;
    private String label;
    private String value;
    private List<ControlledVocabulary> childNodes;

    public ControlledVocabulary(String id, String label, String value, List<ControlledVocabulary> childNodes) {
        this.id = id;
        this.label = label;
        this.value = value;
        this.childNodes = childNodes;
    }

    public static ControlledVocabulary loadVocabulary(String fileName) throws IOException, SAXException, ParserConfigurationException, XPathExpressionException {
        StringBuilder filePath = new StringBuilder();
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        filePath.append(configurationService.getProperty("dspace.dir")).append(File.separatorChar).append("config").append(File.separatorChar).append("controlled-vocabularies").append(File.separator).append(fileName).append(".xml");
        File controlledVocFile = new File(filePath.toString());
        if (controlledVocFile.exists()) {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(controlledVocFile);
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node node = (Node)xPath.compile("node").evaluate(document, XPathConstants.NODE);
            return ControlledVocabulary.loadVocabularyNode(node, "");
        }
        return null;
    }

    private static ControlledVocabulary loadVocabularyNode(Node node, String initialValue) throws XPathExpressionException {
        Node idNode = node.getAttributes().getNamedItem("id");
        String id = null;
        if (idNode != null) {
            id = idNode.getNodeValue();
        }
        Node labelNode = node.getAttributes().getNamedItem("label");
        String label = null;
        if (labelNode != null) {
            label = labelNode.getNodeValue();
        }
        Object value = 0 < initialValue.length() ? initialValue + "::" + label : label;
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList subNodes = (NodeList)xPath.compile("isComposedBy/node").evaluate(node, XPathConstants.NODESET);
        ArrayList<ControlledVocabulary> subVocabularies = new ArrayList<ControlledVocabulary>(subNodes.getLength());
        for (int i = 0; i < subNodes.getLength(); ++i) {
            subVocabularies.add(ControlledVocabulary.loadVocabularyNode(subNodes.item(i), (String)value));
        }
        return new ControlledVocabulary(id, label, (String)value, subVocabularies);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<ControlledVocabulary> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(List<ControlledVocabulary> childNodes) {
        this.childNodes = childNodes;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

