/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.workflow.WorkflowException;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionAdvancedInfo;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public abstract class Action {
    private WorkflowActionConfig parent;
    private static final String ERROR_FIELDS_ATTRIBUTE = "dspace.workflow.error_fields";
    private List<String> advancedOptions = new ArrayList<String>();
    private List<ActionAdvancedInfo> advancedInfo = new ArrayList<ActionAdvancedInfo>();

    public abstract void activate(Context var1, XmlWorkflowItem var2) throws SQLException, IOException, AuthorizeException, WorkflowException;

    public abstract ActionResult execute(Context var1, XmlWorkflowItem var2, Step var3, HttpServletRequest var4) throws SQLException, AuthorizeException, IOException, WorkflowException;

    public abstract List<String> getOptions();

    protected boolean isOptionInParam(HttpServletRequest request) {
        for (String option : this.getOptions()) {
            if (request.getParameter(option) == null) continue;
            return true;
        }
        return false;
    }

    public WorkflowActionConfig getParent() {
        return this.parent;
    }

    public void setParent(WorkflowActionConfig parent) {
        this.parent = parent;
    }

    public String getProvenanceStartId() {
        return "Step: " + this.getParent().getStep().getId() + " - action:" + this.getParent().getId();
    }

    public void alertUsersOnActivation(Context c, XmlWorkflowItem wfi, RoleMembers members) throws SQLException, IOException {
    }

    public abstract boolean isAuthorized(Context var1, HttpServletRequest var2, XmlWorkflowItem var3) throws SQLException, AuthorizeException, IOException, WorkflowConfigurationException;

    private void setErrorFields(HttpServletRequest request, List errorFields) {
        if (errorFields == null) {
            request.removeAttribute(ERROR_FIELDS_ATTRIBUTE);
        } else {
            request.setAttribute(ERROR_FIELDS_ATTRIBUTE, (Object)errorFields);
        }
    }

    public static List getErrorFields(HttpServletRequest request) {
        List result = new ArrayList();
        if (request.getAttribute(ERROR_FIELDS_ATTRIBUTE) != null) {
            result = (List)request.getAttribute(ERROR_FIELDS_ATTRIBUTE);
        }
        return result;
    }

    protected void addErrorField(HttpServletRequest request, String fieldName) {
        ArrayList<String> errorFields = Action.getErrorFields(request);
        if (errorFields == null) {
            errorFields = new ArrayList<String>();
        }
        errorFields.add(fieldName);
        this.setErrorFields(request, errorFields);
    }

    protected List<String> getAdvancedOptions() {
        return this.advancedOptions;
    }

    protected boolean isAdvanced() {
        return !this.getAdvancedOptions().isEmpty();
    }

    protected List<ActionAdvancedInfo> getAdvancedInfo() {
        return this.advancedInfo;
    }

    public void addApprovedProvenance(Context c, XmlWorkflowItem wfi) throws SQLException, AuthorizeException {
        ItemService itemService = ContentServiceFactory.getInstance().getItemService();
        String now = DCDate.getCurrent().toString();
        String usersName = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().getEPersonName(c.getCurrentUser());
        String provDescription = this.getProvenanceStartId() + " Approved for entry into archive by " + usersName + " on " + now + " (GMT) ";
        c.turnOffAuthorisationSystem();
        itemService.addMetadata(c, wfi.getItem(), MetadataSchemaEnum.DC.getName(), "description", "provenance", "en", provDescription);
        itemService.update(c, wfi.getItem());
        c.restoreAuthSystemState();
    }
}

