/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.access.status;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.LocalDate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.access.status.factory.AccessStatusServiceFactory;
import org.dspace.access.status.service.AccessStatusService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.AccessStatus;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AccessStatusServiceTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(AccessStatusServiceTest.class);
    private Collection collection;
    private Community owningCommunity;
    private Item item;
    private Bundle bundle;
    private Bitstream bitstream;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected AccessStatusService accessStatusService = AccessStatusServiceFactory.getInstance().getAccessStatusService();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            this.item = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.bundle = this.bundleService.create(this.context, this.item, "ORIGINAL");
            this.bitstream = this.bitstreamService.create(this.context, this.bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
            this.bitstream.setName(this.context, "primary");
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (IOException ex) {
            log.error("IO Error in init", (Throwable)ex);
            Assert.fail((String)("IO Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            this.bitstreamService.delete(this.context, (DSpaceObject)this.bitstream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bundleService.delete(this.context, (DSpaceObject)this.bundle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.itemService.delete(this.context, (DSpaceObject)this.item);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.collectionService.delete(this.context, (DSpaceObject)this.collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.restoreAuthSystemState();
        this.bitstream = null;
        this.bundle = null;
        this.item = null;
        this.collection = null;
        this.owningCommunity = null;
        try {
            super.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetAccessStatusItem() throws Exception {
        AccessStatus accessStatus = this.accessStatusService.getAccessStatus(this.context, this.item);
        String status = accessStatus.getStatus();
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNotEquals((String)"testGetAccessStatusItem 0", (Object)status, (Object)"unknown");
        Assert.assertNull((String)"testGetAccessStatusItem 1", (Object)availabilityDate);
    }

    @Test
    public void testGetAnonymousAccessStatusItem() throws Exception {
        AccessStatus accessStatus = this.accessStatusService.getAnonymousAccessStatus(this.context, this.item);
        String status = accessStatus.getStatus();
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNotEquals((String)"testGetAnonymousAccessStatusItem 0", (Object)status, (Object)"unknown");
        Assert.assertNull((String)"testGetAnonymousAccessStatusItem 1", (Object)availabilityDate);
    }

    @Test
    public void testGetAccessStatusBitstream() throws Exception {
        AccessStatus accessStatus = this.accessStatusService.getAccessStatus(this.context, this.bitstream);
        String status = accessStatus.getStatus();
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNotEquals((String)"testGetAccessStatusBitstream 0", (Object)status, (Object)"unknown");
        Assert.assertNull((String)"testGetAccessStatusBitstream 1", (Object)availabilityDate);
    }
}

