/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.access.status;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.access.status.DefaultAccessStatusHelper;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.AccessStatus;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAccessStatusHelperTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(DefaultAccessStatusHelperTest.class);
    private Collection collection;
    private Community owningCommunity;
    private Item itemWithoutBundle;
    private Item itemWithoutBitstream;
    private Item itemWithBitstream;
    private Item itemWithEmbargo;
    private Item itemWithDateRestriction;
    private Item itemWithGroupRestriction;
    private Item itemWithoutPolicy;
    private Item itemWithoutPrimaryBitstream;
    private Item itemWithPrimaryAndMultipleBitstreams;
    private Item itemWithoutPrimaryAndMultipleBitstreams;
    private DefaultAccessStatusHelper helper;
    private LocalDate threshold;
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected ResourcePolicyService resourcePolicyService = AuthorizeServiceFactory.getInstance().getResourcePolicyService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.owningCommunity = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.owningCommunity);
            this.itemWithoutBundle = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithoutBitstream = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithBitstream = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithEmbargo = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithDateRestriction = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithGroupRestriction = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithoutPolicy = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithoutPrimaryBitstream = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithPrimaryAndMultipleBitstreams = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.itemWithoutPrimaryAndMultipleBitstreams = this.installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItemService.create(this.context, this.collection, true));
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        this.helper = new DefaultAccessStatusHelper();
        this.threshold = LocalDate.of(10000, 1, 1);
    }

    @Override
    @After
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutBundle);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutBitstream);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithBitstream);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithEmbargo);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithDateRestriction);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithGroupRestriction);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutPolicy);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutPrimaryBitstream);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithPrimaryAndMultipleBitstreams);
            this.itemService.delete(this.context, (DSpaceObject)this.itemWithoutPrimaryAndMultipleBitstreams);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.collectionService.delete(this.context, (DSpaceObject)this.collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.communityService.delete(this.context, (DSpaceObject)this.owningCommunity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.restoreAuthSystemState();
        this.itemWithoutBundle = null;
        this.itemWithoutBitstream = null;
        this.itemWithBitstream = null;
        this.itemWithEmbargo = null;
        this.itemWithDateRestriction = null;
        this.itemWithGroupRestriction = null;
        this.itemWithoutPolicy = null;
        this.itemWithoutPrimaryBitstream = null;
        this.itemWithPrimaryAndMultipleBitstreams = null;
        this.itemWithoutPrimaryAndMultipleBitstreams = null;
        this.collection = null;
        this.owningCommunity = null;
        this.helper = null;
        this.threshold = null;
        this.communityService = null;
        this.collectionService = null;
        this.itemService = null;
        this.workspaceItemService = null;
        this.installItemService = null;
        this.bundleService = null;
        this.bitstreamService = null;
        this.resourcePolicyService = null;
        this.groupService = null;
        try {
            super.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testWithNullItem() throws Exception {
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, null, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithNullItem 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"unknown"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNull((String)"testWithNullItem 1", (Object)availabilityDate);
    }

    @Test
    public void testWithoutBundle() throws Exception {
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutBundle, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithoutBundle 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"metadata.only"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNull((String)"testWithoutBundle 1", (Object)availabilityDate);
    }

    @Test
    public void testWithoutBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.bundleService.create(this.context, this.itemWithoutBitstream, "ORIGINAL");
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutBitstream, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithoutBitstream 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"metadata.only"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNull((String)"testWithoutBitstream 1", (Object)availabilityDate);
        AccessStatus accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, null, this.threshold, "current");
        String bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithoutBitstream 3", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"unknown"));
        LocalDate bitstreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        Assert.assertNull((String)"testWithoutBitstream 4", (Object)bitstreamAvailabilityDate);
    }

    @Test
    public void testWithBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithBitstream, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithBitstream, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithBitstream 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNull((String)"testWithBitstream 1", (Object)availabilityDate);
        AccessStatus accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "current");
        String bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithBitstream 3", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        LocalDate bitstreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        Assert.assertNull((String)"testWithBitstream 4", (Object)bitstreamAvailabilityDate);
    }

    @Test
    public void testWithEmbargo() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithEmbargo, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        Group group = this.groupService.findByName(this.context, "Anonymous");
        ResourcePolicy policy = this.resourcePolicyService.create(this.context, null, group);
        policy.setRpName("Embargo");
        policy.setAction(0);
        LocalDate startDate = LocalDate.of(9999, 12, 31);
        policy.setStartDate(startDate);
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithEmbargo, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargo 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithEmbargo 1", (Object)availabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
        AccessStatus accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "current");
        String bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargo 3", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        LocalDate bitstreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithEmbargo 4", (Object)bitstreamAvailabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
    }

    @Test
    public void testWithDateRestriction() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithDateRestriction, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        Group group = this.groupService.findByName(this.context, "Anonymous");
        ResourcePolicy policy = this.resourcePolicyService.create(this.context, null, group);
        policy.setRpName("Restriction");
        policy.setAction(0);
        LocalDate startDate = LocalDate.of(10000, 1, 1);
        policy.setStartDate(startDate);
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithDateRestriction, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithDateRestriction 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"restricted"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithDateRestriction 1", (Object)availabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
        AccessStatus accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "current");
        String bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithDateRestriction 3", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"restricted"));
        LocalDate bistreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithDateRestriction 4", (Object)bistreamAvailabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
    }

    @Test
    public void testWithGroupRestriction() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithGroupRestriction, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        Group group = this.groupService.findByName(this.context, "Administrator");
        ResourcePolicy policy = this.resourcePolicyService.create(this.context, null, group);
        policy.setRpName("Restriction");
        policy.setAction(0);
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithGroupRestriction, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithGroupRestriction 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"restricted"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithGroupRestriction 1", (Object)availabilityDate, (Matcher)CoreMatchers.equalTo((Object)this.threshold));
        AccessStatus accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "current");
        String bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithGroupRestriction 3", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"restricted"));
        LocalDate bitstreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithGroupRestriction 4", (Object)bitstreamAvailabilityDate, (Matcher)CoreMatchers.equalTo((Object)this.threshold));
    }

    @Test
    public void testWithoutPolicy() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithoutPolicy, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutPolicy, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithoutPolicy 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"restricted"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithoutPolicy 1", (Object)availabilityDate, (Matcher)CoreMatchers.equalTo((Object)this.threshold));
        AccessStatus accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "current");
        String bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithoutPolicy 3", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"restricted"));
        LocalDate bitstreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithoutPolicy 4", (Object)bitstreamAvailabilityDate, (Matcher)CoreMatchers.equalTo((Object)this.threshold));
    }

    @Test
    public void testWithoutPrimaryBitstream() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithoutPrimaryBitstream, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "first");
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutPrimaryBitstream, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithoutPrimaryBitstream 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNull((String)"testWithoutPrimaryBitstream 1", (Object)availabilityDate);
        AccessStatus accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "current");
        String bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithoutPrimaryBitstream 3", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        LocalDate bitstreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        Assert.assertNull((String)"testWithoutPrimaryBitstream 4", (Object)bitstreamAvailabilityDate);
    }

    @Test
    public void testWithPrimaryAndMultipleBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithPrimaryAndMultipleBitstreams, "ORIGINAL");
        Bitstream otherBitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        Bitstream primaryBitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bundle.setPrimaryBitstreamID(primaryBitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        Group group = this.groupService.findByName(this.context, "Anonymous");
        ResourcePolicy policy = this.resourcePolicyService.create(this.context, null, group);
        policy.setRpName("Embargo");
        policy.setAction(0);
        LocalDate startDate = LocalDate.of(9999, 12, 31);
        policy.setStartDate(startDate);
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)primaryBitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)primaryBitstream);
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithPrimaryAndMultipleBitstreams, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithPrimaryAndMultipleBitstreams 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithPrimaryAndMultipleBitstreams 1", (Object)availabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
        AccessStatus accessStatusPrimaryBitstream = this.helper.getAccessStatusFromBitstream(this.context, primaryBitstream, this.threshold, "current");
        String primaryBitstreamStatus = accessStatusPrimaryBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithPrimaryAndMultipleBitstreams 3", (Object)primaryBitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        LocalDate primaryAvailabilityDate = accessStatusPrimaryBitstream.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithPrimaryAndMultipleBitstreams 4", (Object)primaryAvailabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
        AccessStatus accessStatusOtherBitstream = this.helper.getAccessStatusFromBitstream(this.context, otherBitstream, this.threshold, "current");
        String otherBitstreamStatus = accessStatusOtherBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithPrimaryAndMultipleBitstreams 5", (Object)otherBitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        LocalDate otherAvailabilityDate = accessStatusOtherBitstream.getAvailabilityDate();
        Assert.assertNull((String)"testWithPrimaryAndMultipleBitstreams 6", (Object)otherAvailabilityDate);
    }

    @Test
    public void testWithNoPrimaryAndMultipleBitstreams() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithoutPrimaryAndMultipleBitstreams, "ORIGINAL");
        Bitstream firstBitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        Bitstream anotherBitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        Group group = this.groupService.findByName(this.context, "Anonymous");
        ResourcePolicy policy = this.resourcePolicyService.create(this.context, null, group);
        policy.setRpName("Embargo");
        policy.setAction(0);
        LocalDate startDate = LocalDate.of(9999, 12, 31);
        policy.setStartDate(startDate);
        policies.add(policy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)anotherBitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)anotherBitstream);
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithoutPrimaryAndMultipleBitstreams, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithNoPrimaryAndMultipleBitstreams 0", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNull((String)"testWithNoPrimaryAndMultipleBitstreams 1", (Object)availabilityDate);
        AccessStatus accessStatusFirstBitstream = this.helper.getAccessStatusFromBitstream(this.context, firstBitstream, this.threshold, "current");
        String firstBitstreamStatus = accessStatusFirstBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithNoPrimaryAndMultipleBitstreams 3", (Object)firstBitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        LocalDate firstAvailabilityDate = accessStatusFirstBitstream.getAvailabilityDate();
        Assert.assertNull((String)"testWithNoPrimaryAndMultipleBitstreams 4", (Object)firstAvailabilityDate);
        AccessStatus accessStatusOtherBitstream = this.helper.getAccessStatusFromBitstream(this.context, anotherBitstream, this.threshold, "current");
        String otherBitstreamStatus = accessStatusOtherBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithNoPrimaryAndMultipleBitstreams 5", (Object)otherBitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        LocalDate otherAvailabilityDate = accessStatusOtherBitstream.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithNoPrimaryAndMultipleBitstreams 6", (Object)otherAvailabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
    }

    @Test
    public void testWithEmbargoForCurrentOrAnonymousAsGuest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithEmbargo, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        Group group = this.groupService.findByName(this.context, "Anonymous");
        ResourcePolicy policy = this.resourcePolicyService.create(this.context, null, group);
        policy.setRpName("Embargo");
        policy.setAction(0);
        LocalDate startDate = LocalDate.of(9999, 12, 31);
        policy.setStartDate(startDate);
        policies.add(policy);
        EPerson admin = this.ePersonService.create(this.context);
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        ResourcePolicy adminPolicy = this.resourcePolicyService.create(this.context, admin, adminGroup);
        adminPolicy.setRpName("Open Access For Admin");
        adminPolicy.setAction(0);
        policies.add(adminPolicy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithEmbargo, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsGuest 1", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsGuest 2", (Object)availabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
        AccessStatus accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "current");
        String bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsGuest 3", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        LocalDate bistreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsGuest 4", (Object)bistreamAvailabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
        accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithEmbargo, this.threshold, "anonymous");
        status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsGuest 5", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        availabilityDate = accessStatus.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsGuest 6", (Object)availabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
        accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "anonymous");
        bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsGuest 7", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        bistreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsGuest 8", (Object)bistreamAvailabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
    }

    @Test
    public void testWithEmbargoForCurrentOrAnonymousAsAdmin() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Bundle bundle = this.bundleService.create(this.context, this.itemWithEmbargo, "ORIGINAL");
        Bitstream bitstream = this.bitstreamService.create(this.context, bundle, (InputStream)new ByteArrayInputStream("1".getBytes(StandardCharsets.UTF_8)));
        bitstream.setName(this.context, "primary");
        bundle.setPrimaryBitstreamID(bitstream);
        ArrayList<ResourcePolicy> policies = new ArrayList<ResourcePolicy>();
        Group group = this.groupService.findByName(this.context, "Anonymous");
        ResourcePolicy policy = this.resourcePolicyService.create(this.context, null, group);
        policy.setRpName("Embargo");
        policy.setAction(0);
        LocalDate startDate = LocalDate.of(9999, 12, 31);
        policy.setStartDate(startDate);
        policies.add(policy);
        EPerson admin = this.ePersonService.create(this.context);
        Group adminGroup = this.groupService.findByName(this.context, "Administrator");
        ResourcePolicy adminPolicy = this.resourcePolicyService.create(this.context, admin, adminGroup);
        adminPolicy.setRpName("Open Access For Admin");
        adminPolicy.setAction(0);
        policies.add(adminPolicy);
        this.authorizeService.removeAllPolicies(this.context, (DSpaceObject)bitstream);
        this.authorizeService.addPolicies(this.context, policies, (DSpaceObject)bitstream);
        this.context.restoreAuthSystemState();
        EPerson currentUser = this.context.getCurrentUser();
        this.context.setCurrentUser(admin);
        AccessStatus accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithEmbargo, this.threshold, "current");
        String status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsAdmin 1", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        LocalDate availabilityDate = accessStatus.getAvailabilityDate();
        Assert.assertNull((String)"testWithEmbargoForCurrentOrAnonymousAsAdmin 2", (Object)availabilityDate);
        AccessStatus accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "current");
        String bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsAdmin 3", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"open.access"));
        LocalDate bitstreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        Assert.assertNull((String)"testWithEmbargoForCurrentOrAnonymousAsAdmin 4", (Object)bitstreamAvailabilityDate);
        accessStatus = this.helper.getAccessStatusFromItem(this.context, this.itemWithEmbargo, this.threshold, "anonymous");
        status = accessStatus.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsAdmin 5", (Object)status, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        availabilityDate = accessStatus.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsAdmin 6", (Object)availabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
        accessStatusBitstream = this.helper.getAccessStatusFromBitstream(this.context, bitstream, this.threshold, "anonymous");
        bitstreamStatus = accessStatusBitstream.getStatus();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsAdmin 7", (Object)bitstreamStatus, (Matcher)CoreMatchers.equalTo((Object)"embargo"));
        bitstreamAvailabilityDate = accessStatusBitstream.getAvailabilityDate();
        MatcherAssert.assertThat((String)"testWithEmbargoForCurrentOrAnonymousAsAdmin 8", (Object)bitstreamAvailabilityDate, (Matcher)CoreMatchers.equalTo((Object)startDate));
        this.context.setCurrentUser(currentUser);
    }
}

