/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.factory.NotifyServiceFactory;
import org.dspace.app.ldn.model.Notification;
import org.dspace.app.ldn.service.LDNMessageService;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.NotifyServiceBuilder;
import org.dspace.builder.NotifyServiceInboundPatternBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.eperson.EPerson;
import org.dspace.matcher.NotifyServiceEntityMatcher;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LDNMessageConsumerIT
extends AbstractIntegrationTestWithDatabase {
    private org.dspace.content.Collection collection;
    private EPerson submitter;
    private LDNMessageService ldnMessageService = NotifyServiceFactory.getInstance().getLDNMessageService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.submitter = EPersonBuilder.createEPerson(this.context).withEmail("submitter@example.com").withPassword(this.password).build();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection 1").withSubmitterGroup(this.submitter).build();
        this.context.setCurrentUser(this.submitter);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testLDNMessageConsumerRequestReview() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder(this.context, "service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, this.collection).withTitle("Submission Item").withIssueDate("2023-11-20").withCOARNotifyService(notifyService, "request-review").withFulltext("test.txt", "test", InputStream.nullInputStream()).grantLicense().build();
        WorkflowItem workflowItem = this.workflowService.start(this.context, workspaceItem);
        Item item = workflowItem.getItem();
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        LDNMessageEntity ldnMessage = this.ldnMessageService.findAll(this.context).stream().findFirst().orElse(null);
        Assert.assertThat((Object)notifyService, (Matcher)NotifyServiceEntityMatcher.matchesNotifyServiceEntity(ldnMessage.getTarget()));
        Assert.assertEquals((Object)workflowItem.getItem().getID(), (Object)ldnMessage.getObject().getID());
        Assert.assertEquals((Object)LDNMessageEntity.QUEUE_STATUS_QUEUED, (Object)ldnMessage.getQueueStatus());
        Assert.assertNull((Object)ldnMessage.getOrigin());
        Assert.assertNotNull((Object)ldnMessage.getMessage());
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(ldnMessage.getMessage(), Notification.class);
        Assert.assertThat((Object)notification.getId(), (Matcher)CoreMatchers.containsString((String)"urn:uuid:"));
        Assert.assertEquals((Object)notification.getObject().getId(), (Object)(this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle()));
        Assert.assertEquals((Object)notification.getObject().getIetfCiteAs(), (Object)((MetadataValue)this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.identifier.uri").get(0)).getValue());
        Assert.assertEquals((Object)notification.getObject().getUrl().getId(), (Object)(this.configurationService.getProperty("dspace.ui.url") + "/bitstreams/" + ((Bitstream)((Bundle)item.getBundles("ORIGINAL").get(0)).getBitstreams().get(0)).getID() + "/download"));
        Assert.assertEquals((Object)notification.getTarget().getId(), (Object)notifyService.getUrl());
        Assert.assertEquals((Object)notification.getTarget().getInbox(), (Object)notifyService.getLdnUrl());
        Assert.assertEquals((Object)notification.getTarget().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getOrigin().getId(), (Object)this.configurationService.getProperty("dspace.ui.url"));
        Assert.assertEquals((Object)notification.getOrigin().getInbox(), (Object)this.configurationService.getProperty("ldn.notify.inbox"));
        Assert.assertEquals((Object)notification.getOrigin().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getActor().getId(), (Object)this.configurationService.getProperty("dspace.ui.url"));
        Assert.assertEquals((Object)notification.getActor().getName(), (Object)this.configurationService.getProperty("dspace.name"));
        Assert.assertEquals((Object)notification.getOrigin().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getType(), Set.of("coar-notify:ReviewAction", "Offer"));
    }

    @Test
    public void testLDNMessageConsumerRequestReviewAutomatic() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder(this.context, "service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        NotifyServiceInboundPatternBuilder.createNotifyServiceInboundPatternBuilder(this.context, notifyService).withPattern("request-review").withConstraint("simple-demo_filter").isAutomatic(true).build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, this.collection).withTitle("demo Item").withIssueDate("2023-11-20").withFulltext("test.txt", "test", InputStream.nullInputStream()).grantLicense().build();
        WorkflowItem workflowItem = this.workflowService.start(this.context, workspaceItem);
        Item item = workflowItem.getItem();
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        LDNMessageEntity ldnMessage = this.ldnMessageService.findAll(this.context).stream().findFirst().orElse(null);
        Assert.assertThat((Object)notifyService, (Matcher)NotifyServiceEntityMatcher.matchesNotifyServiceEntity(ldnMessage.getTarget()));
        Assert.assertEquals((Object)workflowItem.getItem().getID(), (Object)ldnMessage.getObject().getID());
        Assert.assertEquals((Object)LDNMessageEntity.QUEUE_STATUS_QUEUED, (Object)ldnMessage.getQueueStatus());
        Assert.assertNull((Object)ldnMessage.getOrigin());
        Assert.assertNotNull((Object)ldnMessage.getMessage());
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(ldnMessage.getMessage(), Notification.class);
        Assert.assertThat((Object)notification.getId(), (Matcher)CoreMatchers.containsString((String)"urn:uuid:"));
        Assert.assertEquals((Object)notification.getObject().getId(), (Object)(this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle()));
        Assert.assertEquals((Object)notification.getObject().getIetfCiteAs(), (Object)((MetadataValue)this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.identifier.uri").get(0)).getValue());
        Assert.assertEquals((Object)notification.getObject().getUrl().getId(), (Object)(this.configurationService.getProperty("dspace.ui.url") + "/bitstreams/" + ((Bitstream)((Bundle)item.getBundles("ORIGINAL").get(0)).getBitstreams().get(0)).getID() + "/download"));
        Assert.assertEquals((Object)notification.getTarget().getId(), (Object)notifyService.getUrl());
        Assert.assertEquals((Object)notification.getTarget().getInbox(), (Object)notifyService.getLdnUrl());
        Assert.assertEquals((Object)notification.getTarget().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getOrigin().getId(), (Object)this.configurationService.getProperty("dspace.ui.url"));
        Assert.assertEquals((Object)notification.getOrigin().getInbox(), (Object)this.configurationService.getProperty("ldn.notify.inbox"));
        Assert.assertEquals((Object)notification.getOrigin().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getActor().getId(), (Object)this.configurationService.getProperty("dspace.ui.url"));
        Assert.assertEquals((Object)notification.getActor().getName(), (Object)this.configurationService.getProperty("dspace.name"));
        Assert.assertEquals((Object)notification.getOrigin().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getType(), Set.of("coar-notify:ReviewAction", "Offer"));
    }

    @Test
    public void testLDNMessageConsumerRequestEndorsement() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder(this.context, "service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, this.collection).withTitle("Submission Item").withIssueDate("2023-11-20").withCOARNotifyService(notifyService, "request-endorsement").withFulltext("test.txt", "test", InputStream.nullInputStream()).grantLicense().build();
        WorkflowItem workflowItem = this.workflowService.start(this.context, workspaceItem);
        Item item = workflowItem.getItem();
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        LDNMessageEntity ldnMessage = this.ldnMessageService.findAll(this.context).stream().findFirst().orElse(null);
        Assert.assertThat((Object)notifyService, (Matcher)NotifyServiceEntityMatcher.matchesNotifyServiceEntity(ldnMessage.getTarget()));
        Assert.assertEquals((Object)workflowItem.getItem().getID(), (Object)ldnMessage.getObject().getID());
        Assert.assertEquals((Object)LDNMessageEntity.QUEUE_STATUS_QUEUED, (Object)ldnMessage.getQueueStatus());
        Assert.assertNull((Object)ldnMessage.getOrigin());
        Assert.assertNotNull((Object)ldnMessage.getMessage());
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(ldnMessage.getMessage(), Notification.class);
        Assert.assertThat((Object)notification.getId(), (Matcher)CoreMatchers.containsString((String)"urn:uuid:"));
        Assert.assertEquals((Object)notification.getObject().getId(), (Object)(this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle()));
        Assert.assertEquals((Object)notification.getObject().getIetfCiteAs(), (Object)((MetadataValue)this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.identifier.uri").get(0)).getValue());
        Assert.assertEquals((Object)notification.getObject().getUrl().getId(), (Object)(this.configurationService.getProperty("dspace.ui.url") + "/bitstreams/" + ((Bitstream)((Bundle)item.getBundles("ORIGINAL").get(0)).getBitstreams().get(0)).getID() + "/download"));
        Assert.assertEquals((Object)notification.getTarget().getId(), (Object)notifyService.getUrl());
        Assert.assertEquals((Object)notification.getTarget().getInbox(), (Object)notifyService.getLdnUrl());
        Assert.assertEquals((Object)notification.getTarget().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getOrigin().getId(), (Object)this.configurationService.getProperty("dspace.ui.url"));
        Assert.assertEquals((Object)notification.getOrigin().getInbox(), (Object)this.configurationService.getProperty("ldn.notify.inbox"));
        Assert.assertEquals((Object)notification.getOrigin().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getActor().getId(), (Object)this.configurationService.getProperty("dspace.ui.url"));
        Assert.assertEquals((Object)notification.getActor().getName(), (Object)this.configurationService.getProperty("dspace.name"));
        Assert.assertEquals((Object)notification.getOrigin().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getType(), Set.of("coar-notify:EndorsementAction", "Offer"));
    }

    @Test
    public void testLDNMessageConsumerRequestIngest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder(this.context, "service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, this.collection).withTitle("Submission Item").withIssueDate("2023-11-20").withCOARNotifyService(notifyService, "request-ingest").withFulltext("test.txt", "test", InputStream.nullInputStream()).grantLicense().build();
        WorkflowItem workflowItem = this.workflowService.start(this.context, workspaceItem);
        Item item = workflowItem.getItem();
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        LDNMessageEntity ldnMessage = this.ldnMessageService.findAll(this.context).stream().findFirst().orElse(null);
        Assert.assertThat((Object)notifyService, (Matcher)NotifyServiceEntityMatcher.matchesNotifyServiceEntity(ldnMessage.getTarget()));
        Assert.assertEquals((Object)workflowItem.getItem().getID(), (Object)ldnMessage.getObject().getID());
        Assert.assertEquals((Object)LDNMessageEntity.QUEUE_STATUS_QUEUED, (Object)ldnMessage.getQueueStatus());
        Assert.assertNull((Object)ldnMessage.getOrigin());
        Assert.assertNotNull((Object)ldnMessage.getMessage());
        ObjectMapper mapper = new ObjectMapper();
        Notification notification = (Notification)mapper.readValue(ldnMessage.getMessage(), Notification.class);
        Assert.assertThat((Object)notification.getId(), (Matcher)CoreMatchers.containsString((String)"urn:uuid:"));
        Assert.assertEquals((Object)notification.getObject().getId(), (Object)(this.configurationService.getProperty("dspace.ui.url") + "/handle/" + item.getHandle()));
        Assert.assertEquals((Object)notification.getObject().getIetfCiteAs(), (Object)((MetadataValue)this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dc.identifier.uri").get(0)).getValue());
        Assert.assertEquals((Object)notification.getObject().getUrl().getId(), (Object)(this.configurationService.getProperty("dspace.ui.url") + "/bitstreams/" + ((Bitstream)((Bundle)item.getBundles("ORIGINAL").get(0)).getBitstreams().get(0)).getID() + "/download"));
        Assert.assertEquals((Object)notification.getTarget().getId(), (Object)notifyService.getUrl());
        Assert.assertEquals((Object)notification.getTarget().getInbox(), (Object)notifyService.getLdnUrl());
        Assert.assertEquals((Object)notification.getTarget().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getOrigin().getId(), (Object)this.configurationService.getProperty("dspace.ui.url"));
        Assert.assertEquals((Object)notification.getOrigin().getInbox(), (Object)this.configurationService.getProperty("ldn.notify.inbox"));
        Assert.assertEquals((Object)notification.getOrigin().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getActor().getId(), (Object)this.configurationService.getProperty("dspace.ui.url"));
        Assert.assertEquals((Object)notification.getActor().getName(), (Object)this.configurationService.getProperty("dspace.name"));
        Assert.assertEquals((Object)notification.getOrigin().getType(), Set.of("Service"));
        Assert.assertEquals((Object)notification.getType(), Set.of("coar-notify:IngestAction", "Offer"));
    }

    @Test
    public void testLDNMessageConsumerRequestFake() throws Exception {
        this.context.turnOffAuthorisationSystem();
        NotifyServiceEntity notifyService = NotifyServiceBuilder.createNotifyServiceBuilder(this.context, "service name").withDescription("service description").withUrl("https://service.ldn.org/about").withLdnUrl("https://service.ldn.org/inbox").build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, this.collection).withTitle("Submission Item").withIssueDate("2023-11-20").withCOARNotifyService(notifyService, "request-fake").withFulltext("test.txt", "test", InputStream.nullInputStream()).grantLicense().build();
        this.workflowService.start(this.context, workspaceItem);
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        LDNMessageEntity ldnMessage = this.ldnMessageService.findAll(this.context).stream().findFirst().orElse(null);
        Assert.assertNull((Object)ldnMessage);
    }

    @Test
    public void testLDNMessageConsumerNoRequests() throws Exception {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, this.collection).withTitle("Submission Item").withIssueDate("2023-11-20").grantLicense().build();
        this.workflowService.start(this.context, workspaceItem);
        this.context.dispatchEvents();
        this.context.restoreAuthSystemState();
        LDNMessageEntity ldnMessage = this.ldnMessageService.findAll(this.context).stream().findFirst().orElse(null);
        Assert.assertNull((Object)ldnMessage);
    }

    @Override
    @After
    public void destroy() throws Exception {
        List ldnMessageEntities = this.ldnMessageService.findAll(this.context);
        if (CollectionUtils.isNotEmpty((Collection)ldnMessageEntities)) {
            ldnMessageEntities.forEach(ldnMessage -> {
                try {
                    this.ldnMessageService.delete(this.context, ldnMessage);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        super.destroy();
    }
}

