/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.Provider;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.dspace.AbstractUnitTest;
import org.dspace.app.requestitem.JavaMailTestTransport;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.requestitem.RequestItemEmailNotifier;
import org.dspace.app.requestitem.RequestItemHelpdeskStrategy;
import org.dspace.app.requestitem.factory.RequestItemServiceFactory;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.builder.AbstractBuilder;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RequestItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class RequestItemEmailNotifierTest
extends AbstractUnitTest {
    public static final String TRANSPORT_CLASS_KEY = "mail.smtp.class";
    private static final String REQUESTOR_ADDRESS = "mhwood@wood.net";
    private static final String REQUESTOR_NAME = "Mark Wood";
    private static final String HELPDESK_ADDRESS = "help@example.com";
    private static final String HELPDESK_NAME = "Help Desk";
    private static final String TEST_MESSAGE = "Message";
    private static final String DUMMY_PROTO = "dummy";
    private static ConfigurationService configurationService;
    private static BitstreamService bitstreamService;
    private static HandleService handleService;
    private static RequestItemService requestItemService;
    private static RequestItemEmailNotifier requestItemEmailNotifier;

    @BeforeClass
    public static void setUpClass() {
        AbstractBuilder.init();
        configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
        handleService = HandleServiceFactory.getInstance().getHandleService();
        requestItemService = RequestItemServiceFactory.getInstance().getRequestItemService();
        requestItemEmailNotifier = new RequestItemEmailNotifier((RequestItemAuthorExtractor)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(RequestItemHelpdeskStrategy.class.getName(), RequestItemAuthorExtractor.class));
        RequestItemEmailNotifierTest.requestItemEmailNotifier.bitstreamService = bitstreamService;
        RequestItemEmailNotifierTest.requestItemEmailNotifier.configurationService = configurationService;
        RequestItemEmailNotifierTest.requestItemEmailNotifier.handleService = handleService;
        RequestItemEmailNotifierTest.requestItemEmailNotifier.requestItemService = requestItemService;
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        AbstractBuilder.cleanupObjects();
        AbstractBuilder.destroy();
    }

    @Ignore
    @Test
    public void testSendRequest() throws Exception {
    }

    @Test
    public void testSendResponse() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity(this.context).withName("Top Community").build();
        Collection col = CollectionBuilder.createCollection(this.context, com).build();
        Item item = ItemBuilder.createItem(this.context, col).withTitle("Test Item").build();
        this.context.restoreAuthSystemState();
        RequestItem ri = new RequestItem();
        ri.setAccept_request(true);
        ri.setItem(item);
        ri.setAllfiles(true);
        ri.setReqEmail(REQUESTOR_ADDRESS);
        ri.setReqName(REQUESTOR_NAME);
        Session session = DSpaceServicesFactory.getInstance().getEmailService().getSession();
        Provider transportProvider = new Provider(Provider.Type.TRANSPORT, DUMMY_PROTO, JavaMailTestTransport.class.getCanonicalName(), "DSpace", "1.0");
        session.addProvider(transportProvider);
        session.setProvider(transportProvider);
        session.setProtocolForAddress("rfc822", DUMMY_PROTO);
        configurationService.setProperty("mail.helpdesk", (Object)HELPDESK_ADDRESS);
        configurationService.setProperty("mail.helpdesk.name", (Object)HELPDESK_NAME);
        configurationService.setProperty("request.item.helpdesk.override", (Object)"true");
        configurationService.setProperty("mail.server.disabled", (Object)"false");
        requestItemEmailNotifier.sendResponse(this.context, ri, null, TEST_MESSAGE);
        Address[] myAddresses = JavaMailTestTransport.getAddresses();
        Assert.assertEquals((String)"Should have one To: address.", (long)myAddresses.length, (long)1L);
        MatcherAssert.assertThat((String)"To: should be an Internet address", (Object)myAddresses[0], (Matcher)Matchers.instanceOf(InternetAddress.class));
        String address = ((InternetAddress)myAddresses[0]).getAddress();
        Assert.assertEquals((String)"To: address should match requester.", (Object)ri.getReqEmail(), (Object)address);
        Message myMessage = JavaMailTestTransport.getMessage();
        Object content = myMessage.getContent();
        MatcherAssert.assertThat((String)"Body should be a single text bodypart", (Object)content, (Matcher)Matchers.instanceOf(String.class));
        MatcherAssert.assertThat((String)"Should contain the helpdesk name", (Object)((String)content), (Matcher)Matchers.containsString((String)HELPDESK_NAME));
        MatcherAssert.assertThat((String)"Should contain the test custom message", (Object)((String)content), (Matcher)Matchers.containsString((String)TEST_MESSAGE));
    }

    @Test
    public void testSendRejection() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity(this.context).withName("Top Community").build();
        Collection col = CollectionBuilder.createCollection(this.context, com).build();
        Item item = ItemBuilder.createItem(this.context, col).withTitle("Test Item").build();
        this.context.restoreAuthSystemState();
        RequestItem ri = new RequestItem();
        ri.setAccept_request(false);
        ri.setItem(item);
        ri.setAllfiles(true);
        ri.setReqEmail(REQUESTOR_ADDRESS);
        ri.setReqName(REQUESTOR_NAME);
        Session session = DSpaceServicesFactory.getInstance().getEmailService().getSession();
        Provider transportProvider = new Provider(Provider.Type.TRANSPORT, DUMMY_PROTO, JavaMailTestTransport.class.getCanonicalName(), "DSpace", "1.0");
        session.addProvider(transportProvider);
        session.setProvider(transportProvider);
        session.setProtocolForAddress("rfc822", DUMMY_PROTO);
        configurationService.setProperty("mail.helpdesk", (Object)HELPDESK_ADDRESS);
        configurationService.setProperty("mail.helpdesk.name", (Object)HELPDESK_NAME);
        configurationService.setProperty("request.item.helpdesk.override", (Object)"true");
        configurationService.setProperty("mail.server.disabled", (Object)"false");
        requestItemEmailNotifier.sendResponse(this.context, ri, null, TEST_MESSAGE);
        Address[] myAddresses = JavaMailTestTransport.getAddresses();
        Assert.assertEquals((String)"Should have one To: address.", (long)myAddresses.length, (long)1L);
        MatcherAssert.assertThat((String)"To: should be an Internet address", (Object)myAddresses[0], (Matcher)Matchers.instanceOf(InternetAddress.class));
        String address = ((InternetAddress)myAddresses[0]).getAddress();
        Assert.assertEquals((String)"To: address should match requester.", (Object)ri.getReqEmail(), (Object)address);
        Message myMessage = JavaMailTestTransport.getMessage();
        Object content = myMessage.getContent();
        MatcherAssert.assertThat((String)"Body should be a single text bodypart", (Object)content, (Matcher)Matchers.instanceOf(String.class));
        MatcherAssert.assertThat((String)"Should contain the helpdesk name", (Object)((String)content), (Matcher)Matchers.containsString((String)HELPDESK_NAME));
        MatcherAssert.assertThat((String)"Should contain the test custom message", (Object)((String)content), (Matcher)Matchers.containsString((String)TEST_MESSAGE));
        MatcherAssert.assertThat((String)"Should contain the word 'denied'.", (Object)((String)content), (Matcher)Matchers.containsString((String)"denied"));
    }

    @Test
    public void testEmailGenerationWithLargeFileLink() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = CommunityBuilder.createCommunity(this.context).withName("Top Community").build();
        Collection col = CollectionBuilder.createCollection(this.context, com).build();
        Item item = ItemBuilder.createItem(this.context, col).withTitle("Test Item").build();
        byte[] bytes = new byte[0x1500000];
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Bitstream largeBitstream = BitstreamBuilder.createBitstream(this.context, item, (InputStream)is).withName("large.pdf").build();
        this.context.restoreAuthSystemState();
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, item, largeBitstream).withAcceptRequest(true).build();
        Session session = DSpaceServicesFactory.getInstance().getEmailService().getSession();
        Provider transportProvider = new Provider(Provider.Type.TRANSPORT, DUMMY_PROTO, JavaMailTestTransport.class.getCanonicalName(), "DSpace", "1.0");
        session.addProvider(transportProvider);
        session.setProvider(transportProvider);
        session.setProtocolForAddress("rfc822", DUMMY_PROTO);
        String responseLink = request.getAccess_token();
        requestItemEmailNotifier.sendResponse(this.context, request, "Subject", TEST_MESSAGE);
        Message myMessage = JavaMailTestTransport.getMessage();
        String content = (String)myMessage.getContent();
        MatcherAssert.assertThat((String)"Should contain access link", (Object)content, (Matcher)Matchers.containsString((String)responseLink));
        MatcherAssert.assertThat((String)"Should not contain attachment marker", (Object)content, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Attachment")));
    }

    @Ignore
    @Test
    public void testRequestOpenAccess() throws Exception {
    }
}

