/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import org.dspace.AbstractUnitTest;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.RequestItemServiceImpl;
import org.dspace.app.requestitem.factory.RequestItemServiceFactory;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RequestItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RequestItemTest
extends AbstractUnitTest {
    private static RequestItemService requestItemService;
    private static ConfigurationService configurationService;
    private static HandleService handleService;
    private static BitstreamService bitstreamService;
    private Community parentCommunity;
    private Collection collection;
    private Item item;
    private Bitstream bitstream;
    private Context context;

    @BeforeClass
    public static void setUpClass() throws SQLException {
        AbstractBuilder.init();
        Context ctx = new Context();
        ctx.turnOffAuthorisationSystem();
        ctx.restoreAuthSystemState();
        ctx.complete();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        AbstractBuilder.cleanupObjects();
        AbstractBuilder.destroy();
    }

    @Before
    public void setUp() throws Exception {
        configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        handleService = HandleServiceFactory.getInstance().getHandleService();
        requestItemService = RequestItemServiceFactory.getInstance().getRequestItemService();
        bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
        configurationService.setProperty("mail.server.disabled", (Object)"false");
        try {
            this.context = new Context();
            this.context.turnOffAuthorisationSystem();
            this.context.setCurrentUser(this.eperson);
            this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Community").build();
            this.collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection").withAdminGroup(this.eperson).build();
            this.item = ItemBuilder.createItem(this.context, this.collection).withTitle("Item").build();
            ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
            this.bitstream = BitstreamBuilder.createBitstream(this.context, this.item, (InputStream)is).withName("Bitstream").build();
        }
        catch (IOException | SQLException | AuthorizeException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testAccessTokenGenerationWithLargeFile() throws Exception {
        byte[] bytes = new byte[0x1500000];
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Bitstream largeBitstream = BitstreamBuilder.createBitstream(this.context, this.item, (InputStream)is).withName("LargeBitstream").build();
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, largeBitstream).build();
        Assert.assertNotNull((String)"Request token should not be null", (Object)request.getAccess_token());
    }

    @Test
    public void testAccessTokenGenerationWithSmallFile() throws Exception {
        byte[] bytes = new byte[0x100000];
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Bitstream smallBitstream = BitstreamBuilder.createBitstream(this.context, this.item, (InputStream)is).withName("SmallBitstream").build();
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, smallBitstream).build();
        Assert.assertNull((String)"Request token should be null", (Object)request.getAccess_token());
    }

    @Test
    public void testAuthorizeWithValidPeriod() throws Exception {
        Instant decisionDate = this.getYesterdayAsInstant();
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).withAcceptRequest(true).withAccessToken("test-token").withDecisionDate(decisionDate).withAccessExpiry(this.getExpiryAsInstant("+10DAYS", decisionDate)).build();
        try {
            requestItemService.authorizeAccessByAccessToken(this.context, request, this.bitstream, request.getAccess_token());
            Assert.assertNotNull((Object)request.getAccess_token());
        }
        catch (AuthorizeException e) {
            Assert.fail((String)"AuthorizeException should not be thrown for a valid expiry period");
        }
    }

    @Test(expected=AuthorizeException.class)
    public void testAuthorizeWithExpiredPeriod() throws Exception {
        Instant decisionDate = this.getYesterdayAsInstant();
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).withAcceptRequest(true).withAccessToken("test-token").withDecisionDate(decisionDate).withAccessExpiry(this.getExpiryAsInstant("+1DAY", decisionDate)).build();
        requestItemService.authorizeAccessByAccessToken(this.context, request, this.bitstream, request.getAccess_token());
    }

    @Test(expected=AuthorizeException.class)
    public void testAuthorizeWithNullToken() throws Exception {
        requestItemService.authorizeAccessByAccessToken(this.context, this.bitstream, null);
    }

    @Test(expected=AuthorizeException.class)
    public void testAuthorizeWithInvalidToken() throws Exception {
        requestItemService.authorizeAccessByAccessToken(this.context, this.bitstream, "invalid-token-123");
    }

    @Test(expected=AuthorizeException.class)
    public void testAuthorizeWithMismatchedToken() throws Exception {
        Instant decisionDate = this.getYesterdayAsInstant();
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).withAcceptRequest(true).withAccessToken("test-token").withDecisionDate(decisionDate).withAccessExpiry(this.getExpiryAsInstant("FOREVER", decisionDate)).build();
        requestItemService.authorizeAccessByAccessToken(this.context, request, this.bitstream, "invalid-token-123");
    }

    @Test(expected=AuthorizeException.class)
    public void testAuthorizeWithMismatchedBitstream() throws Exception {
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).withAcceptRequest(true).withAccessToken("test-token").build();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        Bitstream otherBitstream = BitstreamBuilder.createBitstream(this.context, this.item, (InputStream)is).withName("OtherBitstream").build();
        requestItemService.authorizeAccessByAccessToken(this.context, request, otherBitstream, request.getAccess_token());
    }

    @Test(expected=AuthorizeException.class)
    public void testAuthorizeWithAllFilesDisabled() throws Exception {
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).withAcceptRequest(true).withAccessToken("test-token").withAllFiles(false).build();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        Bitstream otherBitstream = BitstreamBuilder.createBitstream(this.context, this.item, (InputStream)is).withName("OtherBitstream").build();
        requestItemService.authorizeAccessByAccessToken(this.context, request, otherBitstream, request.getAccess_token());
    }

    @Test
    public void testGrantRequestWithAccessPeriod() throws Exception {
        Instant decisionDate = Instant.now();
        Instant expectedExpiryDate = decisionDate.plus(7L, ChronoUnit.DAYS);
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).build();
        request.setAccept_request(true);
        request.setDecision_date(decisionDate);
        request.setAccess_expiry(this.getExpiryAsInstant("+7DAYS", decisionDate));
        requestItemService.update(this.context, request);
        RequestItem found = requestItemService.findByToken(this.context, request.getToken());
        Assert.assertTrue((boolean)found.isAccept_request());
        Assert.assertEquals((Object)decisionDate, (Object)found.getDecision_date());
        Assert.assertEquals((Object)expectedExpiryDate, (Object)found.getAccess_expiry());
    }

    @Test
    public void testDenyRequest() throws Exception {
        Instant decisionDate = Instant.now();
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).build();
        request.setAccept_request(false);
        request.setDecision_date(decisionDate);
        requestItemService.update(this.context, request);
        RequestItem found = requestItemService.findByToken(this.context, request.getToken());
        Assert.assertFalse((boolean)found.isAccept_request());
        Assert.assertNotNull((Object)found.getDecision_date());
    }

    @Test
    public void testFindRequestsByItem() throws Exception {
        RequestItem request1 = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).build();
        RequestItem request2 = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).build();
        Iterator requests = requestItemService.findByItem(this.context, this.item);
        int count = 0;
        while (requests.hasNext()) {
            ++count;
            requests.next();
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testModifyGrantedRequest() throws Exception {
        Instant decisionDate = Instant.now();
        Instant expectedExpiryDate = decisionDate.plus(10L, ChronoUnit.DAYS);
        RequestItem request = RequestItemBuilder.createRequestItem(this.context, this.item, this.bitstream).withAcceptRequest(true).withDecisionDate(decisionDate).withAccessExpiry(this.getExpiryAsInstant("+1DAY", decisionDate)).build();
        request.setAccess_expiry(this.getExpiryAsInstant("+10DAYS", decisionDate));
        request.setAllfiles(true);
        requestItemService.update(this.context, request);
        RequestItem found = requestItemService.findByToken(this.context, request.getToken());
        Assert.assertEquals((Object)expectedExpiryDate, (Object)found.getAccess_expiry());
        Assert.assertTrue((boolean)found.isAccept_request());
        Assert.assertTrue((boolean)found.isAllfiles());
    }

    @Test
    public void testGetLinkTokenEmailWithSubPath() throws MalformedURLException, URISyntaxException {
        String currentDspaceUrl = configurationService.getProperty("dspace.ui.url");
        String newDspaceUrl = currentDspaceUrl + "/subdir";
        configurationService.setProperty("dspace.ui.url", (Object)newDspaceUrl);
        String expectedUrl = newDspaceUrl + "/request-a-copy/token";
        String generatedLink = requestItemService.getLinkTokenEmail("token");
        Assert.assertEquals((Object)expectedUrl, (Object)generatedLink);
        configurationService.reloadConfig();
    }

    @Test
    public void testGetLinkTokenEmailWithoutSubPath() throws MalformedURLException, URISyntaxException {
        String currentDspaceUrl = configurationService.getProperty("dspace.ui.url");
        String expectedUrl = currentDspaceUrl + "/request-a-copy/token";
        String generatedLink = requestItemService.getLinkTokenEmail("token");
        Assert.assertEquals((Object)expectedUrl, (Object)generatedLink);
        configurationService.reloadConfig();
    }

    private Instant getYesterdayAsInstant() {
        return Instant.now().minus(Duration.ofDays(1L));
    }

    private Instant getExpiryAsInstant(String dateOrDelta, Instant decision) {
        try {
            return RequestItemServiceImpl.parseDateOrDelta((String)dateOrDelta, (Instant)decision);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

