/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion.openalex;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dspace.app.suggestion.openalex.OpenAlexPublicationLoader;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class OpenAlexPublicationLoaderTest {
    private OpenAlexPublicationLoader loader;
    @Mock
    private Item researcher;
    private ItemService itemService;

    @Before
    public void setUp() {
        this.itemService = (ItemService)Mockito.mock(ItemService.class);
        this.loader = new OpenAlexPublicationLoader();
        this.loader.setItemService(this.itemService);
    }

    @Test
    public void testSearchMetadataValues_NoMetadata_ReturnsEmptyList() {
        Mockito.when((Object)this.itemService.getMetadata((DSpaceObject)((Item)Mockito.any(Item.class)), Mockito.anyString())).thenReturn(null);
        this.loader.setNames(Collections.singletonList("dc.contributor.author"));
        List result = this.loader.searchMetadataValues(this.researcher);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testSearchMetadataValues_WithDcIdentifierOther_ReturnsFilterQuery() {
        this.loader.setNames(Arrays.asList("dc.identifier.openalex", "dc.contributor.author"));
        Mockito.when((Object)this.itemService.getMetadata((DSpaceObject)this.researcher, "dc.identifier.openalex")).thenReturn((Object)"ID123");
        List result = this.loader.searchMetadataValues(this.researcher);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"ID123", result.get(0));
    }

    @Test
    public void testSearchMetadataValues_NoDcIdentifierOther_ReturnsAuthorIds() {
        this.loader.setNames(Collections.singletonList("dc.contributor.author"));
        Mockito.when((Object)this.itemService.getMetadata((DSpaceObject)this.researcher, "dc.contributor.author")).thenReturn((Object)"Author Name");
        List result = this.loader.searchMetadataValues(this.researcher);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"search_by_author=Author Name", result.get(0));
    }

    @Test
    public void testSearchMetadataValues_MixedNullValues_IgnoresNulls() {
        this.loader.setNames(Arrays.asList("dc.identifier.openalex", "dc.contributor.author", "dc.title"));
        Mockito.when((Object)this.itemService.getMetadata((DSpaceObject)this.researcher, "dc.identifier.openalex")).thenReturn(null);
        Mockito.when((Object)this.itemService.getMetadata((DSpaceObject)this.researcher, "dc.contributor.author")).thenReturn((Object)"Author Name");
        Mockito.when((Object)this.itemService.getMetadata((DSpaceObject)this.researcher, "dc.title")).thenReturn((Object)"Title");
        List result = this.loader.searchMetadataValues(this.researcher);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"search_by_author=Author Name", result.get(0));
        Assert.assertEquals((Object)"search_by_author=Title", result.get(1));
    }
}

