/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.dspace.AbstractUnitTest;
import org.dspace.authenticate.SamlAuthentication;
import org.dspace.builder.AbstractBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.MetadataValue;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class SamlAuthenticationTest
extends AbstractUnitTest {
    private static ConfigurationService configurationService;
    private HttpServletRequest request;
    private SamlAuthentication samlAuth;
    private EPerson testUser;

    @BeforeClass
    public static void beforeAll() {
        configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        AbstractBuilder.init();
    }

    @Before
    public void beforeEach() throws Exception {
        configurationService.setProperty("authentication-saml.autoregister", (Object)true);
        configurationService.setProperty("authentication-saml.eperson.metadata.autocreate", (Object)true);
        this.request = new MockHttpServletRequest();
        this.samlAuth = new SamlAuthentication();
        this.testUser = null;
    }

    @After
    public void afterEach() throws Exception {
        if (this.testUser != null) {
            EPersonBuilder.deleteEPerson(this.testUser.getID());
        }
    }

    @AfterClass
    public static void afterAll() {
        AbstractBuilder.destroy();
    }

    @Test
    public void testAuthenticateExistingUserByEmail() throws Exception {
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.EMAIL", List.of("alyssa@dspace.org"));
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"alyssa@dspace.org", (Object)user.getEmail());
        Assert.assertNull((Object)user.getNetid());
        Assert.assertEquals((Object)"Alyssa", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Hacker", (Object)user.getLastName());
    }

    @Test
    public void testAuthenticateExistingUserByNetId() throws Exception {
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNetId("001").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"001");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"alyssa@dspace.org", (Object)user.getEmail());
        Assert.assertEquals((Object)"001", (Object)user.getNetid());
        Assert.assertEquals((Object)"Alyssa", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Hacker", (Object)user.getLastName());
    }

    @Test
    public void testAuthenticateExistingUserByEmailWithUnexpectedNetId() throws Exception {
        EPerson originalUser = this.context.getCurrentUser();
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("ben@dspace.org").withNetId("002").withNameInMetadata("Ben", "Bitdiddle").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.EMAIL", List.of("ben@dspace.org"));
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"oh-no-its-different-than-the-stored-netid");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)4L, (long)result);
        Assert.assertEquals((Object)originalUser, (Object)this.context.getCurrentUser());
    }

    @Test
    public void testAuthenticateExistingUserByEmailUpdatesNullNetId() throws Exception {
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("carrie@dspace.org").withNameInMetadata("Carrie", "Pragma").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.EMAIL", List.of("carrie@dspace.org"));
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"netid-from-idp");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"carrie@dspace.org", (Object)user.getEmail());
        Assert.assertEquals((Object)"netid-from-idp", (Object)user.getNetid());
        Assert.assertEquals((Object)"Carrie", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Pragma", (Object)user.getLastName());
    }

    @Test
    public void testAuthenticateExistingUserByNetIdUpdatesEmail() throws Exception {
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNetId("001").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"001");
        this.request.setAttribute("org.dspace.saml.EMAIL", List.of("aphacker@dspace.org"));
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"aphacker@dspace.org", (Object)user.getEmail());
        Assert.assertEquals((Object)"001", (Object)user.getNetid());
        Assert.assertEquals((Object)"Alyssa", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Hacker", (Object)user.getLastName());
    }

    @Test
    public void testAuthenticateExistingUserUpdatesName() throws Exception {
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNetId("001").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"001");
        this.request.setAttribute("org.dspace.saml.GIVEN_NAME", (Object)"Liz");
        this.request.setAttribute("org.dspace.saml.SURNAME", (Object)"Hacker-Bitdiddle");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"alyssa@dspace.org", (Object)user.getEmail());
        Assert.assertEquals((Object)"001", (Object)user.getNetid());
        Assert.assertEquals((Object)"Liz", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Hacker-Bitdiddle", (Object)user.getLastName());
    }

    @Test
    public void testAuthenticateExistingUserAdditionalMetadata() throws Exception {
        configurationService.setProperty("authentication-saml.eperson.metadata", (Object)"org.dspace.saml.PHONE => phone,org.dspace.saml.NICKNAME => nickname");
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNetId("001").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"001");
        this.request.setAttribute("org.dspace.saml.PHONE", (Object)"123-456-7890");
        this.request.setAttribute("org.dspace.saml.NICKNAME", (Object)"Liz");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"alyssa@dspace.org", (Object)user.getEmail());
        Assert.assertEquals((Object)"001", (Object)user.getNetid());
        Assert.assertEquals((Object)"Alyssa", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Hacker", (Object)user.getLastName());
        List metadata = user.getMetadata();
        Assert.assertEquals((long)4L, (long)metadata.size());
        Assert.assertEquals((Object)"eperson_phone", (Object)((MetadataValue)metadata.get(2)).getMetadataField().toString());
        Assert.assertEquals((Object)"123-456-7890", (Object)((MetadataValue)metadata.get(2)).getValue());
        Assert.assertEquals((Object)"eperson_nickname", (Object)((MetadataValue)metadata.get(3)).getMetadataField().toString());
        Assert.assertEquals((Object)"Liz", (Object)((MetadataValue)metadata.get(3)).getValue());
    }

    @Test
    public void testInvalidAdditionalMetadataMappingsAreIgnored() throws Exception {
        configurationService.setProperty("authentication-saml.eperson.metadata", (Object)"oops this is bad,org.dspace.saml.NICKNAME => nickname");
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNetId("001").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"001");
        this.request.setAttribute("org.dspace.saml.PHONE", (Object)"123-456-7890");
        this.request.setAttribute("org.dspace.saml.NICKNAME", (Object)"Liz");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"alyssa@dspace.org", (Object)user.getEmail());
        Assert.assertEquals((Object)"001", (Object)user.getNetid());
        Assert.assertEquals((Object)"Alyssa", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Hacker", (Object)user.getLastName());
        List metadata = user.getMetadata();
        Assert.assertEquals((long)3L, (long)metadata.size());
        Assert.assertEquals((Object)"eperson_nickname", (Object)((MetadataValue)metadata.get(2)).getMetadataField().toString());
        Assert.assertEquals((Object)"Liz", (Object)((MetadataValue)metadata.get(2)).getValue());
    }

    @Test
    public void testAuthenticateExistingUserAdditionalMetadataAutocreateDisabled() throws Exception {
        configurationService.setProperty("authentication-saml.eperson.metadata.autocreate", (Object)false);
        configurationService.setProperty("authentication-saml.eperson.metadata", (Object)"org.dspace.saml.PHONE => phone,org.dspace.saml.DEPARTMENT => department");
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNetId("001").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"001");
        this.request.setAttribute("org.dspace.saml.PHONE", (Object)"123-456-7890");
        this.request.setAttribute("org.dspace.saml.DEPARTMENT", (Object)"Library");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"alyssa@dspace.org", (Object)user.getEmail());
        Assert.assertEquals((Object)"001", (Object)user.getNetid());
        Assert.assertEquals((Object)"Alyssa", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Hacker", (Object)user.getLastName());
        List metadata = user.getMetadata();
        Assert.assertEquals((long)3L, (long)metadata.size());
        Assert.assertEquals((Object)"eperson_phone", (Object)((MetadataValue)metadata.get(2)).getMetadataField().toString());
        Assert.assertEquals((Object)"123-456-7890", (Object)((MetadataValue)metadata.get(2)).getValue());
    }

    @Test
    public void testAdditionalMetadataWithInvalidNameNotAutocreated() throws Exception {
        configurationService.setProperty("authentication-saml.eperson.metadata", (Object)"org.dspace.saml.PHONE => phone,org.dspace.saml.DEPARTMENT => (department)");
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNetId("001").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"001");
        this.request.setAttribute("org.dspace.saml.PHONE", (Object)"123-456-7890");
        this.request.setAttribute("org.dspace.saml.DEPARTMENT", (Object)"Library");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"alyssa@dspace.org", (Object)user.getEmail());
        Assert.assertEquals((Object)"001", (Object)user.getNetid());
        Assert.assertEquals((Object)"Alyssa", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Hacker", (Object)user.getLastName());
        List metadata = user.getMetadata();
        Assert.assertEquals((long)3L, (long)metadata.size());
        Assert.assertEquals((Object)"eperson_phone", (Object)((MetadataValue)metadata.get(2)).getMetadataField().toString());
        Assert.assertEquals((Object)"123-456-7890", (Object)((MetadataValue)metadata.get(2)).getValue());
    }

    @Test
    public void testExistingUserLoginDisabled() throws Exception {
        EPerson originalUser = this.context.getCurrentUser();
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNameInMetadata("Alyssa", "Hacker").withCanLogin(false).build();
        this.context.restoreAuthSystemState();
        this.request.setAttribute("org.dspace.saml.EMAIL", List.of("alyssa@dspace.org"));
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)5L, (long)result);
        Assert.assertEquals((Object)originalUser, (Object)this.context.getCurrentUser());
    }

    @Test
    public void testNonExistentUserWithoutEmail() throws Exception {
        EPerson originalUser = this.context.getCurrentUser();
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"non-existent-netid");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)4L, (long)result);
        Assert.assertEquals((Object)originalUser, (Object)this.context.getCurrentUser());
    }

    @Test
    public void testNonExistentUserWithEmailAutoregisterEnabled() throws Exception {
        this.context.setCurrentUser(null);
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"non-existent-netid");
        this.request.setAttribute("org.dspace.saml.EMAIL", List.of("ben@dspace.org"));
        this.request.setAttribute("org.dspace.saml.GIVEN_NAME", (Object)"Ben");
        this.request.setAttribute("org.dspace.saml.SURNAME", (Object)"Bitdiddle");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)1L, (long)result);
        EPerson user = this.context.getCurrentUser();
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"ben@dspace.org", (Object)user.getEmail());
        Assert.assertEquals((Object)"non-existent-netid", (Object)user.getNetid());
        Assert.assertEquals((Object)"Ben", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Bitdiddle", (Object)user.getLastName());
        Assert.assertTrue((boolean)user.canLogIn());
        Assert.assertTrue((boolean)user.getSelfRegistered());
        this.testUser = user;
    }

    @Test
    public void testNonExistentUserWithEmailAutoregisterDisabled() throws Exception {
        configurationService.setProperty("authentication-saml.autoregister", (Object)false);
        EPerson originalUser = this.context.getCurrentUser();
        this.request.setAttribute("org.dspace.saml.NAME_ID", (Object)"non-existent-netid");
        this.request.setAttribute("org.dspace.saml.EMAIL", List.of("ben@dspace.org"));
        this.request.setAttribute("org.dspace.saml.GIVEN_NAME", (Object)"Ben");
        this.request.setAttribute("org.dspace.saml.SURNAME", (Object)"Bitdiddle");
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)4L, (long)result);
        Assert.assertEquals((Object)originalUser, (Object)this.context.getCurrentUser());
    }

    @Test
    public void testNoEmailOrNameIdInRequest() throws Exception {
        this.context.setCurrentUser(null);
        this.context.turnOffAuthorisationSystem();
        this.testUser = EPersonBuilder.createEPerson(this.context).withEmail("alyssa@dspace.org").withNameInMetadata("Alyssa", "Hacker").withCanLogin(true).build();
        this.context.restoreAuthSystemState();
        int result = this.samlAuth.authenticate(this.context, null, null, null, this.request);
        Assert.assertEquals((long)4L, (long)result);
    }

    @Test
    public void testRequestIsNull() throws Exception {
        EPerson originalUser = this.context.getCurrentUser();
        int result = this.samlAuth.authenticate(this.context, null, null, null, null);
        Assert.assertEquals((long)5L, (long)result);
        Assert.assertEquals((Object)originalUser, (Object)this.context.getCurrentUser());
    }
}

