/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import org.dspace.AbstractIntegrationTest;
import org.dspace.authorize.RegexPasswordValidator;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RegexPasswordValidatorIT
extends AbstractIntegrationTest {
    @Mock
    private ConfigurationService configurationService;
    @InjectMocks
    private RegexPasswordValidator regexPasswordValidator;

    @Before
    public void setup() {
        Mockito.when((Object)this.configurationService.getProperty("authentication-password.regex-validation.pattern")).thenReturn((Object)"^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[^\\da-zA-Z]).{8,15}$");
    }

    @Test
    public void testValidPassword() {
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("TestPassword01!"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testInvalidPasswordForMissingSpecialCharacter() {
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("TestPassword01"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("TestPassword01?"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testInvalidPasswordForMissingNumber() {
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("TestPassword!"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("TestPassword1!"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testInvalidPasswordForMissingUppercaseCharacter() {
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("testpassword01!"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("testPassword01!"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testInvalidPasswordForMissingLowercaseCharacter() {
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("TESTPASSWORD01!"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("TESTPASSWORd01!"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testInvalidPasswordForTooShortValue() {
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("Test01!"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("Test012!"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testInvalidPasswordForTooLongValue() {
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("ThisIsAVeryLongPassword01!"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.regexPasswordValidator.isPasswordValid("IsAPassword012!"), (Matcher)Matchers.is((Object)true));
    }
}

