/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractDSpaceObjectBuilder;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class CommunityBuilder
extends AbstractDSpaceObjectBuilder<Community> {
    private Community community;

    protected CommunityBuilder(Context context) {
        super(context);
    }

    public static CommunityBuilder createCommunity(Context context) {
        CommunityBuilder builder = new CommunityBuilder(context);
        return builder.create(null);
    }

    public static CommunityBuilder createCommunity(Context context, String handle) {
        CommunityBuilder builder = new CommunityBuilder(context);
        return builder.create(handle);
    }

    private CommunityBuilder create(String handle) {
        return CommunityBuilder.createSubCommunity(this.context, null, handle);
    }

    public static CommunityBuilder createSubCommunity(Context context, Community parent) {
        CommunityBuilder builder = new CommunityBuilder(context);
        return builder.createSub(parent, null);
    }

    public static CommunityBuilder createSubCommunity(Context context, Community parent, String handle) {
        CommunityBuilder builder = new CommunityBuilder(context);
        return builder.createSub(parent, handle);
    }

    private CommunityBuilder createSub(Community parent, String handle) {
        try {
            this.community = communityService.create(parent, this.context, handle);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this;
    }

    public CommunityBuilder withName(String communityName) {
        return (CommunityBuilder)this.setMetadataSingleValue(this.community, MetadataSchemaEnum.DC.getName(), "title", null, communityName);
    }

    public CommunityBuilder withTitle(String communityTitle) {
        return (CommunityBuilder)this.addMetadataValue(this.community, MetadataSchemaEnum.DC.getName(), "title", null, communityTitle);
    }

    public CommunityBuilder withLogo(String content) throws AuthorizeException, IOException, SQLException {
        try (InputStream is = IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8);){
            communityService.setLogo(this.context, this.community, is);
        }
        return this;
    }

    public CommunityBuilder withAdminGroup(EPerson ... members) throws SQLException, AuthorizeException {
        Group g = communityService.createAdministrators(this.context, this.community);
        for (EPerson e : members) {
            groupService.addMember(this.context, g, e);
        }
        groupService.update(this.context, (DSpaceObject)g);
        return this;
    }

    public CommunityBuilder addParentCommunity(Context context, Community parent) throws SQLException, AuthorizeException {
        communityService.addSubcommunity(context, parent, this.community);
        return this;
    }

    @Override
    public Community build() {
        try {
            communityService.update(this.context, (DSpaceObject)this.community);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.community;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.community = (Community)c.reloadEntity((ReloadableEntity)this.community);
            if (this.community != null) {
                this.deleteAdminGroup(c);
                this.delete(c, this.community);
                c.complete();
            }
        }
    }

    private void deleteAdminGroup(Context c) throws SQLException, AuthorizeException, IOException {
        Group group = this.community.getAdministrators();
        if (group != null) {
            communityService.removeAdministrators(c, this.community);
            groupService.delete(c, (DSpaceObject)group);
        }
    }

    @Override
    protected DSpaceObjectService<Community> getService() {
        return communityService;
    }

    public static void deleteCommunity(UUID uuid) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            Community community = (Community)communityService.find(c, uuid);
            if (community != null) {
                try {
                    Group adminGroup = community.getAdministrators();
                    if (adminGroup != null) {
                        communityService.removeAdministrators(c, community);
                        groupService.delete(c, (DSpaceObject)adminGroup);
                    }
                    communityService.delete(c, (DSpaceObject)community);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            c.complete();
        }
    }
}

