/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.identifier.DOI;
import org.dspace.identifier.service.DOIService;

public class DOIBuilder
extends AbstractBuilder<DOI, DOIService> {
    private DOI doi;

    protected DOIBuilder(Context context) {
        super(context);
    }

    public static DOIBuilder createDOI(Context context) {
        DOIBuilder builder = new DOIBuilder(context);
        return builder.create(context);
    }

    private DOIBuilder create(Context context) {
        try {
            this.doi = doiService.create(context);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public DOIBuilder withDoi(String doi) {
        this.doi.setDoi(doi);
        return this;
    }

    public DOIBuilder withDSpaceObject(DSpaceObject dSpaceObject) {
        this.doi.setDSpaceObject(dSpaceObject);
        return this;
    }

    public DOIBuilder withStatus(Integer status) {
        this.doi.setStatus(status);
        return this;
    }

    @Override
    public DOI build() throws SQLException, AuthorizeException {
        return this.doi;
    }

    @Override
    public void delete(Context c, DOI doi) throws Exception {
        try {
            doiService.delete(c, doi);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cleanup() throws Exception {
        try (Context context = new Context();){
            context.setDispatcher("noindex");
            context.turnOffAuthorisationSystem();
            this.doi = (DOI)context.reloadEntity((ReloadableEntity)this.doi);
            if (this.doi != null) {
                this.delete(context, this.doi);
                context.complete();
            }
        }
    }

    @Override
    protected DOIService getService() {
        return doiService;
    }
}

