/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.List;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.dao.RelationshipDAO;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.RelationshipService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RelationshipServiceImplVersioningIT
extends AbstractIntegrationTestWithDatabase {
    private RelationshipService relationshipService;
    private RelationshipDAO relationshipDAO;
    protected Community community;
    protected Collection collection;
    protected EntityType publicationEntityType;
    protected EntityType personEntityType;
    protected RelationshipType relationshipType;
    protected Item publication1;
    protected Item publication2;
    protected Item publication3;
    protected Item person1;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
        this.relationshipDAO = (RelationshipDAO)DSpaceServicesFactory.getInstance().getServiceManager().getServicesByType(RelationshipDAO.class).get(0);
        this.context.turnOffAuthorisationSystem();
        this.community = CommunityBuilder.createCommunity(this.context).withName("community").build();
        this.collection = CollectionBuilder.createCollection(this.context, this.community).withName("collection").build();
        this.publicationEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        this.personEntityType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        this.relationshipType = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, this.publicationEntityType, this.personEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null).withCopyToLeft(false).withCopyToRight(false).build();
        this.publication1 = ItemBuilder.createItem(this.context, this.collection).withTitle("publication1").withMetadata("dspace", "entity", "type", this.publicationEntityType.getLabel()).build();
        this.publication2 = ItemBuilder.createItem(this.context, this.collection).withTitle("publication2").withMetadata("dspace", "entity", "type", this.publicationEntityType.getLabel()).build();
        this.publication3 = ItemBuilder.createItem(this.context, this.collection).withTitle("publication3").withMetadata("dspace", "entity", "type", this.publicationEntityType.getLabel()).build();
        this.person1 = ItemBuilder.createItem(this.context, this.collection).withTitle("person1").withMetadata("dspace", "entity", "type", this.personEntityType.getLabel()).build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testRelationshipLatestVersionStatusDefault() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship relationship1 = this.relationshipService.create(this.context, this.publication1, this.person1, this.relationshipType, 3, 5, "left", "right");
        this.context.restoreAuthSystemState();
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship1.getLatestVersionStatus());
        Relationship relationship2 = (Relationship)this.relationshipService.find(this.context, relationship1.getID().intValue());
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship2.getLatestVersionStatus());
        this.context.turnOffAuthorisationSystem();
        Relationship relationship3 = this.relationshipService.create(this.context, this.publication2, this.person1, this.relationshipType, 3, 5);
        this.context.restoreAuthSystemState();
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship3.getLatestVersionStatus());
        Relationship relationship4 = (Relationship)this.relationshipService.find(this.context, relationship3.getID().intValue());
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship4.getLatestVersionStatus());
        Relationship inputRelationship = new Relationship();
        inputRelationship.setLeftItem(this.publication3);
        inputRelationship.setRightItem(this.person1);
        inputRelationship.setRelationshipType(this.relationshipType);
        this.context.turnOffAuthorisationSystem();
        Relationship relationship5 = this.relationshipService.create(this.context, inputRelationship);
        this.context.restoreAuthSystemState();
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship5.getLatestVersionStatus());
        Relationship relationship6 = (Relationship)this.relationshipService.find(this.context, relationship5.getID().intValue());
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship6.getLatestVersionStatus());
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, (Object)relationship1);
        this.relationshipService.delete(this.context, (Object)relationship3);
        this.relationshipService.delete(this.context, (Object)relationship5);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testRelationshipLatestVersionStatusBoth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship relationship1 = this.relationshipService.create(this.context, this.publication1, this.person1, this.relationshipType, 3, 5, "left", "right", Relationship.LatestVersionStatus.BOTH);
        this.context.restoreAuthSystemState();
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship1.getLatestVersionStatus());
        Relationship relationship2 = (Relationship)this.relationshipService.find(this.context, relationship1.getID().intValue());
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship2.getLatestVersionStatus());
        Relationship inputRelationship = new Relationship();
        inputRelationship.setLeftItem(this.publication2);
        inputRelationship.setRightItem(this.person1);
        inputRelationship.setRelationshipType(this.relationshipType);
        inputRelationship.setLatestVersionStatus(Relationship.LatestVersionStatus.BOTH);
        this.context.turnOffAuthorisationSystem();
        Relationship relationship3 = this.relationshipService.create(this.context, inputRelationship);
        this.context.restoreAuthSystemState();
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship3.getLatestVersionStatus());
        Relationship relationship4 = (Relationship)this.relationshipService.find(this.context, relationship3.getID().intValue());
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.BOTH, (Object)relationship4.getLatestVersionStatus());
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, (Object)relationship1);
        this.relationshipService.delete(this.context, (Object)relationship3);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testRelationshipLatestVersionStatusLeftOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship relationship1 = this.relationshipService.create(this.context, this.publication1, this.person1, this.relationshipType, 3, 5, "left", "right", Relationship.LatestVersionStatus.LEFT_ONLY);
        this.context.restoreAuthSystemState();
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.LEFT_ONLY, (Object)relationship1.getLatestVersionStatus());
        Relationship relationship2 = (Relationship)this.relationshipService.find(this.context, relationship1.getID().intValue());
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.LEFT_ONLY, (Object)relationship2.getLatestVersionStatus());
        Relationship inputRelationship = new Relationship();
        inputRelationship.setLeftItem(this.publication2);
        inputRelationship.setRightItem(this.person1);
        inputRelationship.setRelationshipType(this.relationshipType);
        inputRelationship.setLatestVersionStatus(Relationship.LatestVersionStatus.LEFT_ONLY);
        this.context.turnOffAuthorisationSystem();
        Relationship relationship3 = this.relationshipService.create(this.context, inputRelationship);
        this.context.restoreAuthSystemState();
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.LEFT_ONLY, (Object)relationship3.getLatestVersionStatus());
        Relationship relationship4 = (Relationship)this.relationshipService.find(this.context, relationship3.getID().intValue());
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.LEFT_ONLY, (Object)relationship4.getLatestVersionStatus());
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, (Object)relationship1);
        this.relationshipService.delete(this.context, (Object)relationship3);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testRelationshipLatestVersionStatusRightOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship relationship1 = this.relationshipService.create(this.context, this.publication1, this.person1, this.relationshipType, 3, 5, "left", "right", Relationship.LatestVersionStatus.RIGHT_ONLY);
        this.context.restoreAuthSystemState();
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.RIGHT_ONLY, (Object)relationship1.getLatestVersionStatus());
        Relationship relationship2 = (Relationship)this.relationshipService.find(this.context, relationship1.getID().intValue());
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.RIGHT_ONLY, (Object)relationship2.getLatestVersionStatus());
        Relationship inputRelationship = new Relationship();
        inputRelationship.setLeftItem(this.publication2);
        inputRelationship.setRightItem(this.person1);
        inputRelationship.setRelationshipType(this.relationshipType);
        inputRelationship.setLatestVersionStatus(Relationship.LatestVersionStatus.RIGHT_ONLY);
        this.context.turnOffAuthorisationSystem();
        Relationship relationship3 = this.relationshipService.create(this.context, inputRelationship);
        this.context.restoreAuthSystemState();
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.RIGHT_ONLY, (Object)relationship3.getLatestVersionStatus());
        Relationship relationship4 = (Relationship)this.relationshipService.find(this.context, relationship3.getID().intValue());
        Assert.assertEquals((Object)Relationship.LatestVersionStatus.RIGHT_ONLY, (Object)relationship4.getLatestVersionStatus());
        this.context.turnOffAuthorisationSystem();
        this.relationshipService.delete(this.context, (Object)relationship1);
        this.relationshipService.delete(this.context, (Object)relationship3);
        this.context.restoreAuthSystemState();
    }

    protected void assertRelationship(Relationship expectedRelationship, List<Relationship> relationships) {
        Assert.assertNotNull(relationships);
        Assert.assertEquals((long)1L, (long)relationships.size());
        Assert.assertEquals((Object)expectedRelationship, (Object)relationships.get(0));
    }

    protected void assertNoRelationship(List<Relationship> relationships) {
        Assert.assertNotNull(relationships);
        Assert.assertEquals((long)0L, (long)relationships.size());
    }

    @Test
    public void testExcludeNonLatestBoth() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder(this.context, this.publication1, this.person1, this.relationshipType).withLatestVersionStatus(Relationship.LatestVersionStatus.BOTH).build();
        this.context.restoreAuthSystemState();
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, false, false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, false, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, false, false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, false, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, true, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), true));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, true));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.publication1));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.person1));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, -1, -1));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, -1, -1));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, -1, -1, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, -1, -1, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, -1, -1, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, -1, -1, true));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, -1, -1));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, -1, -1));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, -1, -1));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, -1, -1));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, -1, -1, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, -1, -1, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, -1, -1, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, -1, -1, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, -1, -1, true));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, -1, -1, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, true, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, true));
    }

    @Test
    public void testExcludeNonLatestLeftOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder(this.context, this.publication1, this.person1, this.relationshipType).withLatestVersionStatus(Relationship.LatestVersionStatus.LEFT_ONLY).build();
        this.context.restoreAuthSystemState();
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, false, false));
        this.assertNoRelationship(this.relationshipDAO.findByItem(this.context, this.publication1, false, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, false, false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, false, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertNoRelationship(this.relationshipDAO.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, true, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), true));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, true));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, true));
        this.assertNoRelationship(this.relationshipService.findByItem(this.context, this.publication1));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.person1));
        this.assertNoRelationship(this.relationshipService.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertNoRelationship(this.relationshipService.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, -1, -1));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, -1, -1));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, -1, -1, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, -1, -1, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, -1, -1, true));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, -1, -1));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, -1, -1));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, -1, -1));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, -1, -1));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, -1, -1, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, -1, -1, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, -1, -1, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, -1, -1, true));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, -1, -1, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItem(this.context, this.publication1));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItem(this.context, this.publication1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItem(this.context, this.publication1, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, true, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, true));
    }

    @Test
    public void testExcludeNonLatestRightOnly() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship relationship1 = RelationshipBuilder.createRelationshipBuilder(this.context, this.publication1, this.person1, this.relationshipType).withLatestVersionStatus(Relationship.LatestVersionStatus.RIGHT_ONLY).build();
        this.context.restoreAuthSystemState();
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, false, false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, false, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, false, false));
        this.assertNoRelationship(this.relationshipDAO.findByItem(this.context, this.person1, false, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertNoRelationship(this.relationshipDAO.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItem(this.context, this.person1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.publication1, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItem(this.context, this.person1, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItem(this.context, this.person1, true, true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertRelationship(relationship1, this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, Integer.valueOf(-1), Integer.valueOf(-1), true));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipDAO.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, Integer.valueOf(-1), Integer.valueOf(-1), true));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, true));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipDAO.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.publication1));
        this.assertNoRelationship(this.relationshipService.findByItem(this.context, this.person1));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertNoRelationship(this.relationshipService.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.publication1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, false));
        this.assertNoRelationship(this.relationshipService.findByItem(this.context, this.person1, Integer.valueOf(-1), Integer.valueOf(-1), false, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, -1, -1));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, -1, -1));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, -1, -1, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, -1, -1, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, -1, -1, true));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, -1, -1));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, -1, -1));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, -1, -1));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, -1, -1));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, -1, -1, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, -1, -1, false));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, -1, -1, true));
        this.assertRelationship(relationship1, this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, -1, -1, true));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, -1, -1, false));
        this.assertNoRelationship(this.relationshipService.findByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, -1, -1, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItem(this.context, this.person1));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, false, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItem(this.context, this.person1, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.publication1, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItem(this.context, this.person1, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItem(this.context, this.person1, true, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, false, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, false));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.publication1, this.relationshipType, true, true));
        Assert.assertEquals((long)1L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, false, true));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, false));
        Assert.assertEquals((long)0L, (long)this.relationshipService.countByItemAndRelationshipType(this.context, this.person1, this.relationshipType, true, true));
    }
}

