/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matcher;

import java.util.List;
import java.util.stream.Collectors;
import org.dspace.content.DSpaceObject;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Subscription;
import org.dspace.eperson.SubscriptionParameter;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class SubscribeMatcher
extends BaseMatcher<Subscription> {
    private final DSpaceObject dso;
    private final EPerson eperson;
    private final List<SubscriptionParameter> parameters;
    private final String type;

    private SubscribeMatcher(DSpaceObject dso, EPerson eperson, String type, List<SubscriptionParameter> parameters) {
        this.dso = dso;
        this.eperson = eperson;
        this.parameters = parameters;
        this.type = type;
    }

    public static SubscribeMatcher matches(DSpaceObject dso, EPerson ePerson, String type, List<SubscriptionParameter> parameters) {
        return new SubscribeMatcher(dso, ePerson, type, parameters);
    }

    public boolean matches(Object subscription) {
        Subscription s = (Subscription)subscription;
        return s.getEPerson().equals((Object)this.eperson) && s.getDSpaceObject().equals(this.dso) && s.getSubscriptionType().equals(this.type) && this.checkParameters(s.getSubscriptionParameterList()) != false;
    }

    private Boolean checkParameters(List<SubscriptionParameter> parameters) {
        if (parameters.size() != this.parameters.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            boolean differentValue;
            boolean differentName;
            SubscriptionParameter parameter = parameters.get(i);
            SubscriptionParameter match = this.parameters.get(i);
            boolean bl = differentName = !parameter.getName().equals(match.getName());
            if (differentName) {
                return false;
            }
            boolean bl2 = differentValue = !parameter.getValue().equals(match.getValue());
            if (!differentValue) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        String subscription = String.format("Type: %s, eperson: %s, dso: %s, params: %s", this.type, this.eperson.getID(), this.dso.getID(), this.parameters.stream().map(p -> "{ name: " + p.getName() + ", value: " + p.getValue() + "}").collect(Collectors.joining(", ")));
        description.appendText("Subscription matching: " + subscription);
    }
}

