/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.dspace.AbstractUnitTest;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamService;
import org.dspace.matomo.MatomoAsyncBulkRequestHandler;
import org.dspace.matomo.MatomoEventListener;
import org.dspace.matomo.MatomoSyncEventHandler;
import org.dspace.services.ConfigurationService;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MatomoEventListenerTest
extends AbstractUnitTest {
    @Mock
    MatomoAsyncBulkRequestHandler matomoHandler1;
    @Mock
    MatomoSyncEventHandler matomoHandler2;
    @Mock
    ConfigurationService configurationService;
    @Mock
    BitstreamService bitstreamService;
    MatomoEventListener matomoEventListener;

    @Before
    public void setUp() throws Exception {
        this.matomoEventListener = new MatomoEventListener(List.of(this.matomoHandler1, this.matomoHandler2), this.configurationService, this.bitstreamService);
    }

    @Test
    public void testDisabledMatomo() {
        UsageEvent event = (UsageEvent)Mockito.mock(UsageEvent.class);
        this.matomoEventListener.receiveEvent((Event)event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matomoHandler1});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matomoHandler2});
    }

    @Test
    public void testDontHandleGenericViewEventWithMatomoEnabled() {
        UsageEvent event = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)event.getAction()).thenReturn((Object)UsageEvent.Action.VIEW);
        Mockito.when((Object)event.getObject()).thenReturn((Object)((DSpaceObject)Mockito.spy(Item.class)));
        Mockito.when((Object)this.configurationService.getBooleanProperty("matomo.enabled", false)).thenReturn((Object)true);
        this.matomoEventListener.receiveEvent((Event)event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matomoHandler1});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matomoHandler2});
    }

    @Test
    public void testHandleBitstreamViewEvent() throws SQLException {
        UsageEvent event = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)event.getAction()).thenReturn((Object)UsageEvent.Action.VIEW);
        Bitstream bitstream = (Bitstream)Mockito.spy(Bitstream.class);
        Mockito.when((Object)this.bitstreamService.isInBundle((Bitstream)Mockito.eq((Object)bitstream), (Collection)Mockito.eq(Set.of("ORIGINAL")))).thenReturn((Object)true);
        Mockito.when((Object)event.getObject()).thenReturn((Object)bitstream);
        Mockito.when((Object)this.configurationService.getBooleanProperty((String)Mockito.eq((Object)"matomo.enabled"), Mockito.eq((boolean)false))).thenReturn((Object)true);
        Mockito.when((Object)this.configurationService.getArrayProperty((String)Mockito.eq((Object)"matomo.track.bundles"), (String[])Mockito.any())).thenReturn((Object)new String[0]);
        this.matomoEventListener.receiveEvent((Event)event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matomoHandler1});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.matomoHandler2});
        Mockito.when((Object)this.configurationService.getArrayProperty((String)Mockito.eq((Object)"matomo.track.bundles"), (String[])Mockito.any())).thenReturn((Object)new String[]{"none"});
        this.matomoEventListener.receiveEvent((Event)event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.matomoHandler1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.matomoHandler2});
        Mockito.when((Object)this.configurationService.getArrayProperty((String)Mockito.eq((Object)"matomo.track.bundles"), (String[])Mockito.any())).thenReturn((Object)new String[]{"ORIGINAL"});
        this.matomoEventListener.receiveEvent((Event)event);
        ((MatomoAsyncBulkRequestHandler)Mockito.verify((Object)this.matomoHandler1, (VerificationMode)Mockito.times((int)1))).handleEvent(event);
        ((MatomoSyncEventHandler)Mockito.verify((Object)this.matomoHandler2, (VerificationMode)Mockito.times((int)1))).handleEvent(event);
    }
}

