/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.client;

import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dspace.AbstractUnitTest;
import org.dspace.matomo.client.MatomoAbstractClient;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MatomoAbstractClientTest
extends AbstractUnitTest {
    @Test
    public void test_addCookies_singleCookie() {
        HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        LinkedHashMap<String, String> cookies = new LinkedHashMap<String, String>();
        cookies.put("testCookie", "testValue");
        MatomoAbstractClient.addCookies((HttpURLConnection)connection, cookies);
        ((HttpURLConnection)Mockito.verify((Object)connection)).setRequestProperty("Cookie", "testCookie=testValue");
    }

    @Test
    public void test_addCookies_withEmptyCookiesMap() {
        HttpURLConnection mockConnection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        LinkedHashMap cookies = new LinkedHashMap();
        MatomoAbstractClient.addCookies((HttpURLConnection)mockConnection, cookies);
        ((HttpURLConnection)Mockito.verify((Object)mockConnection, (VerificationMode)Mockito.never())).setRequestProperty(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void test_addCookies_withMultipleCookies() {
        MockHttpURLConnection mockConnection = new MockHttpURLConnection();
        HashMap<String, String> cookies = new HashMap<String, String>();
        cookies.put("cookie1", "value1");
        cookies.put("cookie2", "value2");
        MatomoAbstractClient.addCookies((HttpURLConnection)mockConnection, cookies);
        String cookieHeader = ((URLConnection)mockConnection).getRequestProperty("Cookie");
        MatcherAssert.assertThat((String)"Cookie header should contain both cookies", (Object)cookieHeader, (Matcher)Matchers.allOf((Matcher)Matchers.notNullValue(), (Matcher)Matchers.containsString((String)"cookie1=value1"), (Matcher)Matchers.containsString((String)"cookie2=value2")));
    }

    @Test
    public void test_addCookies_withNullCookiesMap() {
        HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Map cookies = null;
        MatomoAbstractClient.addCookies((HttpURLConnection)connection, cookies);
        ((HttpURLConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setRequestProperty(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void test_addCookies_withNullMapAndDefaultCookie() {
        HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Map cookies = null;
        MatomoAbstractClient.addCookies((HttpURLConnection)connection, cookies);
        ((HttpURLConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setRequestProperty((String)ArgumentMatchers.eq((Object)"Cookie"), Mockito.anyString());
        ((HttpURLConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).getRequestProperty((String)ArgumentMatchers.eq((Object)"Cookie"));
    }

    private static class MockHttpURLConnection
    extends HttpURLConnection {
        private Map<String, String> requestProperties = new HashMap<String, String>();

        protected MockHttpURLConnection() {
            super(null);
        }

        @Override
        public void setRequestProperty(String key, String value) {
            this.requestProperties.put(key, value);
        }

        @Override
        public String getRequestProperty(String key) {
            return this.requestProperties.get(key);
        }

        @Override
        public void disconnect() {
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void connect() {
        }
    }
}

