/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.client;

import java.util.List;
import org.dspace.AbstractUnitTest;
import org.dspace.matomo.client.MatomoBulkRequest;
import org.dspace.matomo.client.MatomoRequestBuilder;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;

public class MatomoRequestBuilderTest
extends AbstractUnitTest {
    MatomoRequestBuilder matomoRequestBuilder;

    @Before
    public void setUp() throws Exception {
        this.matomoRequestBuilder = new MatomoRequestBuilder();
    }

    @Test
    public void testNull() throws JSONException {
        this.matomoRequestBuilder = new MatomoRequestBuilder();
        String json = this.matomoRequestBuilder.buildJSON(null);
        MatcherAssert.assertThat((Object)json, (Matcher)Matchers.emptyOrNullString());
    }

    @Test
    public void testEmptyRequests() throws JSONException {
        this.matomoRequestBuilder = new MatomoRequestBuilder();
        String json = this.matomoRequestBuilder.buildJSON(new MatomoBulkRequest("my-token", List.of()));
        JSONObject jsonObject = new JSONObject(json);
        MatcherAssert.assertThat((Object)jsonObject.getString("token_auth"), (Matcher)Matchers.is((Object)"my-token"));
        MatcherAssert.assertThat((Object)jsonObject.has("requests"), (Matcher)Matchers.is((Object)true));
        JSONArray requests = jsonObject.getJSONArray("requests");
        MatcherAssert.assertThat((Object)requests, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)requests.length(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testNullRequests() throws JSONException {
        this.matomoRequestBuilder = new MatomoRequestBuilder();
        String json = this.matomoRequestBuilder.buildJSON(new MatomoBulkRequest("my-token", null));
        JSONObject jsonObject = new JSONObject(json);
        MatcherAssert.assertThat((Object)jsonObject.getString("token_auth"), (Matcher)Matchers.is((Object)"my-token"));
        MatcherAssert.assertThat((Object)jsonObject.has("requests"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSinglelRequest() throws JSONException {
        this.matomoRequestBuilder = new MatomoRequestBuilder();
        MatomoRequestDetails e1 = new MatomoRequestDetails().addParameter("rec", "1").addParameter("idsite", "1").addParameter("action_name", "my-action");
        String json = this.matomoRequestBuilder.buildJSON(new MatomoBulkRequest("my-token", List.of(e1)));
        JSONObject jsonObject = new JSONObject(json);
        MatcherAssert.assertThat((Object)jsonObject.getString("token_auth"), (Matcher)Matchers.is((Object)"my-token"));
        MatcherAssert.assertThat((Object)jsonObject.has("requests"), (Matcher)Matchers.is((Object)true));
        JSONArray jsonArray = jsonObject.getJSONArray("requests");
        MatcherAssert.assertThat((Object)jsonArray.length(), (Matcher)Matchers.is((Object)1));
        String requestUrl = jsonArray.getString(0);
        MatcherAssert.assertThat((Object)requestUrl, (Matcher)Matchers.startsWith((String)"?"));
        String[] parameters = requestUrl.substring(1).split("&");
        MatcherAssert.assertThat(List.of(parameters), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"rec=1", "idsite=1", "action_name=my-action"}));
    }

    @Test
    public void testMultipleRequests() throws JSONException {
        this.matomoRequestBuilder = new MatomoRequestBuilder();
        MatomoRequestDetails e1 = new MatomoRequestDetails().addParameter("rec", "1").addParameter("idsite", "1").addParameter("action_name", "my-first-action");
        MatomoRequestDetails e2 = new MatomoRequestDetails().addParameter("rec", "1").addParameter("idsite", "1").addParameter("action_name", "my-second-action");
        String json = this.matomoRequestBuilder.buildJSON(new MatomoBulkRequest("my-token", List.of(e1, e2)));
        JSONObject jsonObject = new JSONObject(json);
        MatcherAssert.assertThat((Object)jsonObject.getString("token_auth"), (Matcher)Matchers.is((Object)"my-token"));
        MatcherAssert.assertThat((Object)jsonObject.has("requests"), (Matcher)Matchers.is((Object)true));
        JSONArray jsonArray = jsonObject.getJSONArray("requests");
        MatcherAssert.assertThat((Object)jsonArray.length(), (Matcher)Matchers.is((Object)2));
        List list = jsonArray.toList();
        MatcherAssert.assertThat((Object)list.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)list, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{new UrlParameterMatcher("rec=1", "idsite=1", "action_name=my-second-action"), new UrlParameterMatcher("rec=1", "idsite=1", "action_name=my-first-action")}));
    }

    private static final class UrlParameterMatcher
    extends BaseMatcher<Object> {
        List<String> parameterList;

        public UrlParameterMatcher(String ... parameters) {
            this.parameterList = List.of(parameters);
        }

        public boolean matches(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            String s = (String)o;
            return this.parameterList.stream().allMatch(s::contains);
        }

        public void describeTo(Description description) {
            description.appendText("an UrlParameterMatcher with the following params: ").appendValue(this.parameterList);
        }
    }
}

