/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.matomo.model;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.dspace.AbstractUnitTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.matomo.factory.MatomoRequestCookieIdentifierEnricher;
import org.dspace.matomo.factory.MatomoRequestCookieSessionEnricher;
import org.dspace.matomo.factory.MatomoRequestCountryEnricher;
import org.dspace.matomo.factory.MatomoRequestCustomCookiesEnricher;
import org.dspace.matomo.factory.MatomoRequestCustomVariablesEnricher;
import org.dspace.matomo.factory.MatomoRequestDetailsEnricher;
import org.dspace.matomo.factory.MatomoRequestDetailsEnricherFactory;
import org.dspace.matomo.factory.MatomoRequestIpAddressEnricher;
import org.dspace.matomo.factory.MatomoRequestTrackerIdentifierParamEnricher;
import org.dspace.matomo.model.MatomoRequestDetails;
import org.dspace.matomo.model.MatomoRequestDetailsBuilder;
import org.dspace.service.ClientInfoService;
import org.dspace.usage.UsageEvent;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class MatomoRequestDetailsBuilderTest
extends AbstractUnitTest {
    MatomoRequestDetailsBuilder builder;
    List<MatomoRequestDetailsEnricher> enrichers;
    @Mock
    UsageEvent usageEvent;
    @Mock
    HttpServletRequest request;
    @Mock
    Context context;
    final String siteId = "test";

    @Before
    public void setUp() throws Exception {
        this.enrichers = new ArrayList<MatomoRequestDetailsEnricher>();
        this.builder = new MatomoRequestDetailsBuilder(this.enrichers, "test");
    }

    @Test
    public void testDefaultBuilders() {
        MatomoRequestDetails request = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)request.parameters, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)request.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"idsite"), (Matcher)Matchers.is((Object)"test")));
        MatcherAssert.assertThat((Object)request.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"rec"), (Matcher)Matchers.is((Object)"1")));
    }

    @Test
    public void testActionNameBuilder() throws SQLException {
        this.enrichers.add(MatomoRequestDetailsEnricherFactory.actionNameEnricher());
        Item item = (Item)Mockito.mock(Item.class);
        Mockito.when((Object)item.getName()).thenReturn((Object)"item-name");
        Mockito.when((Object)item.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.usageEvent.getObject()).thenReturn((Object)item);
        Mockito.when((Object)this.usageEvent.getContext()).thenReturn((Object)this.context);
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"action_name"), (Matcher)Matchers.is((Object)"item-name")));
        Bitstream bitstream = (Bitstream)Mockito.mock(Bitstream.class);
        Mockito.when((Object)bitstream.getType()).thenReturn((Object)0);
        Mockito.when((Object)this.usageEvent.getObject()).thenReturn((Object)bitstream);
        try (MockedStatic mock = Mockito.mockStatic(ContentServiceFactory.class);){
            ContentServiceFactory serviceFactory = (ContentServiceFactory)Mockito.mock(ContentServiceFactory.class);
            Mockito.when((Object)ContentServiceFactory.getInstance()).thenReturn((Object)serviceFactory);
            DSpaceObjectService bitstreamService = (DSpaceObjectService)Mockito.mock(BitstreamService.class);
            Mockito.when((Object)serviceFactory.getDSpaceObjectService((DSpaceObject)bitstream)).thenReturn((Object)bitstreamService);
            Mockito.when((Object)bitstreamService.getParentObject(this.context, (DSpaceObject)bitstream)).thenReturn((Object)item);
            requestDetails = this.builder.build(this.usageEvent);
            MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"action_name"), (Matcher)Matchers.is((Object)"item-name")));
        }
    }

    @Test
    public void testUserAgentEnricher() {
        this.enrichers.add(MatomoRequestDetailsEnricherFactory.userAgentEnricher());
        Mockito.when((Object)this.request.getHeader((String)Mockito.eq((Object)"USER-AGENT"))).thenReturn((Object)"custom-agent");
        Mockito.when((Object)this.usageEvent.getRequest()).thenReturn((Object)this.request);
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"ua"), (Matcher)Matchers.is((Object)"custom-agent")));
    }

    @Test
    public void testUrlEnricher() {
        this.enrichers.add(MatomoRequestDetailsEnricherFactory.urlEnricher());
        Item item = (Item)Mockito.mock(Item.class);
        Mockito.when((Object)item.getType()).thenReturn((Object)2);
        UUID itemUUID = UUID.randomUUID();
        Mockito.when((Object)item.getID()).thenReturn((Object)itemUUID);
        Mockito.when((Object)this.usageEvent.getObject()).thenReturn((Object)item);
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"url"), (Matcher)Matchers.containsString((String)("/items/" + itemUUID))));
        UUID bitstreamUUID = UUID.randomUUID();
        Bitstream bitstream = (Bitstream)Mockito.mock(Bitstream.class);
        Mockito.when((Object)bitstream.getID()).thenReturn((Object)bitstreamUUID);
        Mockito.when((Object)this.usageEvent.getObject()).thenReturn((Object)bitstream);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"url"), (Matcher)Matchers.containsString((String)("/bitstreams/" + bitstreamUUID))));
        UUID bundleUUID = UUID.randomUUID();
        DSpaceObject object = (DSpaceObject)Mockito.mock(Bundle.class);
        Mockito.when((Object)object.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.usageEvent.getObject()).thenReturn((Object)object);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"url"), (Matcher)Matchers.emptyString()));
        Mockito.when((Object)this.usageEvent.getObject()).thenReturn(null);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"url"), (Matcher)Matchers.emptyString()));
    }

    @Test
    public void testMatomoRequestCountryEnricher() {
        MatomoRequestCountryEnricher countryEnricher = new MatomoRequestCountryEnricher();
        this.enrichers.add((MatomoRequestDetailsEnricher)countryEnricher);
        String country = Locale.ITALIAN.getCountry();
        Mockito.when((Object)this.request.getLocale()).thenReturn((Object)Locale.ITALIAN);
        Mockito.when((Object)this.usageEvent.getRequest()).thenReturn((Object)this.request);
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"country"), (Matcher)Matchers.is((Object)country)));
        Mockito.when((Object)this.request.getLocale()).thenReturn(null);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"country"), (Matcher)Matchers.emptyString()));
        Mockito.when((Object)this.usageEvent.getRequest()).thenReturn(null);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"country"), (Matcher)Matchers.emptyString()));
    }

    @Test
    public void testMatomoIpEnricher() {
        ClientInfoService clientInfo = (ClientInfoService)Mockito.mock(ClientInfoService.class);
        MatomoRequestIpAddressEnricher ipAddressEnricher = new MatomoRequestIpAddressEnricher(clientInfo);
        this.enrichers.add((MatomoRequestDetailsEnricher)ipAddressEnricher);
        Mockito.when((Object)this.usageEvent.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)clientInfo.getClientIp(this.request)).thenReturn((Object)"fake-ip");
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"cip"), (Matcher)Matchers.is((Object)"fake-ip")));
        Mockito.when((Object)clientInfo.getClientIp(this.request)).thenReturn(null);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"cip"), (Matcher)Matchers.emptyString()));
        Mockito.when((Object)clientInfo.getClientIp(this.request)).thenReturn((Object)"");
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"cip"), (Matcher)Matchers.emptyString()));
    }

    @Test
    public void testDownloadEnricher() {
        this.enrichers.add(MatomoRequestDetailsEnricherFactory.downloadEnricher());
        Item item = (Item)Mockito.mock(Item.class);
        Mockito.when((Object)item.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.usageEvent.getObject()).thenReturn((Object)item);
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"download"), (Matcher)Matchers.emptyString()));
        UUID bitstreamUUID = UUID.randomUUID();
        Bitstream bitstream = (Bitstream)Mockito.mock(Bitstream.class);
        Mockito.when((Object)bitstream.getID()).thenReturn((Object)bitstreamUUID);
        Mockito.when((Object)this.usageEvent.getObject()).thenReturn((Object)bitstream);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"download"), (Matcher)Matchers.containsString((String)("/bitstreams/" + bitstreamUUID + "/download"))));
        Mockito.when((Object)this.usageEvent.getObject()).thenReturn(null);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"download"), (Matcher)Matchers.emptyString()));
    }

    @Test
    public void testMatomoCookieIdentifierEnricher() {
        MatomoRequestCookieIdentifierEnricher cookieEnricher = new MatomoRequestCookieIdentifierEnricher();
        this.enrichers.add((MatomoRequestDetailsEnricher)cookieEnricher);
        Cookie cookie = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)cookie.getName()).thenReturn((Object)"_pk_id.1.1fff");
        Mockito.when((Object)cookie.getValue()).thenReturn((Object)"3225aebdb98b13f9.1740076196.");
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        Mockito.when((Object)this.usageEvent.getRequest()).thenReturn((Object)this.request);
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_id"), (Matcher)Matchers.is((Object)"3225aebdb98b13f9")));
        Mockito.when((Object)this.request.getCookies()).thenReturn(null);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_id"), (Matcher)Matchers.any(String.class))));
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[0]);
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_id"), (Matcher)Matchers.any(String.class))));
        Mockito.when((Object)cookie.getName()).thenReturn((Object)"_pk_id.1.1fff");
        Mockito.when((Object)cookie.getValue()).thenReturn((Object)"wrongvalue.1.2");
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_id"), (Matcher)Matchers.any(String.class))));
        Mockito.when((Object)cookie.getName()).thenReturn((Object)"_pk_id.1.1fff");
        Mockito.when((Object)cookie.getValue()).thenReturn((Object)"");
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_id"), (Matcher)Matchers.any(String.class))));
    }

    @Test
    public void testMatomoCustomCookieEnricher() {
        MatomoRequestCustomCookiesEnricher cookiesEnricher = new MatomoRequestCustomCookiesEnricher("_pk_ref,_pk_hsr,_pk_ses");
        this.enrichers.add((MatomoRequestDetailsEnricher)cookiesEnricher);
        Cookie pkRefCookie = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)pkRefCookie.getName()).thenReturn((Object)"_pk_ref.1.1fff");
        Mockito.when((Object)pkRefCookie.getValue()).thenReturn((Object)"http://localhost/home");
        Cookie pkHsr = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)pkHsr.getName()).thenReturn((Object)"_pk_hsr.1.1fff");
        Mockito.when((Object)pkHsr.getValue()).thenReturn((Object)"hsr-value");
        Cookie pkSes = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)pkSes.getName()).thenReturn((Object)"_pk_ses.1.1fff");
        Mockito.when((Object)pkSes.getValue()).thenReturn((Object)"1");
        Cookie noCustom = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)noCustom.getName()).thenReturn((Object)"_pk_custom.1.1fff");
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{pkRefCookie, pkHsr, pkSes, noCustom});
        Mockito.when((Object)this.usageEvent.getRequest()).thenReturn((Object)this.request);
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.cookies, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_pk_ref.1.1fff"), (Matcher)Matchers.is((Object)"http://localhost/home")), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_pk_hsr.1.1fff"), (Matcher)Matchers.is((Object)"hsr-value")), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_pk_ses.1.1fff"), (Matcher)Matchers.is((Object)"1"))));
        MatcherAssert.assertThat((Object)requestDetails.cookies, (Matcher)Matchers.not((Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_pk_custom.1.1fff"), (Matcher)Matchers.any(String.class))));
    }

    @Test
    public void testMatomoCookieSessionEnricher() {
        MatomoRequestCookieSessionEnricher sessionEnricher = new MatomoRequestCookieSessionEnricher();
        this.enrichers.add((MatomoRequestDetailsEnricher)sessionEnricher);
        Cookie sessionCookie = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)sessionCookie.getName()).thenReturn((Object)"MATOMO_SESSID");
        Mockito.when((Object)sessionCookie.getValue()).thenReturn((Object)"44d4405e1652daa7a7e451c019cf01db");
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{sessionCookie});
        Mockito.when((Object)this.usageEvent.getRequest()).thenReturn((Object)this.request);
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.cookies, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"MATOMO_SESSID"), (Matcher)Matchers.is((Object)"44d4405e1652daa7a7e451c019cf01db")));
    }

    @Test
    public void testMatomoCustomVaribalesEnricher() {
        MatomoRequestCustomVariablesEnricher customVariablesEnricher = new MatomoRequestCustomVariablesEnricher();
        this.enrichers.add((MatomoRequestDetailsEnricher)customVariablesEnricher);
        Cookie cvar = (Cookie)Mockito.mock(Cookie.class);
        Mockito.when((Object)cvar.getName()).thenReturn((Object)"_pk_cvar.1.1fff");
        Mockito.when((Object)cvar.getValue()).thenReturn((Object)"{\"1\":[\"key1\",\"value1\"],\"2\":[\"key2\",\"value2\"]}");
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{cvar});
        Mockito.when((Object)this.usageEvent.getRequest()).thenReturn((Object)this.request);
        MatomoRequestDetails requestDetails = this.builder.build(this.usageEvent);
        MatcherAssert.assertThat((Object)requestDetails.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_cvar"), (Matcher)Matchers.is((Object)"{\"1\":[\"key1\",\"value1\"],\"2\":[\"key2\",\"value2\"]}")));
    }

    @Test
    public void testEnrichWithEmptyParameterMap() {
        MatomoRequestTrackerIdentifierParamEnricher enricher = new MatomoRequestTrackerIdentifierParamEnricher();
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)usageEvent.getRequest().getParameterMap()).thenReturn(new HashMap());
        MatomoRequestDetails result = enricher.enrich(usageEvent, matomoRequestDetails);
        Assert.assertEquals((Object)matomoRequestDetails, (Object)result);
    }

    @Test
    public void testEnrichWithInvalidTrackerId() {
        MatomoRequestTrackerIdentifierParamEnricher enricher = new MatomoRequestTrackerIdentifierParamEnricher();
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)((HttpServletRequest)Mockito.mock(HttpServletRequest.class)));
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("trackerId", new String[]{"invalidTrackerID"});
        Mockito.when((Object)usageEvent.getRequest().getParameterMap()).thenReturn(parameterMap);
        MatomoRequestDetails result = enricher.enrich(usageEvent, matomoRequestDetails);
        Assert.assertEquals((Object)matomoRequestDetails, (Object)result);
    }

    @Test
    public void testEnrichWithNullRequest() {
        MatomoRequestTrackerIdentifierParamEnricher enricher = new MatomoRequestTrackerIdentifierParamEnricher();
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        Mockito.when((Object)usageEvent.getRequest()).thenReturn(null);
        MatomoRequestDetails result = enricher.enrich(usageEvent, matomoRequestDetails);
        Assert.assertEquals((Object)matomoRequestDetails, (Object)result);
    }

    @Test
    public void testEnrichWithNullUsageEvent() {
        MatomoRequestTrackerIdentifierParamEnricher enricher = new MatomoRequestTrackerIdentifierParamEnricher();
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        MatomoRequestDetails result = enricher.enrich(null, matomoRequestDetails);
        Assert.assertEquals((Object)matomoRequestDetails, (Object)result);
    }

    @Test
    public void test_enrich_whenUsageEventIsNull() {
        MatomoRequestTrackerIdentifierParamEnricher enricher = new MatomoRequestTrackerIdentifierParamEnricher();
        MatomoRequestDetails matomoRequestDetails = (MatomoRequestDetails)Mockito.mock(MatomoRequestDetails.class);
        MatomoRequestDetails result = enricher.enrich(null, matomoRequestDetails);
        Assert.assertEquals((Object)matomoRequestDetails, (Object)result);
    }

    @Test
    public void test_enrich_withInvalidParameter() {
        MatomoRequestTrackerIdentifierParamEnricher enricher = new MatomoRequestTrackerIdentifierParamEnricher();
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("trackerId", new String[]{"invalidValue"});
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)request.getParameterMap()).thenReturn(parameterMap);
        MatomoRequestDetails result = enricher.enrich(usageEvent, matomoRequestDetails);
        Assert.assertEquals((Object)matomoRequestDetails, (Object)result);
    }

    @Test
    public void test_enrich_with_valid_tracker_id() {
        MatomoRequestTrackerIdentifierParamEnricher enricher = new MatomoRequestTrackerIdentifierParamEnricher();
        UsageEvent usageEvent = (UsageEvent)Mockito.mock(UsageEvent.class);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MatomoRequestDetails matomoRequestDetails = new MatomoRequestDetails();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("trackerId", new String[]{"1234567890abcdef"});
        Mockito.when((Object)usageEvent.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)request.getParameterMap()).thenReturn(parameterMap);
        MatomoRequestDetails result = enricher.enrich(usageEvent, matomoRequestDetails);
        MatcherAssert.assertThat((Object)result.parameters, (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"_id"), (Matcher)Matchers.is((Object)"1234567890abcdef")));
    }
}

