/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.validator;

import java.util.List;
import org.dspace.orcid.model.validator.OrcidValidationError;
import org.dspace.orcid.model.validator.impl.OrcidValidatorImpl;
import org.dspace.services.ConfigurationService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.orcid.jaxb.model.common.Iso3166Country;
import org.orcid.jaxb.model.common.Relationship;
import org.orcid.jaxb.model.common.WorkType;
import org.orcid.jaxb.model.v3.release.common.Amount;
import org.orcid.jaxb.model.v3.release.common.DisambiguatedOrganization;
import org.orcid.jaxb.model.v3.release.common.Organization;
import org.orcid.jaxb.model.v3.release.common.OrganizationAddress;
import org.orcid.jaxb.model.v3.release.common.PublicationDate;
import org.orcid.jaxb.model.v3.release.common.Title;
import org.orcid.jaxb.model.v3.release.common.Year;
import org.orcid.jaxb.model.v3.release.record.ExternalID;
import org.orcid.jaxb.model.v3.release.record.ExternalIDs;
import org.orcid.jaxb.model.v3.release.record.Funding;
import org.orcid.jaxb.model.v3.release.record.FundingTitle;
import org.orcid.jaxb.model.v3.release.record.Work;
import org.orcid.jaxb.model.v3.release.record.WorkTitle;

@RunWith(value=MockitoJUnitRunner.class)
public class OrcidValidatorTest {
    @Mock(lenient=true)
    private ConfigurationService configurationService;
    @InjectMocks
    private OrcidValidatorImpl validator;

    @Before
    public void before() {
        Mockito.when((Object)this.configurationService.getBooleanProperty("orcid.validation.work.enabled", true)).thenReturn((Object)true);
        Mockito.when((Object)this.configurationService.getBooleanProperty("orcid.validation.funding.enabled", true)).thenReturn((Object)true);
        Mockito.when((Object)this.configurationService.getArrayProperty("orcid.validation.organization.identifier-sources")).thenReturn((Object)new String[]{"RINGGOLD", "GRID", "FUNDREF", "LEI"});
    }

    @Test
    public void testWorkWithoutTitleAndTypeAndExternalIds() {
        List errors = this.validator.validateWork(new Work());
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED, OrcidValidationError.TYPE_REQUIRED, OrcidValidationError.EXTERNAL_ID_REQUIRED}));
    }

    @Test
    public void testWorkWithoutWorkTitle() {
        Work work = new Work();
        work.setWorkType(WorkType.DATA_SET);
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED}));
    }

    @Test
    public void testWorkWithoutTitle() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.setWorkType(WorkType.DATA_SET);
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED}));
    }

    @Test
    public void testWorkWithNullTitle() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.getWorkTitle().setTitle(new Title(null));
        work.setWorkType(WorkType.DATA_SET);
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED}));
    }

    @Test
    public void testWorkWithEmptyTitle() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.getWorkTitle().setTitle(new Title(""));
        work.setWorkType(WorkType.DATA_SET);
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED}));
    }

    @Test
    public void testWorkWithoutType() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.getWorkTitle().setTitle(new Title("Work title"));
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TYPE_REQUIRED}));
    }

    @Test
    public void testWorkWithoutExternalIds() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.getWorkTitle().setTitle(new Title("Work title"));
        work.setWorkType(WorkType.DATA_SET);
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.EXTERNAL_ID_REQUIRED}));
    }

    @Test
    public void testWorkWithEmptyExternalIds() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.getWorkTitle().setTitle(new Title("Work title"));
        work.setWorkType(WorkType.DATA_SET);
        work.setWorkExternalIdentifiers(new ExternalIDs());
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.EXTERNAL_ID_REQUIRED}));
    }

    @Test
    public void testdWorkWithPublicationDateWithoutYear() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.setWorkType(WorkType.DATA_SET);
        work.getWorkTitle().setTitle(new Title("Work title"));
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        PublicationDate publicationDate = new PublicationDate();
        work.setPublicationDate(publicationDate);
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.PUBLICATION_DATE_INVALID}));
    }

    @Test
    public void testdWorkWithPublicationDateWithInvalidYear() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.setWorkType(WorkType.DATA_SET);
        work.getWorkTitle().setTitle(new Title("Work title"));
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        PublicationDate publicationDate = new PublicationDate();
        Year year = new Year();
        year.setValue("INVALID");
        publicationDate.setYear(year);
        work.setPublicationDate(publicationDate);
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.PUBLICATION_DATE_INVALID}));
    }

    @Test
    public void testdWorkWithPublicationDateWithYearPriorTo1900() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.setWorkType(WorkType.DATA_SET);
        work.getWorkTitle().setTitle(new Title("Work title"));
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        PublicationDate publicationDate = new PublicationDate();
        publicationDate.setYear(new Year(Integer.valueOf(1850)));
        work.setPublicationDate(publicationDate);
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.PUBLICATION_DATE_INVALID}));
    }

    @Test
    public void testValidWork() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.setWorkType(WorkType.DATA_SET);
        work.getWorkTitle().setTitle(new Title("Work title"));
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        PublicationDate publicationDate = new PublicationDate();
        publicationDate.setYear(new Year(Integer.valueOf(1956)));
        work.setPublicationDate(publicationDate);
        List errors = this.validator.validateWork(work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testFundingWithoutTitleAndExternalIdsAndOrganization() {
        List errors = this.validator.validateFunding(new Funding());
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.EXTERNAL_ID_REQUIRED, OrcidValidationError.FUNDER_REQUIRED, OrcidValidationError.TITLE_REQUIRED}));
    }

    @Test
    public void testFundingWithoutExternalIdsAndOrganization() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Funding title"));
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.EXTERNAL_ID_REQUIRED, OrcidValidationError.FUNDER_REQUIRED}));
    }

    @Test
    public void testFundingWithoutTitleAndOrganization() {
        Funding funding = new Funding();
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED, OrcidValidationError.FUNDER_REQUIRED}));
    }

    @Test
    public void testFundingWithoutTitleAndExternalIds() {
        Funding funding = new Funding();
        funding.setOrganization(this.buildValidOrganization());
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED, OrcidValidationError.EXTERNAL_ID_REQUIRED}));
    }

    @Test
    public void testFundingWithoutTitle() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        funding.setOrganization(this.buildValidOrganization());
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED}));
    }

    @Test
    public void testFundingWithNullTitle() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title(null));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        funding.setOrganization(this.buildValidOrganization());
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED}));
    }

    @Test
    public void testFundingWithEmptyTitle() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title(""));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        funding.setOrganization(this.buildValidOrganization());
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED}));
    }

    @Test
    public void testFundingWithEmptyExternalIds() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.setOrganization(this.buildValidOrganization());
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.EXTERNAL_ID_REQUIRED}));
    }

    @Test
    public void testFundingWithOrganizationWithoutName() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        Organization organization = this.buildValidOrganization();
        organization.setName(null);
        funding.setOrganization(organization);
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.ORGANIZATION_NAME_REQUIRED}));
    }

    @Test
    public void testFundingWithOrganizationWithEmptyName() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        Organization organization = this.buildValidOrganization();
        organization.setName("");
        funding.setOrganization(organization);
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.ORGANIZATION_NAME_REQUIRED}));
    }

    @Test
    public void testFundingWithOrganizationWithoutAddress() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        Organization organization = this.buildValidOrganization();
        organization.setAddress(null);
        funding.setOrganization(organization);
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.ORGANIZATION_ADDRESS_REQUIRED}));
    }

    @Test
    public void testFundingWithOrganizationWithoutCity() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        Organization organization = this.buildValidOrganization();
        organization.getAddress().setCity(null);
        funding.setOrganization(organization);
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.ORGANIZATION_CITY_REQUIRED}));
    }

    @Test
    public void testFundingWithOrganizationWithoutCountry() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        Organization organization = this.buildValidOrganization();
        organization.getAddress().setCountry(null);
        funding.setOrganization(organization);
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.ORGANIZATION_COUNTRY_REQUIRED}));
    }

    @Test
    public void testFundingWithOrganizationWithoutDisambiguatedOrganization() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        Organization organization = this.buildValidOrganization();
        organization.setDisambiguatedOrganization(null);
        funding.setOrganization(organization);
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.DISAMBIGUATED_ORGANIZATION_REQUIRED}));
    }

    @Test
    public void testFundingWithOrganizationWithoutDisambiguatedOrganizationId() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        Organization organization = this.buildValidOrganization();
        organization.getDisambiguatedOrganization().setDisambiguatedOrganizationIdentifier(null);
        funding.setOrganization(organization);
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.DISAMBIGUATED_ORGANIZATION_VALUE_REQUIRED}));
    }

    @Test
    public void testFundingWithOrganizationWithoutDisambiguatedOrganizationSource() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        Organization organization = this.buildValidOrganization();
        organization.getDisambiguatedOrganization().setDisambiguationSource(null);
        funding.setOrganization(organization);
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.DISAMBIGUATION_SOURCE_REQUIRED}));
    }

    @Test
    public void testFundingWithOrganizationWithInvalidDisambiguationSource() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        Organization organization = this.buildValidOrganization();
        organization.getDisambiguatedOrganization().setDisambiguationSource("INVALID");
        funding.setOrganization(organization);
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.DISAMBIGUATION_SOURCE_INVALID}));
    }

    @Test
    public void testFundingWithoutAmountCurrency() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        funding.setOrganization(this.buildValidOrganization());
        funding.setAmount(new Amount());
        funding.getAmount().setContent("20000");
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.AMOUNT_CURRENCY_REQUIRED}));
    }

    @Test
    public void testValidFunding() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title("Title"));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        funding.setOrganization(this.buildValidOrganization());
        List errors = this.validator.validateFunding(funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testWithWorkValidationEnabled() {
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.getWorkTitle().setTitle(new Title("Work title"));
        work.setWorkExternalIdentifiers(new ExternalIDs());
        work.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        List errors = this.validator.validate((Object)work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TYPE_REQUIRED}));
    }

    @Test
    public void testWithWorkValidationDisabled() {
        Mockito.when((Object)this.configurationService.getBooleanProperty("orcid.validation.work.enabled", true)).thenReturn((Object)false);
        Work work = new Work();
        work.setWorkTitle(new WorkTitle());
        work.getWorkTitle().setTitle(new Title("Work title"));
        List errors = this.validator.validate((Object)work);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.empty());
    }

    @Test
    public void testWithFundingValidationEnabled() {
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title(""));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        funding.setOrganization(this.buildValidOrganization());
        List errors = this.validator.validate((Object)funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.containsInAnyOrder((Object[])new OrcidValidationError[]{OrcidValidationError.TITLE_REQUIRED}));
    }

    @Test
    public void testWithFundingValidationDisabled() {
        Mockito.when((Object)this.configurationService.getBooleanProperty("orcid.validation.funding.enabled", true)).thenReturn((Object)false);
        Funding funding = new Funding();
        funding.setTitle(new FundingTitle());
        funding.getTitle().setTitle(new Title(""));
        funding.setExternalIdentifiers(new ExternalIDs());
        funding.getExternalIdentifiers().getExternalIdentifier().add(this.buildValidExternalID());
        funding.setOrganization(this.buildValidOrganization());
        List errors = this.validator.validate((Object)funding);
        MatcherAssert.assertThat((Object)errors, (Matcher)Matchers.empty());
    }

    private ExternalID buildValidExternalID() {
        ExternalID externalID = new ExternalID();
        externalID.setRelationship(Relationship.SELF);
        externalID.setType("TYPE");
        externalID.setValue("VALUE");
        return externalID;
    }

    private Organization buildValidOrganization() {
        Organization organization = new Organization();
        organization.setName("Organization");
        OrganizationAddress address = new OrganizationAddress();
        address.setCity("City");
        address.setCountry(Iso3166Country.BA);
        organization.setAddress(address);
        DisambiguatedOrganization disambiguatedOrganization = new DisambiguatedOrganization();
        disambiguatedOrganization.setDisambiguatedOrganizationIdentifier("ID");
        disambiguatedOrganization.setDisambiguationSource("LEI");
        organization.setDisambiguatedOrganization(disambiguatedOrganization);
        return organization;
    }
}

