/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.util.XMLUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StructBuilder {
    static final String INPUT_ROOT = "import_structure";
    static final String RESULT_ROOT = "imported_structure";
    private static final Map<String, MetadataFieldName> collectionMap = new HashMap<String, MetadataFieldName>();
    private static final Map<String, MetadataFieldName> communityMap = new HashMap<String, MetadataFieldName>();
    protected static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected static final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    private StructBuilder() {
    }

    public static void main(String[] argv) throws ParserConfigurationException, SQLException, IOException, TransformerException, XPathExpressionException {
        String output;
        Options options = new Options();
        options.addOption("h", "help", false, "Print this help message.");
        options.addOption("?", "help");
        options.addOption("x", "export", false, "Export the current structure as XML.");
        options.addOption("k", "keep-handles", false, "Apply Handles from input document.");
        options.addOption(Option.builder((String)"e").longOpt("eperson").desc("User who is manipulating the repository's structure.").hasArg().argName("eperson").required().build());
        options.addOption(Option.builder((String)"f").longOpt("file").desc("File of new structure information.").hasArg().argName("input").build());
        options.addOption(Option.builder((String)"o").longOpt("output").desc("File to receive the structure map ('-' for standard out).").hasArg().argName("output").required().build());
        DefaultParser parser = new DefaultParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, argv);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            StructBuilder.usage(options);
            System.exit(1);
        }
        if (line.hasOption('h') || line.hasOption('?')) {
            StructBuilder.giveHelp(options);
            System.exit(0);
        }
        if (!line.hasOption('f') && !line.hasOption('x')) {
            StructBuilder.giveHelp(options);
            System.exit(1);
        }
        OutputStream outputStream = "-".equals(output = line.getOptionValue('o')) ? System.out : new FileOutputStream(output);
        Context context = new Context();
        String eperson = line.getOptionValue('e');
        try {
            context.setCurrentUser(ePersonService.findByEmail(context, eperson));
        }
        catch (SQLException ex) {
            System.err.format("That user could not be found:  %s%n", ex.getMessage());
            System.exit(1);
        }
        if (line.hasOption('x')) {
            StructBuilder.exportStructure(context, outputStream);
            outputStream.close();
        } else {
            String input = line.getOptionValue('f');
            if (null == input) {
                StructBuilder.usage(options);
                System.exit(1);
            }
            InputStream inputStream = "-".equals(input) ? System.in : new FileInputStream(input);
            boolean keepHandles = options.hasOption("k");
            StructBuilder.importStructure(context, inputStream, outputStream, keepHandles);
            inputStream.close();
            outputStream.close();
            context.complete();
        }
        System.exit(0);
    }

    static void importStructure(Context context, InputStream input, OutputStream output, boolean keepHandles) throws IOException, ParserConfigurationException, SQLException, TransformerException, XPathExpressionException {
        org.w3c.dom.Document document = null;
        try {
            document = StructBuilder.loadXML(input);
        }
        catch (IOException ex) {
            System.err.format("The input document could not be read:  %s%n", ex.getMessage());
            System.exit(1);
        }
        catch (SAXException ex) {
            System.err.format("The input document could not be parsed:  %s%n", ex.getMessage());
            System.exit(1);
        }
        try {
            StructBuilder.validate(document);
        }
        catch (XPathExpressionException ex) {
            System.err.format("The input document is invalid:  %s%n", ex.getMessage());
            System.exit(1);
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList identifierNodes = (NodeList)xPath.compile("//*[@identifier]").evaluate(document, XPathConstants.NODESET);
        if (identifierNodes.getLength() > 0) {
            if (!keepHandles) {
                System.err.println("The input document has 'identifier' attributes, which will be ignored.");
            } else {
                for (int i = 0; i < identifierNodes.getLength(); ++i) {
                    String identifier = identifierNodes.item(i).getAttributes().item(0).getTextContent();
                    if (handleService.resolveToURL(context, identifier) == null) continue;
                    System.err.printf("The input document contains handle %s, which is in use already. Aborting...%n", identifier);
                    System.exit(1);
                }
            }
        }
        communityMap.put("name", DSpaceObjectService.MD_NAME);
        communityMap.put("description", DSpaceObjectService.MD_SHORT_DESCRIPTION);
        communityMap.put("intro", DSpaceObjectService.MD_INTRODUCTORY_TEXT);
        communityMap.put("copyright", DSpaceObjectService.MD_COPYRIGHT_TEXT);
        communityMap.put("sidebar", DSpaceObjectService.MD_SIDEBAR_TEXT);
        collectionMap.put("name", DSpaceObjectService.MD_NAME);
        collectionMap.put("description", DSpaceObjectService.MD_SHORT_DESCRIPTION);
        collectionMap.put("intro", DSpaceObjectService.MD_INTRODUCTORY_TEXT);
        collectionMap.put("copyright", DSpaceObjectService.MD_COPYRIGHT_TEXT);
        collectionMap.put("sidebar", DSpaceObjectService.MD_SIDEBAR_TEXT);
        collectionMap.put("license", DSpaceObjectService.MD_LICENSE);
        collectionMap.put("provenance", DSpaceObjectService.MD_PROVENANCE_DESCRIPTION);
        Element[] elements = new Element[]{};
        try {
            NodeList first = (NodeList)xPath.compile("/import_structure/community").evaluate(document, XPathConstants.NODESET);
            elements = StructBuilder.handleCommunities(context, first, null, keepHandles);
        }
        catch (TransformerException ex) {
            System.err.format("Input content not understood:  %s%n", ex.getMessage());
            System.exit(1);
        }
        catch (AuthorizeException ex) {
            System.err.format("Not authorized:  %s%n", ex.getMessage());
            System.exit(1);
        }
        Element root = new Element(RESULT_ROOT);
        for (Element element : elements) {
            root.addContent((Content)element);
        }
        Document xmlOutput = new Document(root);
        try {
            new XMLOutputter().output(xmlOutput, output);
        }
        catch (IOException e) {
            System.out.printf("Unable to write to output file %s:  %s%n", output, e.getMessage());
            System.exit(1);
        }
    }

    private static Element exportACommunity(Community community) {
        Element element = new Element("community");
        element.setAttribute("identifier", community.getHandle());
        element.addContent((Content)new Element("name").setText(community.getName()));
        element.addContent((Content)new Element("description").setText(communityService.getMetadataFirstValue(community, MetadataSchemaEnum.DC.getName(), "description", "abstract", "*")));
        element.addContent((Content)new Element("intro").setText(communityService.getMetadataFirstValue(community, MetadataSchemaEnum.DC.getName(), "description", null, "*")));
        element.addContent((Content)new Element("copyright").setText(communityService.getMetadataFirstValue(community, MetadataSchemaEnum.DC.getName(), "rights", null, "*")));
        element.addContent((Content)new Element("sidebar").setText(communityService.getMetadataFirstValue(community, MetadataSchemaEnum.DC.getName(), "description", "tableofcontents", "*")));
        for (Community subCommunity : community.getSubcommunities()) {
            element.addContent((Content)StructBuilder.exportACommunity(subCommunity));
        }
        for (Collection collection : community.getCollections()) {
            element.addContent((Content)StructBuilder.exportACollection(collection));
        }
        return element;
    }

    private static Element exportACollection(Collection collection) {
        Element element = new Element("collection");
        element.setAttribute("identifier", collection.getHandle());
        element.addContent((Content)new Element("name").setText(collection.getName()));
        element.addContent((Content)new Element("description").setText(collectionService.getMetadataFirstValue(collection, MetadataSchemaEnum.DC.getName(), "description", "abstract", "*")));
        element.addContent((Content)new Element("intro").setText(collectionService.getMetadataFirstValue(collection, MetadataSchemaEnum.DC.getName(), "description", null, "*")));
        element.addContent((Content)new Element("copyright").setText(collectionService.getMetadataFirstValue(collection, MetadataSchemaEnum.DC.getName(), "rights", null, "*")));
        element.addContent((Content)new Element("sidebar").setText(collectionService.getMetadataFirstValue(collection, MetadataSchemaEnum.DC.getName(), "description", "tableofcontents", "*")));
        element.addContent((Content)new Element("license").setText(collectionService.getMetadataFirstValue(collection, MetadataSchemaEnum.DC.getName(), "rights", "license", "*")));
        for (MetadataValue value : collectionService.getMetadata(collection, MetadataSchemaEnum.DC.getName(), "provenance", null, "*")) {
            element.addContent((Content)new Element("provenance").setText(value.getValue()));
        }
        return element;
    }

    static void exportStructure(Context context, OutputStream output) {
        Element rootElement = new Element(INPUT_ROOT);
        List<Community> communities = null;
        try {
            communities = communityService.findAllTop(context);
        }
        catch (SQLException ex) {
            System.out.printf("Unable to get the list of top-level communities:  %s%n", ex.getMessage());
            System.exit(1);
        }
        for (Community community : communities) {
            rootElement.addContent((Content)StructBuilder.exportACommunity(community));
        }
        Document xmlOutput = new Document(rootElement);
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(xmlOutput, output);
        }
        catch (IOException e) {
            System.out.printf("Unable to write to output file %s:  %s%n", output, e.getMessage());
            System.exit(1);
        }
    }

    private static void usage(Options options) {
        HelpFormatter helper = new HelpFormatter();
        try (PrintWriter writer = new PrintWriter(System.out);){
            helper.printUsage(writer, 80, "structure-builder", options);
        }
    }

    private static void giveHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("struct-builder", "Import or export Community/Collection structure.", options, "When importing (-f), communities will be created from the top level, and a map of communities to handles will be returned in the output file.  When exporting (-x),the current structure will be written to the map file.", true);
    }

    private static void validate(org.w3c.dom.Document document) throws XPathExpressionException {
        String errs;
        StringBuilder err = new StringBuilder();
        boolean trip = false;
        err.append("The following errors were encountered parsing the source XML.\n");
        err.append("No changes have been made to the DSpace instance.\n\n");
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList first = (NodeList)xPath.compile("/import_structure/community").evaluate(document, XPathConstants.NODESET);
        if (first.getLength() == 0) {
            err.append("-There are no top level communities in the source document.");
            System.out.println(err.toString());
            System.exit(1);
        }
        if ((errs = StructBuilder.validateCommunities(first, 1)) != null) {
            err.append(errs);
            trip = true;
        }
        if (trip) {
            System.out.println(err.toString());
            System.exit(1);
        }
    }

    private static String validateCommunities(NodeList communities, int level) throws XPathExpressionException {
        StringBuilder err = new StringBuilder();
        boolean trip = false;
        String errs = null;
        XPath xPath = XPathFactory.newInstance().newXPath();
        for (int i = 0; i < communities.getLength(); ++i) {
            NodeList collections;
            String colErrs;
            NodeList subCommunities;
            String comErrs;
            Node n = communities.item(i);
            NodeList name = (NodeList)xPath.compile("name").evaluate(n, XPathConstants.NODESET);
            if (name.getLength() != 1) {
                String pos = Integer.toString(i + 1);
                err.append("-The level ").append(level).append(" community in position ").append(pos).append(" does not contain exactly one name field.\n");
                trip = true;
            }
            if ((comErrs = StructBuilder.validateCommunities(subCommunities = (NodeList)xPath.compile("community").evaluate(n, XPathConstants.NODESET), level + 1)) != null) {
                err.append(comErrs);
                trip = true;
            }
            if ((colErrs = StructBuilder.validateCollections(collections = (NodeList)xPath.compile("collection").evaluate(n, XPathConstants.NODESET), level + 1)) == null) continue;
            err.append(colErrs);
            trip = true;
        }
        if (trip) {
            errs = err.toString();
        }
        return errs;
    }

    private static String validateCollections(NodeList collections, int level) throws XPathExpressionException {
        StringBuilder err = new StringBuilder();
        boolean trip = false;
        String errs = null;
        XPath xPath = XPathFactory.newInstance().newXPath();
        for (int i = 0; i < collections.getLength(); ++i) {
            Node n = collections.item(i);
            NodeList name = (NodeList)xPath.compile("name").evaluate(n, XPathConstants.NODESET);
            if (name.getLength() == 1) continue;
            String pos = Integer.toString(i + 1);
            err.append("-The level ").append(level).append(" collection in position ").append(pos).append(" does not contain exactly one name field.\n");
            trip = true;
        }
        if (trip) {
            errs = err.toString();
        }
        return errs;
    }

    private static org.w3c.dom.Document loadXML(InputStream input) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = XMLUtils.getTrustedDocumentBuilder(new String[0]);
        org.w3c.dom.Document document = builder.parse(input);
        return document;
    }

    private static String getStringValue(Node node) {
        Node first;
        String value = node.getNodeValue();
        if (node.hasChildNodes() && (first = node.getFirstChild()).getNodeType() == 3) {
            return first.getNodeValue().trim();
        }
        return value;
    }

    private static Element[] handleCommunities(Context context, NodeList communities, Community parent, boolean keepHandles) throws TransformerException, SQLException, AuthorizeException, XPathExpressionException {
        Element[] elements = new Element[communities.getLength()];
        XPath xPath = XPathFactory.newInstance().newXPath();
        for (int i = 0; i < communities.getLength(); ++i) {
            int j;
            Node tn = communities.item(i);
            Node identifier = tn.getAttributes().getNamedItem("identifier");
            Community community = null == identifier || StringUtils.isBlank((CharSequence)identifier.getNodeValue()) || !keepHandles ? communityService.create(parent, context) : communityService.create(parent, context, identifier.getNodeValue());
            communityService.setMetadataSingleValue(context, community, DSpaceObjectService.MD_SHORT_DESCRIPTION, null, " ");
            for (Map.Entry<String, MetadataFieldName> entry : communityMap.entrySet()) {
                NodeList nl = (NodeList)xPath.compile(entry.getKey()).evaluate(tn, XPathConstants.NODESET);
                if (nl.getLength() != 1) continue;
                communityService.setMetadataSingleValue(context, community, entry.getValue(), null, StructBuilder.getStringValue(nl.item(0)));
            }
            communityService.update(context, community);
            Element element = new Element("community");
            element.setAttribute("identifier", community.getHandle());
            Element nameElement = new Element("name");
            nameElement.setText(communityService.getMetadataFirstValue(community, CommunityService.MD_NAME, "*"));
            element.addContent((Content)nameElement);
            String fieldValue = communityService.getMetadataFirstValue(community, CommunityService.MD_SHORT_DESCRIPTION, "*");
            if (fieldValue != null) {
                Element descriptionElement = new Element("description");
                descriptionElement.setText(fieldValue);
                element.addContent((Content)descriptionElement);
            }
            if ((fieldValue = communityService.getMetadataFirstValue(community, CommunityService.MD_INTRODUCTORY_TEXT, "*")) != null) {
                Element introElement = new Element("intro");
                introElement.setText(fieldValue);
                element.addContent((Content)introElement);
            }
            if ((fieldValue = communityService.getMetadataFirstValue(community, CommunityService.MD_COPYRIGHT_TEXT, "*")) != null) {
                Element copyrightElement = new Element("copyright");
                copyrightElement.setText(fieldValue);
                element.addContent((Content)copyrightElement);
            }
            if ((fieldValue = communityService.getMetadataFirstValue(community, CommunityService.MD_SIDEBAR_TEXT, "*")) != null) {
                Element sidebarElement = new Element("sidebar");
                sidebarElement.setText(fieldValue);
                element.addContent((Content)sidebarElement);
            }
            NodeList subCommunities = (NodeList)xPath.compile("community").evaluate(tn, XPathConstants.NODESET);
            Element[] subCommunityElements = StructBuilder.handleCommunities(context, subCommunities, community, keepHandles);
            NodeList collections = (NodeList)xPath.compile("collection").evaluate(tn, XPathConstants.NODESET);
            Element[] collectionElements = StructBuilder.handleCollections(context, collections, community, keepHandles);
            for (j = 0; j < subCommunityElements.length; ++j) {
                element.addContent((Content)subCommunityElements[j]);
            }
            for (j = 0; j < collectionElements.length; ++j) {
                element.addContent((Content)collectionElements[j]);
            }
            elements[i] = element;
        }
        return elements;
    }

    private static Element[] handleCollections(Context context, NodeList collections, Community parent, boolean keepHandles) throws SQLException, AuthorizeException, XPathExpressionException {
        Element[] elements = new Element[collections.getLength()];
        XPath xPath = XPathFactory.newInstance().newXPath();
        for (int i = 0; i < collections.getLength(); ++i) {
            Element sidebarElement;
            Node tn = collections.item(i);
            Node identifier = tn.getAttributes().getNamedItem("identifier");
            Collection collection = null == identifier || StringUtils.isBlank((CharSequence)identifier.getNodeValue()) || !keepHandles ? collectionService.create(context, parent) : collectionService.create(context, parent, identifier.getNodeValue());
            collectionService.setMetadataSingleValue(context, collection, DSpaceObjectService.MD_SHORT_DESCRIPTION, null, " ");
            for (Map.Entry<String, MetadataFieldName> entry : collectionMap.entrySet()) {
                NodeList nl = (NodeList)xPath.compile(entry.getKey()).evaluate(tn, XPathConstants.NODESET);
                if (nl.getLength() != 1) continue;
                collectionService.setMetadataSingleValue(context, collection, entry.getValue(), null, StructBuilder.getStringValue(nl.item(0)));
            }
            collectionService.update(context, collection);
            Element element = new Element("collection");
            element.setAttribute("identifier", collection.getHandle());
            Element nameElement = new Element("name");
            nameElement.setText(collectionService.getMetadataFirstValue(collection, CollectionService.MD_NAME, "*"));
            element.addContent((Content)nameElement);
            String fieldValue = collectionService.getMetadataFirstValue(collection, CollectionService.MD_SHORT_DESCRIPTION, "*");
            if (fieldValue != null) {
                Element descriptionElement = new Element("description");
                descriptionElement.setText(fieldValue);
                element.addContent((Content)descriptionElement);
            }
            if ((fieldValue = collectionService.getMetadataFirstValue(collection, CollectionService.MD_INTRODUCTORY_TEXT, "*")) != null) {
                Element introElement = new Element("intro");
                introElement.setText(fieldValue);
                element.addContent((Content)introElement);
            }
            if ((fieldValue = collectionService.getMetadataFirstValue(collection, CollectionService.MD_COPYRIGHT_TEXT, "*")) != null) {
                Element copyrightElement = new Element("copyright");
                copyrightElement.setText(fieldValue);
                element.addContent((Content)copyrightElement);
            }
            if ((fieldValue = collectionService.getMetadataFirstValue(collection, CollectionService.MD_SIDEBAR_TEXT, "*")) != null) {
                sidebarElement = new Element("sidebar");
                sidebarElement.setText(fieldValue);
                element.addContent((Content)sidebarElement);
            }
            if ((fieldValue = collectionService.getMetadataFirstValue(collection, CollectionService.MD_LICENSE, "*")) != null) {
                sidebarElement = new Element("license");
                sidebarElement.setText(fieldValue);
                element.addContent((Content)sidebarElement);
            }
            if ((fieldValue = collectionService.getMetadataFirstValue(collection, CollectionService.MD_PROVENANCE_DESCRIPTION, "*")) != null) {
                sidebarElement = new Element("provenance");
                sidebarElement.setText(fieldValue);
                element.addContent((Content)sidebarElement);
            }
            elements[i] = element;
        }
        return elements;
    }
}

