/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dspace.app.mediafilter.MediaFilterScript;
import org.dspace.scripts.configuration.ScriptConfiguration;

public class MediaFilterScriptConfiguration<T extends MediaFilterScript>
extends ScriptConfiguration<T> {
    private Class<T> dspaceRunnableClass;
    private static final String MEDIA_FILTER_PLUGINS_KEY = "filter.plugins";

    @Override
    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    @Override
    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }

    @Override
    public Options getOptions() {
        Options options = new Options();
        options.addOption("v", "verbose", false, "print all extracted text and other details to STDOUT");
        options.addOption("q", "quiet", false, "do not print anything except in the event of errors.");
        options.addOption("f", "force", false, "force all bitstreams to be processed");
        options.addOption("i", "identifier", true, "ONLY process bitstreams belonging to the provided handle identifier");
        options.addOption("m", "maximum", true, "process no more than maximum items");
        options.addOption("h", "help", false, "help");
        Option pluginOption = Option.builder((String)"p").longOpt("plugins").hasArg().hasArgs().valueSeparator(',').desc("ONLY run the specified Media Filter plugin(s)\nlisted from 'filter.plugins' in dspace.cfg.\nSeparate multiple with a comma (,)\n(e.g. MediaFilterManager -p \n\"Word Text Extractor\",\"PDF Text Extractor\")").build();
        options.addOption(pluginOption);
        options.addOption("d", "fromdate", true, "Process only item from specified last modified date");
        Option skipOption = Option.builder((String)"s").longOpt("skip").hasArg().hasArgs().valueSeparator(',').desc("SKIP the bitstreams belonging to identifier\nSeparate multiple identifiers with a comma (,)\n(e.g. MediaFilterManager -s \n 123456789/34,123456789/323)").build();
        options.addOption(skipOption);
        return options;
    }
}

